<?php

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class WebserviceContainer extends \PrestaShop\PrestaShop\Adapter\Container\LegacyContainer
{
    protected $parameters = [];
    protected \Closure $getService;

    public function __construct()
    {
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'employee' => true,
            'shop' => true,
        ];
        $this->methodMap = [
            'PrestaShop\\PrestaShop\\Adapter\\Bundle\\AssetsInstaller' => 'getAssetsInstallerService',
            'PrestaShop\\PrestaShop\\Adapter\\Configuration' => 'getConfigurationService',
            'PrestaShop\\PrestaShop\\Adapter\\ContextStateManager' => 'getContextStateManagerService',
            'PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider' => 'getCurrencyDataProviderService',
            'PrestaShop\\PrestaShop\\Adapter\\Employee\\EmployeeRepository' => 'getEmployeeRepositoryService',
            'PrestaShop\\PrestaShop\\Adapter\\LegacyContext' => 'getLegacyContextService',
            'PrestaShop\\PrestaShop\\Adapter\\Tools' => 'getToolsService',
            'PrestaShop\\PrestaShop\\Core\\Crypto\\Hashing' => 'getHashingService',
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\FeatureFlagStateCheckerInterface' => 'getFeatureFlagStateCheckerInterfaceService',
            'PrestaShop\\PrestaShop\\Core\\Hook\\HookModuleFilter' => 'getHookModuleFilterService',
            'PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository' => 'getLocaleRepositoryService',
            'PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository' => 'getRepositoryService',
            'Symfony\\Component\\HttpFoundation\\RequestStack' => 'getRequestStackService',
            'annotation_reader' => 'getAnnotationReaderService',
            'array' => 'getArrayService',
            'configuration' => 'getConfiguration2Service',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'context' => 'getContextService',
            'db' => 'getDbService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'prestashop.adapter.data_provider.country' => 'getPrestashop_Adapter_DataProvider_CountryService',
            'prestashop.adapter.employee_language_updater' => 'getPrestashop_Adapter_EmployeeLanguageUpdaterService',
            'prestashop.adapter.environment' => 'getPrestashop_Adapter_EnvironmentService',
            'prestashop.adapter.validate' => 'getPrestashop_Adapter_ValidateService',
            'prestashop.core.circuit_breaker.advanced_factory' => 'getPrestashop_Core_CircuitBreaker_AdvancedFactoryService',
            'prestashop.core.circuit_breaker.cache' => 'getPrestashop_Core_CircuitBreaker_CacheService',
            'prestashop.core.circuit_breaker.doctrine_cache' => 'getPrestashop_Core_CircuitBreaker_DoctrineCacheService',
            'prestashop.core.circuit_breaker.storage' => 'getPrestashop_Core_CircuitBreaker_StorageService',
            'prestashop.core.localization.cache.adapter' => 'getPrestashop_Core_Localization_Cache_AdapterService',
            'prestashop.core.localization.cldr.cache.adapter' => 'getPrestashop_Core_Localization_Cldr_Cache_AdapterService',
            'prestashop.core.localization.cldr.datalayer.locale_cache' => 'getPrestashop_Core_Localization_Cldr_Datalayer_LocaleCacheService',
            'prestashop.core.localization.cldr.datalayer.locale_reference' => 'getPrestashop_Core_Localization_Cldr_Datalayer_LocaleReferenceService',
            'prestashop.core.localization.cldr.locale_data_source' => 'getPrestashop_Core_Localization_Cldr_LocaleDataSourceService',
            'prestashop.core.localization.cldr.reader' => 'getPrestashop_Core_Localization_Cldr_ReaderService',
            'prestashop.core.localization.currency.datasource' => 'getPrestashop_Core_Localization_Currency_DatasourceService',
            'prestashop.core.localization.currency.middleware.cache' => 'getPrestashop_Core_Localization_Currency_Middleware_CacheService',
            'prestashop.core.localization.currency.middleware.database' => 'getPrestashop_Core_Localization_Currency_Middleware_DatabaseService',
            'prestashop.core.localization.currency.middleware.installed' => 'getPrestashop_Core_Localization_Currency_Middleware_InstalledService',
            'prestashop.core.localization.currency.middleware.reference' => 'getPrestashop_Core_Localization_Currency_Middleware_ReferenceService',
            'prestashop.core.localization.currency.repository' => 'getPrestashop_Core_Localization_Currency_RepositoryService',
            'prestashop.core.localization.locale.context_locale' => 'getPrestashop_Core_Localization_Locale_ContextLocaleService',
            'prestashop.database.naming_strategy' => 'getPrestashop_Database_NamingStrategyService',
            'prestashop.core.localization.cldr.locale_repository' => 'getPrestashop_Core_Localization_Cldr_LocaleRepositoryService',
            'prestashop.adapter.tools' => 'getPrestashop_Adapter_ToolsService',
        ];
        $this->aliases = [
            'PrestaShop\\PrestaShop\\Core\\Currency\\CurrencyDataProviderInterface' => 'PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider',
            'PrestaShop\\PrestaShop\\Core\\Localization\\LocaleInterface' => 'prestashop.core.localization.locale.context_locale',
            'PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\RepositoryInterface' => 'PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
            'hashing' => 'PrestaShop\\PrestaShop\\Core\\Crypto\\Hashing',
            'prestashop.adapter.context_state_manager' => 'PrestaShop\\PrestaShop\\Adapter\\ContextStateManager',
            'prestashop.adapter.data_provider.currency' => 'PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider',
            'prestashop.adapter.legacy.configuration' => 'PrestaShop\\PrestaShop\\Adapter\\Configuration',
            'prestashop.adapter.legacy.context' => 'PrestaShop\\PrestaShop\\Adapter\\LegacyContext',
            'prestashop.core.localization.cldr.datalayer.top_layer' => 'prestashop.core.localization.cldr.datalayer.locale_cache',
            'prestashop.core.localization.currency.middleware.top_layer' => 'prestashop.core.localization.currency.middleware.cache',
            'prestashop.core.localization.locale.repository' => 'PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository',
            'request_stack' => 'Symfony\\Component\\HttpFoundation\\RequestStack',
        ];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return [
            '.abstract.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer' => true,
            '.abstract.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer' => true,
            '.abstract.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer' => true,
            '.abstract.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer' => true,
            '.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\TypeLayerInterface.0.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer' => true,
            '.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\TypeLayerInterface.0.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer' => true,
            '.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\TypeLayerInterface.0.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer' => true,
            '.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\TypeLayerInterface.0.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer' => true,
            '.service_locator.fiyeV0.' => true,
            '.service_locator.lWqUA3s' => true,
            'Doctrine\\Bundle\\DoctrineBundle\\Controller\\ProfilerController' => true,
            'Doctrine\\Bundle\\DoctrineBundle\\Dbal\\ManagerRegistryAwareConnectionProvider' => true,
            'Doctrine\\Common\\Persistence\\ManagerRegistry' => true,
            'Doctrine\\DBAL\\Connection' => true,
            'Doctrine\\DBAL\\Connection $defaultConnection' => true,
            'Doctrine\\DBAL\\Driver\\Connection' => true,
            'Doctrine\\DBAL\\Tools\\Console\\Command\\RunSqlCommand' => true,
            'Doctrine\\ORM\\EntityManagerInterface' => true,
            'Doctrine\\ORM\\EntityManagerInterface $defaultEntityManager' => true,
            'Doctrine\\Persistence\\ManagerRegistry' => true,
            'PrestaShopBundle\\DependencyInjection\\CacheAdapterFactory' => true,
            'PrestaShopBundle\\DependencyInjection\\RuntimeConstEnvVarProcessor' => true,
            'PrestaShopBundle\\Entity\\Repository\\FeatureFlagRepository' => true,
            'PrestaShopBundle\\Entity\\Repository\\TabRepository' => true,
            'PrestaShop\\PrestaShop\\Adapter\\Country\\CountryDataProvider' => true,
            'PrestaShop\\PrestaShop\\Core\\EnvironmentInterface' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\FeatureFlagManager' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer' => true,
            'PrestaShop\\PrestaShop\\Core\\Security\\Hashing' => true,
            'data_collector.doctrine' => true,
            'doctrine.cache_clear_metadata_command' => true,
            'doctrine.cache_clear_query_cache_command' => true,
            'doctrine.cache_clear_result_command' => true,
            'doctrine.cache_collection_region_command' => true,
            'doctrine.clear_entity_region_command' => true,
            'doctrine.clear_query_region_command' => true,
            'doctrine.database_create_command' => true,
            'doctrine.database_drop_command' => true,
            'doctrine.dbal.connection' => true,
            'doctrine.dbal.connection.configuration' => true,
            'doctrine.dbal.connection.event_manager' => true,
            'doctrine.dbal.connection_factory' => true,
            'doctrine.dbal.default_connection.configuration' => true,
            'doctrine.dbal.default_connection.event_manager' => true,
            'doctrine.dbal.event_manager' => true,
            'doctrine.dbal.logger' => true,
            'doctrine.dbal.logger.backtrace' => true,
            'doctrine.dbal.logger.chain' => true,
            'doctrine.dbal.logger.profiling' => true,
            'doctrine.dbal.logging_middleware' => true,
            'doctrine.dbal.schema_asset_filter_manager' => true,
            'doctrine.dbal.well_known_schema_asset_filter' => true,
            'doctrine.ensure_production_settings_command' => true,
            'doctrine.mapping_convert_command' => true,
            'doctrine.mapping_import_command' => true,
            'doctrine.mapping_info_command' => true,
            'doctrine.orm.configuration' => true,
            'doctrine.orm.container_repository_factory' => true,
            'doctrine.orm.default_annotation_metadata_driver' => true,
            'doctrine.orm.default_configuration' => true,
            'doctrine.orm.default_entity_listener_resolver' => true,
            'doctrine.orm.default_entity_manager.event_manager' => true,
            'doctrine.orm.default_entity_manager.property_info_extractor' => true,
            'doctrine.orm.default_entity_manager.validator_loader' => true,
            'doctrine.orm.default_listeners.attach_entity_listeners' => true,
            'doctrine.orm.default_manager_configurator' => true,
            'doctrine.orm.default_metadata_cache' => true,
            'doctrine.orm.default_metadata_driver' => true,
            'doctrine.orm.default_query_cache' => true,
            'doctrine.orm.default_result_cache' => true,
            'doctrine.orm.entity_manager.abstract' => true,
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber' => true,
            'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber' => true,
            'doctrine.orm.listeners.resolve_target_entity' => true,
            'doctrine.orm.manager_configurator.abstract' => true,
            'doctrine.orm.messenger.doctrine_schema_subscriber' => true,
            'doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager' => true,
            'doctrine.orm.metadata.annotation_reader' => true,
            'doctrine.orm.naming_strategy.default' => true,
            'doctrine.orm.naming_strategy.underscore' => true,
            'doctrine.orm.naming_strategy.underscore_number_aware' => true,
            'doctrine.orm.proxy_cache_warmer' => true,
            'doctrine.orm.quote_strategy.ansi' => true,
            'doctrine.orm.quote_strategy.default' => true,
            'doctrine.orm.security.user.provider' => true,
            'doctrine.orm.validator.unique' => true,
            'doctrine.orm.validator_initializer' => true,
            'doctrine.query_dql_command' => true,
            'doctrine.query_sql_command' => true,
            'doctrine.schema_create_command' => true,
            'doctrine.schema_drop_command' => true,
            'doctrine.schema_update_command' => true,
            'doctrine.schema_validate_command' => true,
            'doctrine.twig.doctrine_extension' => true,
            'doctrine.ulid_generator' => true,
            'doctrine.uuid_generator' => true,
            'form.type.entity' => true,
            'form.type_guesser.doctrine' => true,
            'messenger.middleware.doctrine_close_connection' => true,
            'messenger.middleware.doctrine_open_transaction_logger' => true,
            'messenger.middleware.doctrine_ping_connection' => true,
            'messenger.middleware.doctrine_transaction' => true,
            'messenger.transport.doctrine.factory' => true,
            'prestashop.core.crypto.hashing' => true,
        ];
    }

    protected function createProxy($class, \Closure $factory)
    {
        return $factory();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Bundle\AssetsInstaller' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Bundle\AssetsInstaller
     */
    protected static function getAssetsInstallerService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Bundle\\AssetsInstaller'] = new \PrestaShop\PrestaShop\Adapter\Bundle\AssetsInstaller();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Configuration' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Configuration
     */
    protected static function getConfigurationService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Configuration'] = new \PrestaShop\PrestaShop\Adapter\Configuration();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\ContextStateManager' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\ContextStateManager
     */
    protected static function getContextStateManagerService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\ContextStateManager'] = new \PrestaShop\PrestaShop\Adapter\ContextStateManager(($container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] ?? self::getLegacyContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Currency\CurrencyDataProvider' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Currency\CurrencyDataProvider
     */
    protected static function getCurrencyDataProviderService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider'] = new \PrestaShop\PrestaShop\Adapter\Currency\CurrencyDataProvider(($container->services['PrestaShop\\PrestaShop\\Adapter\\Configuration'] ??= new \PrestaShop\PrestaShop\Adapter\Configuration()), ((($container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] ?? self::getLegacyContextService($container))->getContext()->shop) ? (($container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] ?? self::getLegacyContextService($container))->getContext()->shop->id) : (null)));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Employee\EmployeeRepository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Employee\EmployeeRepository
     */
    protected static function getEmployeeRepositoryService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Employee\\EmployeeRepository'] = new \PrestaShop\PrestaShop\Adapter\Employee\EmployeeRepository();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\LegacyContext' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\LegacyContext
     */
    protected static function getLegacyContextService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] = new \PrestaShop\PrestaShop\Adapter\LegacyContext('/mails/themes', ($container->services['PrestaShop\\PrestaShop\\Adapter\\Tools'] ??= new \PrestaShop\PrestaShop\Adapter\Tools()));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Tools' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Tools
     */
    protected static function getToolsService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Tools'] = new \PrestaShop\PrestaShop\Adapter\Tools();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\Crypto\Hashing' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Crypto\Hashing
     */
    protected static function getHashingService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Core\\Crypto\\Hashing'] = new \PrestaShop\PrestaShop\Core\Crypto\Hashing();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\FeatureFlag\FeatureFlagStateCheckerInterface' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\FeatureFlagManager
     */
    protected static function getFeatureFlagStateCheckerInterfaceService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\FeatureFlagStateCheckerInterface'] = $container->createProxy('FeatureFlagManagerGhostCd6d651', static fn () => \FeatureFlagManagerGhostCd6d651::createLazyGhost(static fn ($proxy) => self::getFeatureFlagStateCheckerInterfaceService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->privates['.service_locator.lWqUA3s'] ?? self::get_ServiceLocator_LWqUA3sService($container)), ($container->privates['PrestaShopBundle\\Entity\\Repository\\FeatureFlagRepository'] ?? self::getFeatureFlagRepositoryService($container))) && false ?: $lazyLoad);
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\Hook\HookModuleFilter' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Hook\HookModuleFilter
     */
    protected static function getHookModuleFilterService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Core\\Hook\\HookModuleFilter'] = new \PrestaShop\PrestaShop\Core\Hook\HookModuleFilter(new RewindableGenerator(fn () => new \EmptyIterator(), 0));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleRepository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleRepository
     */
    protected static function getLocaleRepositoryService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository'] = new \PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleRepository(($container->services['prestashop.core.localization.cldr.locale_data_source'] ?? self::getPrestashop_Core_Localization_Cldr_LocaleDataSourceService($container)));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\Localization\Locale\Repository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Locale\Repository
     */
    protected static function getRepositoryService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository'] = new \PrestaShop\PrestaShop\Core\Localization\Locale\Repository(($container->services['PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository'] ?? self::getLocaleRepositoryService($container)), ($container->services['prestashop.core.localization.currency.repository'] ?? self::getPrestashop_Core_Localization_Currency_RepositoryService($container)));
    }

    /**
     * Gets the public 'Symfony\Component\HttpFoundation\RequestStack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected static function getRequestStackService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['Symfony\\Component\\HttpFoundation\\RequestStack'] = $container->createProxy('RequestStackProxy37f0788', static fn () => \RequestStackProxy37f0788::createLazyProxy(static fn () => self::getRequestStackService($container, false)));
        }

        return \PrestaShopBundle\Http\RequestStackFactory::buildRequestStack();
    }

    /**
     * Gets the public 'annotation_reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\AnnotationReader
     */
    protected static function getAnnotationReaderService($container)
    {
        return $container->services['annotation_reader'] = new \Doctrine\Common\Annotations\AnnotationReader();
    }

    /**
     * Gets the public 'array' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getArrayService($container)
    {
        return $container->services['array'] = (new \PrestaShopBundle\DependencyInjection\CacheAdapterFactory())->getCacheAdapter('array');
    }

    /**
     * Gets the public 'configuration' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Configuration
     */
    protected static function getConfiguration2Service($container)
    {
        return $container->services['configuration'] = new \PrestaShop\PrestaShop\Adapter\Configuration();
    }

    /**
     * Gets the public 'container.env_var_processors_locator' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function getContainer_EnvVarProcessorsLocatorService($container)
    {
        return $container->services['container.env_var_processors_locator'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'const' => ['privates', 'PrestaShopBundle\\DependencyInjection\\RuntimeConstEnvVarProcessor', 'getRuntimeConstEnvVarProcessorService', false],
        ], [
            'const' => '?',
        ]);
    }

    /**
     * Gets the public 'context' shared service.
     *
     * @return \Context
     */
    protected static function getContextService($container)
    {
        return $container->services['context'] = \Context::getContext();
    }

    /**
     * Gets the public 'db' shared service.
     *
     * @return \Db
     */
    protected static function getDbService($container)
    {
        return $container->services['db'] = \Db::getInstance();
    }

    /**
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected static function getDoctrineService($container)
    {
        return $container->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($container, $container->parameters['doctrine.connections'], $container->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /**
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \PrestaShopBundle\Doctrine\DatabaseConnection
     */
    protected static function getDoctrine_Dbal_DefaultConnectionService($container)
    {
        return $container->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory([]))->createConnection(['driver' => 'pdo_mysql', 'host' => 'localhost', 'port' => '', 'dbname' => 'fletcher_pres111', 'user' => 'fletcher_pres111', 'password' => ')1!1S7T37p', 'charset' => 'utf8mb4', 'driverOptions' => [1002 => 'SET sql_mode=(SELECT REPLACE(@@sql_mode,\'ONLY_FULL_GROUP_BY\',\'\'))', 1013 => $container->getEnv('const:runtime:_PS_ALLOW_MULTI_STATEMENTS_QUERIES_')], 'wrapperClass' => 'PrestaShopBundle\\Doctrine\\DatabaseConnection', 'defaultTableOptions' => []], new \Doctrine\DBAL\Configuration(), new \Symfony\Bridge\Doctrine\ContainerAwareEventManager($container), ['enum' => 'string']);
    }

    /**
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected static function getDoctrine_Orm_DefaultEntityManagerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['doctrine.orm.default_entity_manager'] = $container->createProxy('EntityManagerProxy196c39a', static fn () => \EntityManagerProxy196c39a::createLazyProxy(static fn () => self::getDoctrine_Orm_DefaultEntityManagerService($container, false)));
        }

        $instance = \Doctrine\ORM\EntityManager::create(($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), ($container->privates['doctrine.orm.default_configuration'] ?? self::getDoctrine_Orm_DefaultConfigurationService($container)));

        ($container->privates['doctrine.orm.default_manager_configurator'] ??= new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator([], []))->configure($instance);

        return $instance;
    }

    /**
     * Gets the public 'prestashop.adapter.data_provider.country' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Country\CountryDataProvider
     */
    protected static function getPrestashop_Adapter_DataProvider_CountryService($container)
    {
        return $container->services['prestashop.adapter.data_provider.country'] = new \PrestaShop\PrestaShop\Adapter\Country\CountryDataProvider();
    }

    /**
     * Gets the public 'prestashop.adapter.employee_language_updater' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Employee\EmployeeLanguageUpdater
     */
    protected static function getPrestashop_Adapter_EmployeeLanguageUpdaterService($container)
    {
        return $container->services['prestashop.adapter.employee_language_updater'] = new \PrestaShop\PrestaShop\Adapter\Employee\EmployeeLanguageUpdater(($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), 'psmm_', ($container->services['PrestaShop\\PrestaShop\\Adapter\\Configuration'] ??= new \PrestaShop\PrestaShop\Adapter\Configuration())->get("PS_LANG_DEFAULT"));
    }

    /**
     * Gets the public 'prestashop.adapter.environment' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Environment
     */
    protected static function getPrestashop_Adapter_EnvironmentService($container)
    {
        return $container->services['prestashop.adapter.environment'] = new \PrestaShop\PrestaShop\Adapter\Environment(false, 'prod', 'front');
    }

    /**
     * Gets the public 'prestashop.adapter.validate' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Validate
     */
    protected static function getPrestashop_Adapter_ValidateService($container)
    {
        return $container->services['prestashop.adapter.validate'] = new \PrestaShop\PrestaShop\Adapter\Validate();
    }

    /**
     * Gets the public 'prestashop.core.circuit_breaker.advanced_factory' shared service.
     *
     * @return \PrestaShop\CircuitBreaker\AdvancedCircuitBreakerFactory
     */
    protected static function getPrestashop_Core_CircuitBreaker_AdvancedFactoryService($container)
    {
        return $container->services['prestashop.core.circuit_breaker.advanced_factory'] = new \PrestaShop\CircuitBreaker\AdvancedCircuitBreakerFactory();
    }

    /**
     * Gets the public 'prestashop.core.circuit_breaker.cache' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getPrestashop_Core_CircuitBreaker_CacheService($container)
    {
        return $container->services['prestashop.core.circuit_breaker.cache'] = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('', 0, (($container->services['prestashop.adapter.environment'] ??= new \PrestaShop\PrestaShop\Adapter\Environment(false, 'prod', 'front'))->getCacheDir() . "/circuit_breaker"));
    }

    /**
     * Gets the public 'prestashop.core.circuit_breaker.doctrine_cache' shared service.
     *
     * @return \Doctrine\Common\Cache\Psr6\DoctrineProvider
     */
    protected static function getPrestashop_Core_CircuitBreaker_DoctrineCacheService($container)
    {
        return $container->services['prestashop.core.circuit_breaker.doctrine_cache'] = \Doctrine\Common\Cache\Psr6\DoctrineProvider::wrap(($container->services['prestashop.core.circuit_breaker.cache'] ?? self::getPrestashop_Core_CircuitBreaker_CacheService($container)));
    }

    /**
     * Gets the public 'prestashop.core.circuit_breaker.storage' shared service.
     *
     * @return \PrestaShop\CircuitBreaker\Storage\DoctrineCache
     */
    protected static function getPrestashop_Core_CircuitBreaker_StorageService($container)
    {
        return $container->services['prestashop.core.circuit_breaker.storage'] = new \PrestaShop\CircuitBreaker\Storage\DoctrineCache(($container->services['prestashop.core.circuit_breaker.doctrine_cache'] ?? self::getPrestashop_Core_CircuitBreaker_DoctrineCacheService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.cache.adapter' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\ArrayAdapter
     */
    protected static function getPrestashop_Core_Localization_Cache_AdapterService($container)
    {
        return $container->services['prestashop.core.localization.cache.adapter'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.cache.adapter' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getPrestashop_Core_Localization_Cldr_Cache_AdapterService($container)
    {
        return $container->services['prestashop.core.localization.cldr.cache.adapter'] = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('CLDR', 0, '/home/fletcher/public_html/fletchermall.com/var/cache/prod//localization');
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.datalayer.locale_cache' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\DataLayer\LocaleCache
     */
    protected static function getPrestashop_Core_Localization_Cldr_Datalayer_LocaleCacheService($container)
    {
        $container->services['prestashop.core.localization.cldr.datalayer.locale_cache'] = $instance = new \PrestaShop\PrestaShop\Core\Localization\CLDR\DataLayer\LocaleCache(($container->services['prestashop.core.localization.cldr.cache.adapter'] ??= new \Symfony\Component\Cache\Adapter\FilesystemAdapter('CLDR', 0, '/home/fletcher/public_html/fletchermall.com/var/cache/prod//localization')));

        $instance->setLowerLayer(($container->services['prestashop.core.localization.cldr.datalayer.locale_reference'] ?? self::getPrestashop_Core_Localization_Cldr_Datalayer_LocaleReferenceService($container)));

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.datalayer.locale_reference' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\DataLayer\LocaleReference
     */
    protected static function getPrestashop_Core_Localization_Cldr_Datalayer_LocaleReferenceService($container)
    {
        return $container->services['prestashop.core.localization.cldr.datalayer.locale_reference'] = new \PrestaShop\PrestaShop\Core\Localization\CLDR\DataLayer\LocaleReference(($container->services['prestashop.core.localization.cldr.reader'] ??= new \PrestaShop\PrestaShop\Core\Localization\CLDR\Reader()));
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.locale_data_source' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleDataSource
     */
    protected static function getPrestashop_Core_Localization_Cldr_LocaleDataSourceService($container)
    {
        return $container->services['prestashop.core.localization.cldr.locale_data_source'] = new \PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleDataSource(($container->services['prestashop.core.localization.cldr.datalayer.locale_cache'] ?? self::getPrestashop_Core_Localization_Cldr_Datalayer_LocaleCacheService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.reader' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\Reader
     */
    protected static function getPrestashop_Core_Localization_Cldr_ReaderService($container)
    {
        return $container->services['prestashop.core.localization.cldr.reader'] = new \PrestaShop\PrestaShop\Core\Localization\CLDR\Reader();
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.datasource' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\CurrencyDataSource
     */
    protected static function getPrestashop_Core_Localization_Currency_DatasourceService($container)
    {
        return $container->services['prestashop.core.localization.currency.datasource'] = new \PrestaShop\PrestaShop\Core\Localization\Currency\CurrencyDataSource(($container->services['prestashop.core.localization.currency.middleware.cache'] ?? self::getPrestashop_Core_Localization_Currency_Middleware_CacheService($container)), ($container->services['prestashop.core.localization.currency.middleware.installed'] ?? self::getPrestashop_Core_Localization_Currency_Middleware_InstalledService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.middleware.cache' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyCache
     */
    protected static function getPrestashop_Core_Localization_Currency_Middleware_CacheService($container)
    {
        $container->services['prestashop.core.localization.currency.middleware.cache'] = $instance = new \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyCache(($container->services['prestashop.core.localization.cache.adapter'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()));

        $instance->setLowerLayer(($container->services['prestashop.core.localization.currency.middleware.database'] ?? self::getPrestashop_Core_Localization_Currency_Middleware_DatabaseService($container)));

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.middleware.database' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyDatabase
     */
    protected static function getPrestashop_Core_Localization_Currency_Middleware_DatabaseService($container)
    {
        $container->services['prestashop.core.localization.currency.middleware.database'] = $instance = new \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyDatabase(($container->services['PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider'] ?? self::getCurrencyDataProviderService($container)));

        $instance->setLowerLayer(($container->services['prestashop.core.localization.currency.middleware.reference'] ?? self::getPrestashop_Core_Localization_Currency_Middleware_ReferenceService($container)));

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.middleware.installed' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyInstalled
     */
    protected static function getPrestashop_Core_Localization_Currency_Middleware_InstalledService($container)
    {
        return $container->services['prestashop.core.localization.currency.middleware.installed'] = new \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyInstalled(($container->services['PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider'] ?? self::getCurrencyDataProviderService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.middleware.reference' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyReference
     */
    protected static function getPrestashop_Core_Localization_Currency_Middleware_ReferenceService($container)
    {
        return $container->services['prestashop.core.localization.currency.middleware.reference'] = new \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyReference(($container->services['PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository'] ?? self::getLocaleRepositoryService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.repository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\Repository
     */
    protected static function getPrestashop_Core_Localization_Currency_RepositoryService($container)
    {
        return $container->services['prestashop.core.localization.currency.repository'] = new \PrestaShop\PrestaShop\Core\Localization\Currency\Repository(($container->services['prestashop.core.localization.currency.datasource'] ?? self::getPrestashop_Core_Localization_Currency_DatasourceService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.locale.context_locale' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Locale
     */
    protected static function getPrestashop_Core_Localization_Locale_ContextLocaleService($container)
    {
        return $container->services['prestashop.core.localization.locale.context_locale'] = ($container->services['PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository'] ?? self::getRepositoryService($container))->getLocale(($container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] ?? self::getLegacyContextService($container))->getContext()->language->getLocale());
    }

    /**
     * Gets the public 'prestashop.database.naming_strategy' shared service.
     *
     * @return \PrestaShopBundle\Service\Database\DoctrineNamingStrategy
     */
    protected static function getPrestashop_Database_NamingStrategyService($container)
    {
        return $container->services['prestashop.database.naming_strategy'] = new \PrestaShopBundle\Service\Database\DoctrineNamingStrategy(($container->services['annotation_reader'] ??= new \Doctrine\Common\Annotations\AnnotationReader()), 'psmm_');
    }

    /**
     * Gets the private '.service_locator.lWqUA3s' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function get_ServiceLocator_LWqUA3sService($container)
    {
        return $container->privates['.service_locator.lWqUA3s'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'env' => ['privates', 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer', 'getEnvLayerService', false],
            'db' => ['privates', 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer', 'getDbLayerService', false],
            'dotenv' => ['privates', 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer', 'getDotEnvLayerService', false],
            'query' => ['privates', 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer', 'getQueryLayerService', false],
        ], [
            'env' => 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer',
            'db' => 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer',
            'dotenv' => 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer',
            'query' => 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer',
        ]);
    }

    /**
     * Gets the private 'PrestaShopBundle\DependencyInjection\RuntimeConstEnvVarProcessor' shared service.
     *
     * @return \PrestaShopBundle\DependencyInjection\RuntimeConstEnvVarProcessor
     */
    protected static function getRuntimeConstEnvVarProcessorService($container)
    {
        return $container->privates['PrestaShopBundle\\DependencyInjection\\RuntimeConstEnvVarProcessor'] = new \PrestaShopBundle\DependencyInjection\RuntimeConstEnvVarProcessor();
    }

    /**
     * Gets the private 'PrestaShopBundle\Entity\Repository\FeatureFlagRepository' shared service.
     *
     * @return \PrestaShopBundle\Entity\Repository\FeatureFlagRepository
     */
    protected static function getFeatureFlagRepositoryService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShopBundle\\Entity\\Repository\\FeatureFlagRepository'] = $container->createProxy('FeatureFlagRepositoryProxy2ee44cd', static fn () => \FeatureFlagRepositoryProxy2ee44cd::createLazyProxy(static fn () => self::getFeatureFlagRepositoryService($container, false)));
        }

        return ($container->services['doctrine.orm.default_entity_manager'] ?? self::getDoctrine_Orm_DefaultEntityManagerService($container))->getRepository('PrestaShopBundle\\Entity\\FeatureFlag');
    }

    /**
     * Gets the private 'PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DbLayer' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DbLayer
     */
    protected static function getDbLayerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer'] = $container->createProxy('DbLayerGhost48291a0', static fn () => \DbLayerGhost48291a0::createLazyGhost(static fn ($proxy) => self::getDbLayerService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->privates['PrestaShopBundle\\Entity\\Repository\\FeatureFlagRepository'] ?? self::getFeatureFlagRepositoryService($container))) && false ?: $lazyLoad);
    }

    /**
     * Gets the private 'PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DotEnvLayer' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DotEnvLayer
     */
    protected static function getDotEnvLayerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer'] = $container->createProxy('DotEnvLayerGhost79d403f', static fn () => \DotEnvLayerGhost79d403f::createLazyGhost(static fn ($proxy) => self::getDotEnvLayerService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->services['prestashop.adapter.environment'] ??= new \PrestaShop\PrestaShop\Adapter\Environment(false, 'prod', 'front')), '/home/fletcher/public_html/fletchermall.com') && false ?: $lazyLoad);
    }

    /**
     * Gets the private 'PrestaShop\PrestaShop\Core\FeatureFlag\Layer\EnvLayer' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\EnvLayer
     */
    protected static function getEnvLayerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer'] = $container->createProxy('EnvLayerGhostC2b5ebd', static fn () => \EnvLayerGhostC2b5ebd::createLazyGhost(static fn ($proxy) => self::getEnvLayerService($container, $proxy)));
        }

        return $lazyLoad;
    }

    /**
     * Gets the private 'PrestaShop\PrestaShop\Core\FeatureFlag\Layer\QueryLayer' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\QueryLayer
     */
    protected static function getQueryLayerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer'] = $container->createProxy('QueryLayerGhost7f48906', static fn () => \QueryLayerGhost7f48906::createLazyGhost(static fn ($proxy) => self::getQueryLayerService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->services['prestashop.adapter.environment'] ??= new \PrestaShop\PrestaShop\Adapter\Environment(false, 'prod', 'front')), ($container->services['Symfony\\Component\\HttpFoundation\\RequestStack'] ?? self::getRequestStackService($container))) && false ?: $lazyLoad);
    }

    /**
     * Gets the private 'doctrine.orm.default_configuration' shared service.
     *
     * @return \Doctrine\ORM\Configuration
     */
    protected static function getDoctrine_Orm_DefaultConfigurationService($container)
    {
        $container->privates['doctrine.orm.default_configuration'] = $instance = new \Doctrine\ORM\Configuration();

        $a = ($container->services['array'] ?? self::getArrayService($container));
        $b = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();

        $c = ($container->services['annotation_reader'] ??= new \Doctrine\Common\Annotations\AnnotationReader());

        $b->addDriver(new \Doctrine\ORM\Mapping\Driver\AnnotationDriver($c, ['/home/fletcher/public_html/fletchermall.com/src/PrestaShopBundle/Entity']), 'PrestaShop');
        $b->addDriver(new \Doctrine\ORM\Mapping\Driver\AnnotationDriver($c, ['/home/fletcher/public_html/fletchermall.com/modules/productcomments/src/Entity']), 'PrestaShop\\Module\\ProductComment\\Entity');
        $b->addDriver(new \Doctrine\ORM\Mapping\Driver\AnnotationDriver($c, ['/home/fletcher/public_html/fletchermall.com/modules/psshipping/src/Entity']), 'PrestaShop\\Module\\Psshipping\\Entity');
        $b->addDriver(new \Doctrine\ORM\Mapping\Driver\AnnotationDriver($c, ['/home/fletcher/public_html/fletchermall.com/modules/ps_accounts/src/Entity']), 'PrestaShop\\Module\\PsAccounts\\Entity');

        $instance->setEntityNamespaces(['PrestaShopBundle\\Entity' => 'PrestaShop']);
        $instance->setMetadataCache($a);
        $instance->setQueryCache($a);
        $instance->setResultCache($a);
        $instance->setMetadataDriverImpl($b);
        $instance->setProxyDir('/home/fletcher/public_html/fletchermall.com/var/cache/prod//doctrine/orm/Proxies');
        $instance->setProxyNamespace('Proxies');
        $instance->setAutoGenerateProxyClasses(false);
        $instance->setClassMetadataFactoryName('Doctrine\\ORM\\Mapping\\ClassMetadataFactory');
        $instance->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $instance->setNamingStrategy(($container->services['prestashop.database.naming_strategy'] ?? self::getPrestashop_Database_NamingStrategyService($container)));
        $instance->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $instance->setEntityListenerResolver(new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver($container));
        $instance->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(new \Symfony\Component\DependencyInjection\ServiceLocator([])));
        $instance->addCustomStringFunction('regexp', 'DoctrineExtensions\\Query\\Mysql\\Regexp');
        $instance->addCustomStringFunction('binary', 'DoctrineExtensions\\Query\\Mysql\\Binary');

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.locale_repository' alias.
     *
     * @return object The "PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleRepository" service.
     */
    protected static function getPrestashop_Core_Localization_Cldr_LocaleRepositoryService($container)
    {
        trigger_deprecation('PrestaShop/PrestaShop', '9', 'The "prestashop.core.localization.cldr.locale_repository" service alias is deprecated. You should stop using it, as it will be removed in the future.');

        return $container->get('PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository');
    }

    /**
     * Gets the public 'prestashop.adapter.tools' alias.
     *
     * @return object The "PrestaShop\PrestaShop\Adapter\Tools" service.
     */
    protected static function getPrestashop_Adapter_ToolsService($container)
    {
        trigger_deprecation('PrestaShop\\PrestaShop', '8.1', 'The "prestashop.adapter.tools" service alias is deprecated. You should stop using it, as it will be removed in the future.');

        return $container->get('PrestaShop\\PrestaShop\\Adapter\\Tools');
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new ParameterNotFoundException($name);
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (!isset($this->parameterBag)) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        throw new ParameterNotFoundException($name);
    }

    protected function getDefaultParameters(): array
    {
        return [
            'database_host' => 'localhost',
            'database_port' => '',
            'database_name' => 'fletcher_pres111',
            'database_user' => 'fletcher_pres111',
            'database_password' => ')1!1S7T37p',
            'database_prefix' => 'psmm_',
            'database_engine' => 'InnoDB',
            'mailer_transport' => 'smtp',
            'mailer_host' => '127.0.0.1',
            'mailer_user' => NULL,
            'mailer_password' => NULL,
            'secret' => 'qidyrksyroeyjcagrdpkmosafjrcdo9nswcuugjjkp8lnoptyazq4xdgysm0z6hy',
            'ps_caching' => 'CacheMemcache',
            'ps_cache_enable' => false,
            'ps_creation_date' => '2026-02-20',
            'locale' => 'en-US',
            'cookie_key' => 'nsjztixpsjjsgmyyyyadnq4pzhkphwi7uvor9vnfeofrgpeiz2rfu6r9c1cgxjir',
            'cookie_iv' => 'exz59dzt4hmrrfee0z4io2l28v4k6qq4',
            'use_debug_toolbar' => true,
            'new_cookie_key' => 'def000008267c978914d40b59d589cd786ace69eef211a260f3d56c136e6a1abd40888cd0557ebcba7d2e80017af1ed7771d066f2806f458dd8a2a7be43cc6bd5137868c',
            'api_public_key' => '-----BEGIN PUBLIC KEY-----'."\n".'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwEr+Wlmsudz/aVcks6Zd'."\n".'V2nUMfNSm9Vp6wsWMyKV1IEiz9BoVzrVcL4RibkJjtT9YgmJQPObqw19luSurW6W'."\n".'07sSzsqO5PYgT5dA+ejqaOwERkqs7unwui0P2g8BWTK8yT1nSYVPH46XZmTK9HIb'."\n".'F3sMYZHpFAJFDuu9iL2dwQ0On4hbAZ7jiZXlPlR9DcMVEjpPCcLqFEv34S02dpGG'."\n".'WKn6qt4PDdBhJ8ECI9ty/iUOyIqw2dEgrz7b5IHNNEOH04XX7gaQiz/49QCVOALi'."\n".'h0JqjMdWfrfdVRKNum93XOkTnQtWiD3hJRPe2dps2O4mYELUeb+60Hl0ED/odS7f'."\n".'JwIDAQAB'."\n".'-----END PUBLIC KEY-----'."\n".'',
            'api_private_key' => '-----BEGIN PRIVATE KEY-----'."\n".'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDASv5aWay53P9p'."\n".'VySzpl1XadQx81Kb1WnrCxYzIpXUgSLP0GhXOtVwvhGJuQmO1P1iCYlA85urDX2W'."\n".'5K6tbpbTuxLOyo7k9iBPl0D56Opo7ARGSqzu6fC6LQ/aDwFZMrzJPWdJhU8fjpdm'."\n".'ZMr0chsXewxhkekUAkUO672IvZ3BDQ6fiFsBnuOJleU+VH0NwxUSOk8JwuoUS/fh'."\n".'LTZ2kYZYqfqq3g8N0GEnwQIj23L+JQ7IirDZ0SCvPtvkgc00Q4fThdfuBpCLP/j1'."\n".'AJU4AuKHQmqMx1Z+t91VEo26b3dc6ROdC1aIPeElE97Z2mzY7iZgQtR5v7rQeXQQ'."\n".'P+h1Lt8nAgMBAAECggEAKh6DFiE8Tz3UCCvZUyxml6YLn6FPf+jAGYbFJxA1R2W9'."\n".'zU01/Z1acSaAyuzn5gxLL/UsxjhV6aK71philoR5rwjz9q2xnP84Vpan2dWlurOv'."\n".'wAHNXUuKugzywu20eug9J8s2W4lCqoPeL8R2HBL+UidWr+x45DQXEkyaqF/4NPeY'."\n".'4gI3gcQM0/smmkdETk2Jv1KAOVJV5KaahyosPBpdIhUbxXvQN/BBxPeg+X4l2DJy'."\n".'IPXnSMRhW8IQQzdf60TvqqauqxAkDj5j+qzIsbXM2WNaPeOXu961gx1sIOio7xoS'."\n".'Wh4w9IuMFolT7SQj8MDMabsShh/rq8iEMoAitnI08QKBgQDpMbNMWNtQY3b6Laj1'."\n".'wqp/hdw5pZhRrd9t1hWiIEHNPzjyZGCbe9ZTmOqVY5/c9y4io2nVoc4BO0UziiPS'."\n".'RK2lYce8IRzJCObe1wKvCQnnW3kUMSgDsibovGBl1Bmh7DibawHQF/tdRleEq48B'."\n".'hA/EZMZ0yMszw8/INPP1nLwjWQKBgQDTGUglQS1RIPMOIs8dHszl2ubf6WiLitlW'."\n".'mQjJ0J7q3V+8hqByM5NWUI5OoMEimkOeWRg4dU/bs3kKwNhMPsTSz8pRoGLnA519'."\n".'UuPkLWT4i9D6B47jPgPeJbBVHp8h3GvkPsvbBw0OiruGD4xnMi/qIbrkvlcY02nz'."\n".'2aZqCMdGfwKBgQCvccgfCb8/VQYfpZi4BhS2yuRsrqzRzwoJngc6qiA3pnhWzbRt'."\n".'ZpdS3/qmGIUe/w1D3ER1CT5vaMNgym629RrcEZvva843Zi4kvAl13UwJN6X5zh33'."\n".'4eIqOgggtJnwXEQekjyT7mccvx57X4PBNTWToeo51RQkxw6d51EgmiJmSQKBgAR9'."\n".'ey1fr4kUPFdGokUqTI1vFI4atuCQ+YKACtHQIDE6uDiYXH1RX4bse7psbO9BfMK3'."\n".'fm5lAGfZ728tHuywQRuC0/jcgn4Lc6QgyTwnQwiOYMmQs5dd0FM/VfrZheUAfUMD'."\n".'mu5zvfFbPhXh6sifJqnCQelvqwaaKJzJOmLzANodAoGBAKwZB1noUZCOcqoVgu56'."\n".'c4fN6Qw3ioutXmq9RHHW79rWwS2/n9J51wqMN9/WNqN5NmLi02iJKHB2SAuquJ0y'."\n".'eT9kF1+tGCVVMmu/ZBK2sl1q+yNTmbtPzeW5VFfGE14tEGNJi2wXwms2E8lRaW2E'."\n".'vcslv/tYQk6TLNoa8pFHeYjZ'."\n".'-----END PRIVATE KEY-----'."\n".'',
            'cache.driver' => 'array',
            'cache.adapter' => 'cache.adapter.array',
            'kernel.bundles' => [

            ],
            'kernel.name' => 'app',
            'kernel.debug' => false,
            'kernel.environment' => 'prod',
            'kernel.app_id' => 'front',
            'kernel.cache_dir' => '/home/fletcher/public_html/fletchermall.com/var/cache/prod/',
            'kernel.active_modules' => [
                0 => 'blockreassurance',
                1 => 'blockwishlist',
                2 => 'contactform',
                3 => 'dashactivity',
                4 => 'dashgoals',
                5 => 'dashproducts',
                6 => 'dashtrends',
                7 => 'graphnvd3',
                8 => 'gridhtml',
                9 => 'gsitemap',
                10 => 'pagesnotfound',
                11 => 'productcomments',
                12 => 'psgdpr',
                13 => 'psshipping',
                14 => 'psxmarketingwithgoogle',
                15 => 'ps_accounts',
                16 => 'ps_apiresources',
                17 => 'ps_banner',
                18 => 'ps_bestsellers',
                19 => 'ps_brandlist',
                20 => 'ps_cashondelivery',
                21 => 'ps_categoryproducts',
                22 => 'ps_categorytree',
                23 => 'ps_checkout',
                24 => 'ps_checkpayment',
                25 => 'ps_classic_edition',
                26 => 'ps_contactinfo',
                27 => 'ps_crossselling',
                28 => 'ps_currencyselector',
                29 => 'ps_customeraccountlinks',
                30 => 'ps_customersignin',
                31 => 'ps_customtext',
                32 => 'ps_dataprivacy',
                33 => 'ps_distributionapiclient',
                34 => 'ps_emailalerts',
                35 => 'ps_emailsubscription',
                36 => 'ps_eventbus',
                37 => 'ps_facebook',
                38 => 'ps_facetedsearch',
                39 => 'ps_faviconnotificationbo',
                40 => 'ps_featuredproducts',
                41 => 'ps_googleanalytics',
                42 => 'ps_imageslider',
                43 => 'ps_languageselector',
                44 => 'ps_linklist',
                45 => 'ps_mainmenu',
                46 => 'ps_mbo',
                47 => 'ps_newproducts',
                48 => 'ps_searchbar',
                49 => 'ps_sharebuttons',
                50 => 'ps_shoppingcart',
                51 => 'ps_socialfollow',
                52 => 'ps_specials',
                53 => 'ps_supplierlist',
                54 => 'ps_themecusto',
                55 => 'ps_viewedproduct',
                56 => 'ps_wirepayment',
                57 => 'statsbestcategories',
                58 => 'statsbestcustomers',
                59 => 'statsbestmanufacturers',
                60 => 'statsbestproducts',
                61 => 'statsbestsuppliers',
                62 => 'statsbestvouchers',
                63 => 'statscarrier',
                64 => 'statscatalog',
                65 => 'statscheckup',
                66 => 'statsdata',
                67 => 'statsforecast',
                68 => 'statsnewsletter',
                69 => 'statspersonalinfos',
                70 => 'statsproduct',
                71 => 'statsregistrations',
                72 => 'statssales',
                73 => 'statssearch',
                74 => 'statsstock',
            ],
            'prestashop.active_modules' => [
                0 => 'blockreassurance',
                1 => 'blockwishlist',
                2 => 'contactform',
                3 => 'dashactivity',
                4 => 'dashgoals',
                5 => 'dashproducts',
                6 => 'dashtrends',
                7 => 'graphnvd3',
                8 => 'gridhtml',
                9 => 'gsitemap',
                10 => 'pagesnotfound',
                11 => 'productcomments',
                12 => 'psgdpr',
                13 => 'psshipping',
                14 => 'psxmarketingwithgoogle',
                15 => 'ps_accounts',
                16 => 'ps_apiresources',
                17 => 'ps_banner',
                18 => 'ps_bestsellers',
                19 => 'ps_brandlist',
                20 => 'ps_cashondelivery',
                21 => 'ps_categoryproducts',
                22 => 'ps_categorytree',
                23 => 'ps_checkout',
                24 => 'ps_checkpayment',
                25 => 'ps_classic_edition',
                26 => 'ps_contactinfo',
                27 => 'ps_crossselling',
                28 => 'ps_currencyselector',
                29 => 'ps_customeraccountlinks',
                30 => 'ps_customersignin',
                31 => 'ps_customtext',
                32 => 'ps_dataprivacy',
                33 => 'ps_distributionapiclient',
                34 => 'ps_emailalerts',
                35 => 'ps_emailsubscription',
                36 => 'ps_eventbus',
                37 => 'ps_facebook',
                38 => 'ps_facetedsearch',
                39 => 'ps_faviconnotificationbo',
                40 => 'ps_featuredproducts',
                41 => 'ps_googleanalytics',
                42 => 'ps_imageslider',
                43 => 'ps_languageselector',
                44 => 'ps_linklist',
                45 => 'ps_mainmenu',
                46 => 'ps_mbo',
                47 => 'ps_newproducts',
                48 => 'ps_searchbar',
                49 => 'ps_sharebuttons',
                50 => 'ps_shoppingcart',
                51 => 'ps_socialfollow',
                52 => 'ps_specials',
                53 => 'ps_supplierlist',
                54 => 'ps_themecusto',
                55 => 'ps_viewedproduct',
                56 => 'ps_wirepayment',
                57 => 'statsbestcategories',
                58 => 'statsbestcustomers',
                59 => 'statsbestmanufacturers',
                60 => 'statsbestproducts',
                61 => 'statsbestsuppliers',
                62 => 'statsbestvouchers',
                63 => 'statscarrier',
                64 => 'statscatalog',
                65 => 'statscheckup',
                66 => 'statsdata',
                67 => 'statsforecast',
                68 => 'statsnewsletter',
                69 => 'statspersonalinfos',
                70 => 'statsproduct',
                71 => 'statsregistrations',
                72 => 'statssales',
                73 => 'statssearch',
                74 => 'statsstock',
            ],
            'prestashop.installed_modules' => [
                0 => 'blockreassurance',
                1 => 'blockwishlist',
                2 => 'contactform',
                3 => 'dashactivity',
                4 => 'dashgoals',
                5 => 'dashproducts',
                6 => 'dashtrends',
                7 => 'graphnvd3',
                8 => 'gridhtml',
                9 => 'gsitemap',
                10 => 'pagesnotfound',
                11 => 'productcomments',
                12 => 'psgdpr',
                13 => 'psshipping',
                14 => 'psxmarketingwithgoogle',
                15 => 'ps_accounts',
                16 => 'ps_apiresources',
                17 => 'ps_banner',
                18 => 'ps_bestsellers',
                19 => 'ps_brandlist',
                20 => 'ps_cashondelivery',
                21 => 'ps_categoryproducts',
                22 => 'ps_categorytree',
                23 => 'ps_checkout',
                24 => 'ps_checkpayment',
                25 => 'ps_classic_edition',
                26 => 'ps_contactinfo',
                27 => 'ps_crossselling',
                28 => 'ps_currencyselector',
                29 => 'ps_customeraccountlinks',
                30 => 'ps_customersignin',
                31 => 'ps_customtext',
                32 => 'ps_dataprivacy',
                33 => 'ps_distributionapiclient',
                34 => 'ps_emailalerts',
                35 => 'ps_emailsubscription',
                36 => 'ps_eventbus',
                37 => 'ps_facebook',
                38 => 'ps_facetedsearch',
                39 => 'ps_faviconnotificationbo',
                40 => 'ps_featuredproducts',
                41 => 'ps_googleanalytics',
                42 => 'ps_imageslider',
                43 => 'ps_languageselector',
                44 => 'ps_linklist',
                45 => 'ps_mainmenu',
                46 => 'ps_mbo',
                47 => 'ps_newproducts',
                48 => 'ps_searchbar',
                49 => 'ps_sharebuttons',
                50 => 'ps_shoppingcart',
                51 => 'ps_socialfollow',
                52 => 'ps_specials',
                53 => 'ps_supplierlist',
                54 => 'ps_themecusto',
                55 => 'ps_viewedproduct',
                56 => 'ps_wirepayment',
                57 => 'statsbestcategories',
                58 => 'statsbestcustomers',
                59 => 'statsbestmanufacturers',
                60 => 'statsbestproducts',
                61 => 'statsbestsuppliers',
                62 => 'statsbestvouchers',
                63 => 'statscarrier',
                64 => 'statscatalog',
                65 => 'statscheckup',
                66 => 'statsdata',
                67 => 'statsforecast',
                68 => 'statsnewsletter',
                69 => 'statspersonalinfos',
                70 => 'statsproduct',
                71 => 'statsregistrations',
                72 => 'statssales',
                73 => 'statssearch',
                74 => 'statsstock',
            ],
            'prestashop.module_dir' => '/home/fletcher/public_html/fletchermall.com/modules/',
            'kernel.project_dir' => '/home/fletcher/public_html/fletchermall.com',
            'ps_cache_dir' => '/home/fletcher/public_html/fletchermall.com/var/cache/prod/',
            'mail_themes_uri' => '/mails/themes',
            'doctrine.dbal.logger.chain.class' => 'Doctrine\\DBAL\\Logging\\LoggerChain',
            'doctrine.dbal.logger.profiling.class' => 'Doctrine\\DBAL\\Logging\\DebugStack',
            'doctrine.dbal.logger.class' => 'Symfony\\Bridge\\Doctrine\\Logger\\DbalLogger',
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [

            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\ORM\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\ORM\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.metadata.attribute.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AttributeDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => false,
            'doctrine.orm.proxy_dir' => '/home/fletcher/public_html/fletchermall.com/var/cache/prod//doctrine/orm/Proxies',
            'doctrine.orm.proxy_namespace' => 'Proxies',
        ];
    }
}

class FeatureFlagRepositoryProxy2ee44cd extends \PrestaShopBundle\Entity\Repository\FeatureFlagRepository implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyProxyTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".'*'."\0".'_class' => [parent::class, '_class', null, 8],
        "\0".'*'."\0".'_em' => [parent::class, '_em', null, 8],
        "\0".'*'."\0".'_entityName' => [parent::class, '_entityName', null, 8],
        '_class' => [parent::class, '_class', null, 8],
        '_em' => [parent::class, '_em', null, 8],
        '_entityName' => [parent::class, '_entityName', null, 8],
    ];

    public function getByName(string $featureFlagName): ?\PrestaShopBundle\Entity\FeatureFlag
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getByName(...\func_get_args());
        }

        return parent::getByName(...\func_get_args());
    }

    public function isEnabled(string $featureFlagName): bool
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->isEnabled(...\func_get_args());
        }

        return parent::isEnabled(...\func_get_args());
    }

    public function isDisabled(string $featureFlagName): bool
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->isDisabled(...\func_get_args());
        }

        return parent::isDisabled(...\func_get_args());
    }

    public function enable(string $featureFlagName): void
    {
        if (isset($this->lazyObjectState)) {
            ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->enable(...\func_get_args());
        } else {
            parent::enable(...\func_get_args());
        }
    }

    public function disable(string $featureFlagName): void
    {
        if (isset($this->lazyObjectState)) {
            ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->disable(...\func_get_args());
        } else {
            parent::disable(...\func_get_args());
        }
    }
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class FeatureFlagManagerGhostCd6d651 extends \PrestaShop\PrestaShop\Core\FeatureFlag\FeatureFlagManager implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'featureFlagRepository' => [parent::class, 'featureFlagRepository', null, 530],
        "\0".parent::class."\0".'featureFlagStates' => [parent::class, 'featureFlagStates', null, 16],
        "\0".parent::class."\0".'locator' => [parent::class, 'locator', null, 530],
        'featureFlagRepository' => [parent::class, 'featureFlagRepository', null, 530],
        'featureFlagStates' => [parent::class, 'featureFlagStates', null, 16],
        'locator' => [parent::class, 'locator', null, 530],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class DbLayerGhost48291a0 extends \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DbLayer implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".'*'."\0".'featureFlagRepository' => [parent::class, 'featureFlagRepository', parent::class, 522],
        'featureFlagRepository' => [parent::class, 'featureFlagRepository', parent::class, 522],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class DotEnvLayerGhost79d403f extends \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DotEnvLayer implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'environment' => [parent::class, 'environment', null, 16],
        "\0".parent::class."\0".'rootDir' => [parent::class, 'rootDir', null, 16],
        'environment' => [parent::class, 'environment', null, 16],
        'rootDir' => [parent::class, 'rootDir', null, 16],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class EnvLayerGhostC2b5ebd extends \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\EnvLayer implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class QueryLayerGhost7f48906 extends \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\QueryLayer implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'environment' => [parent::class, 'environment', null, 16],
        "\0".parent::class."\0".'requestStack' => [parent::class, 'requestStack', null, 16],
        'environment' => [parent::class, 'environment', null, 16],
        'requestStack' => [parent::class, 'requestStack', null, 16],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class RequestStackProxy37f0788 extends \Symfony\Component\HttpFoundation\RequestStack implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyProxyTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'requests' => [parent::class, 'requests', null, 16],
        'requests' => [parent::class, 'requests', null, 16],
    ];

    public function pop(): ?\Symfony\Component\HttpFoundation\Request
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->pop(...\func_get_args());
        }

        return parent::pop(...\func_get_args());
    }

    public function getCurrentRequest(): ?\Symfony\Component\HttpFoundation\Request
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getCurrentRequest(...\func_get_args());
        }

        return parent::getCurrentRequest(...\func_get_args());
    }

    public function getMainRequest(): ?\Symfony\Component\HttpFoundation\Request
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getMainRequest(...\func_get_args());
        }

        return parent::getMainRequest(...\func_get_args());
    }

    public function getParentRequest(): ?\Symfony\Component\HttpFoundation\Request
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getParentRequest(...\func_get_args());
        }

        return parent::getParentRequest(...\func_get_args());
    }

    public function getSession(): \Symfony\Component\HttpFoundation\Session\SessionInterface
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getSession(...\func_get_args());
        }

        return parent::getSession(...\func_get_args());
    }

    public function resetRequestFormats(): void
    {
        if (isset($this->lazyObjectState)) {
            ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->resetRequestFormats(...\func_get_args());
        } else {
            parent::resetRequestFormats(...\func_get_args());
        }
    }
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class EntityManagerProxy196c39a extends \Doctrine\ORM\EntityManager implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyProxyTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'cache' => [parent::class, 'cache', null, 16],
        "\0".parent::class."\0".'closed' => [parent::class, 'closed', null, 16],
        "\0".parent::class."\0".'config' => [parent::class, 'config', null, 16],
        "\0".parent::class."\0".'conn' => [parent::class, 'conn', null, 16],
        "\0".parent::class."\0".'eventManager' => [parent::class, 'eventManager', null, 16],
        "\0".parent::class."\0".'expressionBuilder' => [parent::class, 'expressionBuilder', null, 16],
        "\0".parent::class."\0".'filterCollection' => [parent::class, 'filterCollection', null, 16],
        "\0".parent::class."\0".'metadataFactory' => [parent::class, 'metadataFactory', null, 16],
        "\0".parent::class."\0".'proxyFactory' => [parent::class, 'proxyFactory', null, 16],
        "\0".parent::class."\0".'repositoryFactory' => [parent::class, 'repositoryFactory', null, 16],
        "\0".parent::class."\0".'unitOfWork' => [parent::class, 'unitOfWork', null, 16],
        'cache' => [parent::class, 'cache', null, 16],
        'closed' => [parent::class, 'closed', null, 16],
        'config' => [parent::class, 'config', null, 16],
        'conn' => [parent::class, 'conn', null, 16],
        'eventManager' => [parent::class, 'eventManager', null, 16],
        'expressionBuilder' => [parent::class, 'expressionBuilder', null, 16],
        'filterCollection' => [parent::class, 'filterCollection', null, 16],
        'metadataFactory' => [parent::class, 'metadataFactory', null, 16],
        'proxyFactory' => [parent::class, 'proxyFactory', null, 16],
        'repositoryFactory' => [parent::class, 'repositoryFactory', null, 16],
        'unitOfWork' => [parent::class, 'unitOfWork', null, 16],
    ];

    public function isUninitializedObject($obj): bool
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->isUninitializedObject(...\func_get_args());
        }

        return parent::isUninitializedObject(...\func_get_args());
    }
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);
