<?php

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class PsxmarketingwithgoogleAdminContainer extends Container
{
    protected $parameters = [];

    public function __construct()
    {
        $this->services = $this->privates = [];
        $this->methodMap = [
            'PrestaShopCorp\\Billing\\Presenter\\BillingPresenter' => 'getBillingPresenterService',
            'PrestaShopCorp\\Billing\\Services\\BillingService' => 'getBillingServiceService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter' => 'getConfigurationAdapterService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Buffer\\TemplateBuffer' => 'getTemplateBufferService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Builder\\CarrierBuilder' => 'getCarrierBuilderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Config\\Env' => 'getEnvService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Conversion\\EnhancedConversionToggle' => 'getEnhancedConversionToggleService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Conversion\\UserDataProvider' => 'getUserDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Database\\Installer' => 'getInstallerService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Database\\Uninstaller' => 'getUninstallerService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\ErrorHandler' => 'getErrorHandlerService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\RemarketingHookHandler' => 'getRemarketingHookHandlerService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\BrandQueryBuilder' => 'getBrandQueryBuilderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\CategoryQueryBuilder' => 'getCategoryQueryBuilderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\FeatureQueryBuilder' => 'getFeatureQueryBuilderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\OutOfStockQueryBuilder' => 'getOutOfStockQueryBuilderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\PriceQueryBuilder' => 'getPriceQueryBuilderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\ProductIdQueryBuilder' => 'getProductIdQueryBuilderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\FilterValidator' => 'getFilterValidatorService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\ProductEnumerator' => 'getProductEnumeratorService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\QueryBuilder' => 'getQueryBuilderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\Options\\BrandOptionsProvider' => 'getBrandOptionsProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\Options\\CategoryOptionsProvider' => 'getCategoryOptionsProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\Options\\FeatureOptionsProvider' => 'getFeatureOptionsProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\Options\\Resolver' => 'getResolverService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\CarrierDataProvider' => 'getCarrierDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\CartEventDataProvider' => 'getCartEventDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\PageViewEventDataProvider' => 'getPageViewEventDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\ProductDataProvider' => 'getProductDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\PurchaseEventDataProvider' => 'getPurchaseEventDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\VerificationTagDataProvider' => 'getVerificationTagDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\AttributesRepository' => 'getAttributesRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CarrierRepository' => 'getCarrierRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CategoryRepository' => 'getCategoryRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CountryRepository' => 'getCountryRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CurrencyRepository' => 'getCurrencyRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\LanguageRepository' => 'getLanguageRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ManufacturerRepository' => 'getManufacturerRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ProductRepository' => 'getProductRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\StateRepository' => 'getStateRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TabRepository' => 'getTabRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TaxRepository' => 'getTaxRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\VerificationTagRepository' => 'getVerificationTagRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Tracker\\Segment' => 'getSegmentService',
            'PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts' => 'getPsAccountsService',
            'PrestaShop\\PsAccountsInstaller\\Installer\\Installer' => 'getInstaller2Service',
            'psxmarketingwithgoogle' => 'getPsxmarketingwithgoogleService',
            'psxmarketingwithgoogle.billing_env' => 'getPsxmarketingwithgoogle_BillingEnvService',
            'psxmarketingwithgoogle.cart' => 'getPsxmarketingwithgoogle_CartService',
            'psxmarketingwithgoogle.context' => 'getPsxmarketingwithgoogle_ContextService',
            'psxmarketingwithgoogle.controller' => 'getPsxmarketingwithgoogle_ControllerService',
            'psxmarketingwithgoogle.cookie' => 'getPsxmarketingwithgoogle_CookieService',
            'psxmarketingwithgoogle.country' => 'getPsxmarketingwithgoogle_CountryService',
            'psxmarketingwithgoogle.currency' => 'getPsxmarketingwithgoogle_CurrencyService',
            'psxmarketingwithgoogle.customer' => 'getPsxmarketingwithgoogle_CustomerService',
            'psxmarketingwithgoogle.db' => 'getPsxmarketingwithgoogle_DbService',
            'psxmarketingwithgoogle.language' => 'getPsxmarketingwithgoogle_LanguageService',
            'psxmarketingwithgoogle.link' => 'getPsxmarketingwithgoogle_LinkService',
            'psxmarketingwithgoogle.shop' => 'getPsxmarketingwithgoogle_ShopService',
            'psxmarketingwithgoogle.smarty' => 'getPsxmarketingwithgoogle_SmartyService',
        ];

        $this->aliases = [];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return [
            'PrestaShopCorp\\Billing\\Wrappers\\BillingContextWrapper' => true,
        ];
    }

    /**
     * Gets the public 'PrestaShopCorp\Billing\Presenter\BillingPresenter' shared service.
     *
     * @return \PrestaShopCorp\Billing\Presenter\BillingPresenter
     */
    protected static function getBillingPresenterService($container)
    {
        return $container->services['PrestaShopCorp\\Billing\\Presenter\\BillingPresenter'] = new \PrestaShopCorp\Billing\Presenter\BillingPresenter(($container->privates['PrestaShopCorp\\Billing\\Wrappers\\BillingContextWrapper'] ?? self::getBillingContextWrapperService($container)), ($container->services['psxmarketingwithgoogle'] ?? self::getPsxmarketingwithgoogleService($container)));
    }

    /**
     * Gets the public 'PrestaShopCorp\Billing\Services\BillingService' shared service.
     *
     * @return \PrestaShopCorp\Billing\Services\BillingService
     */
    protected static function getBillingServiceService($container)
    {
        return $container->services['PrestaShopCorp\\Billing\\Services\\BillingService'] = new \PrestaShopCorp\Billing\Services\BillingService(($container->privates['PrestaShopCorp\\Billing\\Wrappers\\BillingContextWrapper'] ?? self::getBillingContextWrapperService($container)), ($container->services['psxmarketingwithgoogle'] ?? self::getPsxmarketingwithgoogleService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Adapter\ConfigurationAdapter' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Adapter\ConfigurationAdapter
     */
    protected static function getConfigurationAdapterService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Adapter\ConfigurationAdapter(($container->services['psxmarketingwithgoogle.shop'] ?? self::getPsxmarketingwithgoogle_ShopService($container))->id);
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Buffer\TemplateBuffer' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Buffer\TemplateBuffer
     */
    protected static function getTemplateBufferService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Buffer\\TemplateBuffer'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Buffer\TemplateBuffer();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Builder\CarrierBuilder' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Builder\CarrierBuilder
     */
    protected static function getCarrierBuilderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Builder\\CarrierBuilder'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Builder\CarrierBuilder(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CarrierRepository'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CarrierRepository()), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CountryRepository'] ?? self::getCountryRepositoryService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\StateRepository'] ?? self::getStateRepositoryService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TaxRepository'] ?? self::getTaxRepositoryService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Config\Env' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Config\Env
     */
    protected static function getEnvService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Config\\Env'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Config\Env();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Conversion\EnhancedConversionToggle' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Conversion\EnhancedConversionToggle
     */
    protected static function getEnhancedConversionToggleService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Conversion\\EnhancedConversionToggle'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Conversion\EnhancedConversionToggle(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Conversion\UserDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Conversion\UserDataProvider
     */
    protected static function getUserDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Conversion\\UserDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Conversion\UserDataProvider(($container->services['psxmarketingwithgoogle.customer'] ?? self::getPsxmarketingwithgoogle_CustomerService($container)), ($container->services['psxmarketingwithgoogle.cart'] ?? self::getPsxmarketingwithgoogle_CartService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Database\Installer' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Database\Installer
     */
    protected static function getInstallerService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Database\\Installer'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Database\Installer(($container->services['psxmarketingwithgoogle'] ?? self::getPsxmarketingwithgoogleService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Tracker\\Segment'] ?? self::getSegmentService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\ErrorHandler'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\Handler\ErrorHandler()));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Database\Uninstaller' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Database\Uninstaller
     */
    protected static function getUninstallerService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Database\\Uninstaller'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Database\Uninstaller(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TabRepository'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TabRepository()), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Tracker\\Segment'] ?? self::getSegmentService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\ErrorHandler'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\Handler\ErrorHandler()));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Handler\ErrorHandler' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Handler\ErrorHandler
     */
    protected static function getErrorHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\ErrorHandler'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Handler\ErrorHandler();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Handler\RemarketingHookHandler' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Handler\RemarketingHookHandler
     */
    protected static function getRemarketingHookHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\RemarketingHookHandler'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Handler\RemarketingHookHandler(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Buffer\\TemplateBuffer'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\Buffer\TemplateBuffer()), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)), ($container->services['psxmarketingwithgoogle'] ?? self::getPsxmarketingwithgoogleService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\BrandQueryBuilder' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\BrandQueryBuilder
     */
    protected static function getBrandQueryBuilderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\BrandQueryBuilder'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\BrandQueryBuilder();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\CategoryQueryBuilder' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\CategoryQueryBuilder
     */
    protected static function getCategoryQueryBuilderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\CategoryQueryBuilder'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\CategoryQueryBuilder(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\FeatureQueryBuilder' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\FeatureQueryBuilder
     */
    protected static function getFeatureQueryBuilderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\FeatureQueryBuilder'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\FeatureQueryBuilder(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\LanguageRepository'] ?? self::getLanguageRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\OutOfStockQueryBuilder' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\OutOfStockQueryBuilder
     */
    protected static function getOutOfStockQueryBuilderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\OutOfStockQueryBuilder'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\OutOfStockQueryBuilder();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\PriceQueryBuilder' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\PriceQueryBuilder
     */
    protected static function getPriceQueryBuilderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\PriceQueryBuilder'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\PriceQueryBuilder();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\ProductIdQueryBuilder' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\ProductIdQueryBuilder
     */
    protected static function getProductIdQueryBuilderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\ProductIdQueryBuilder'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\ProductIdQueryBuilder();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\FilterValidator' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\FilterValidator
     */
    protected static function getFilterValidatorService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\FilterValidator'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\FilterValidator();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\ProductEnumerator' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\ProductEnumerator
     */
    protected static function getProductEnumeratorService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\ProductEnumerator'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\ProductEnumerator(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\FilterValidator'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\FilterValidator()), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\QueryBuilder'] ?? self::getQueryBuilderService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\QueryBuilder' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\QueryBuilder
     */
    protected static function getQueryBuilderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\QueryBuilder'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\QueryBuilder(($container->services['psxmarketingwithgoogle.shop'] ?? self::getPsxmarketingwithgoogle_ShopService($container))->id, ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\BrandQueryBuilder'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\BrandQueryBuilder()), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\CategoryQueryBuilder'] ?? self::getCategoryQueryBuilderService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\FeatureQueryBuilder'] ?? self::getFeatureQueryBuilderService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\OutOfStockQueryBuilder'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\OutOfStockQueryBuilder()), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\PriceQueryBuilder'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\PriceQueryBuilder()), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\FilterApplication\\AttributeQueryBuilder\\ProductIdQueryBuilder'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\FilterApplication\AttributeQueryBuilder\ProductIdQueryBuilder()));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\BrandOptionsProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\BrandOptionsProvider
     */
    protected static function getBrandOptionsProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\Options\\BrandOptionsProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\BrandOptionsProvider(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ManufacturerRepository'] ?? self::getManufacturerRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\CategoryOptionsProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\CategoryOptionsProvider
     */
    protected static function getCategoryOptionsProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\Options\\CategoryOptionsProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\CategoryOptionsProvider(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CategoryRepository'] ?? self::getCategoryRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\FeatureOptionsProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\FeatureOptionsProvider
     */
    protected static function getFeatureOptionsProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\Options\\FeatureOptionsProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\FeatureOptionsProvider(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\AttributesRepository'] ?? self::getAttributesRepositoryService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\LanguageRepository'] ?? self::getLanguageRepositoryService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container))->language->id);
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\Resolver' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\Resolver
     */
    protected static function getResolverService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\ProductFilter\\Options\\Resolver'] = new \PrestaShop\Module\PsxMarketingWithGoogle\ProductFilter\Options\Resolver();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\CarrierDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\CarrierDataProvider
     */
    protected static function getCarrierDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\CarrierDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\CarrierDataProvider(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Builder\\CarrierBuilder'] ?? self::getCarrierBuilderService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\CartEventDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\CartEventDataProvider
     */
    protected static function getCartEventDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\CartEventDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\CartEventDataProvider(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\PageViewEventDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\PageViewEventDataProvider
     */
    protected static function getPageViewEventDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\PageViewEventDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\PageViewEventDataProvider(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\ProductDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\ProductDataProvider
     */
    protected static function getProductDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\ProductDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\ProductDataProvider(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\PurchaseEventDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\PurchaseEventDataProvider
     */
    protected static function getPurchaseEventDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\PurchaseEventDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\PurchaseEventDataProvider(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\ProductDataProvider'] ?? self::getProductDataProviderService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\LanguageRepository'] ?? self::getLanguageRepositoryService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CountryRepository'] ?? self::getCountryRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\VerificationTagDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\VerificationTagDataProvider
     */
    protected static function getVerificationTagDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\VerificationTagDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\VerificationTagDataProvider(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\VerificationTagRepository'] ?? self::getVerificationTagRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\AttributesRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\AttributesRepository
     */
    protected static function getAttributesRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\AttributesRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\AttributesRepository(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\CarrierRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CarrierRepository
     */
    protected static function getCarrierRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CarrierRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CarrierRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\CategoryRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CategoryRepository
     */
    protected static function getCategoryRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CategoryRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CategoryRepository(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\CountryRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CountryRepository
     */
    protected static function getCountryRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CountryRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CountryRepository(($container->services['psxmarketingwithgoogle.db'] ?? self::getPsxmarketingwithgoogle_DbService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)), ($container->services['psxmarketingwithgoogle.country'] ?? self::getPsxmarketingwithgoogle_CountryService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\CurrencyRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CurrencyRepository
     */
    protected static function getCurrencyRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CurrencyRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CurrencyRepository(($container->services['psxmarketingwithgoogle.currency'] ?? self::getPsxmarketingwithgoogle_CurrencyService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\LanguageRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\LanguageRepository
     */
    protected static function getLanguageRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\LanguageRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\LanguageRepository(($container->services['psxmarketingwithgoogle.shop'] ?? self::getPsxmarketingwithgoogle_ShopService($container))->id);
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\ManufacturerRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\ManufacturerRepository
     */
    protected static function getManufacturerRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ManufacturerRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\ManufacturerRepository(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\ProductRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\ProductRepository
     */
    protected static function getProductRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ProductRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\ProductRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\StateRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\StateRepository
     */
    protected static function getStateRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\StateRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\StateRepository(($container->services['psxmarketingwithgoogle.db'] ?? self::getPsxmarketingwithgoogle_DbService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\TabRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TabRepository
     */
    protected static function getTabRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TabRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TabRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\TaxRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TaxRepository
     */
    protected static function getTaxRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TaxRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TaxRepository(($container->services['psxmarketingwithgoogle.db'] ?? self::getPsxmarketingwithgoogle_DbService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\VerificationTagRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\VerificationTagRepository
     */
    protected static function getVerificationTagRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\VerificationTagRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\VerificationTagRepository(($container->services['psxmarketingwithgoogle.db'] ?? self::getPsxmarketingwithgoogle_DbService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Tracker\Segment' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Tracker\Segment
     */
    protected static function getSegmentService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Tracker\\Segment'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Tracker\Segment(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts' shared service.
     *
     * @return \PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts
     */
    protected static function getPsAccountsService($container)
    {
        return $container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] = new \PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts(($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Installer'] ??= new \PrestaShop\PsAccountsInstaller\Installer\Installer('5.0.2')));
    }

    /**
     * Gets the public 'PrestaShop\PsAccountsInstaller\Installer\Installer' shared service.
     *
     * @return \PrestaShop\PsAccountsInstaller\Installer\Installer
     */
    protected static function getInstaller2Service($container)
    {
        return $container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Installer'] = new \PrestaShop\PsAccountsInstaller\Installer\Installer('5.0.2');
    }

    /**
     * Gets the public 'psxmarketingwithgoogle' shared service.
     *
     * @return \PsxMarketingWithGoogle
     */
    protected static function getPsxmarketingwithgoogleService($container)
    {
        return $container->services['psxmarketingwithgoogle'] = \Module::getInstanceByName('psxmarketingwithgoogle');
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.billing_env' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ParametersFactory
     */
    protected static function getPsxmarketingwithgoogle_BillingEnvService($container)
    {
        return $container->services['psxmarketingwithgoogle.billing_env'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ParametersFactory::getBillingEnv();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.cart' shared service.
     *
     * @return \Currency
     */
    protected static function getPsxmarketingwithgoogle_CartService($container)
    {
        return $container->services['psxmarketingwithgoogle.cart'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCart();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.context' shared service.
     *
     * @return \Context
     */
    protected static function getPsxmarketingwithgoogle_ContextService($container)
    {
        return $container->services['psxmarketingwithgoogle.context'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getContext();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.controller' shared service.
     *
     * @return \Controller
     */
    protected static function getPsxmarketingwithgoogle_ControllerService($container)
    {
        return $container->services['psxmarketingwithgoogle.controller'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getController();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.cookie' shared service.
     *
     * @return \Cookie
     */
    protected static function getPsxmarketingwithgoogle_CookieService($container)
    {
        return $container->services['psxmarketingwithgoogle.cookie'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCookie();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.country' shared service.
     *
     * @return \Country
     */
    protected static function getPsxmarketingwithgoogle_CountryService($container)
    {
        return $container->services['psxmarketingwithgoogle.country'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCountry();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.currency' shared service.
     *
     * @return \Currency
     */
    protected static function getPsxmarketingwithgoogle_CurrencyService($container)
    {
        return $container->services['psxmarketingwithgoogle.currency'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCurrency();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.customer' shared service.
     *
     * @return \Currency
     */
    protected static function getPsxmarketingwithgoogle_CustomerService($container)
    {
        return $container->services['psxmarketingwithgoogle.customer'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCustomer();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.db' shared service.
     *
     * @return \Db
     */
    protected static function getPsxmarketingwithgoogle_DbService($container)
    {
        return $container->services['psxmarketingwithgoogle.db'] = \Db::getInstance();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.language' shared service.
     *
     * @return \Language
     */
    protected static function getPsxmarketingwithgoogle_LanguageService($container)
    {
        return $container->services['psxmarketingwithgoogle.language'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getLanguage();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.link' shared service.
     *
     * @return \Shop
     */
    protected static function getPsxmarketingwithgoogle_LinkService($container)
    {
        return $container->services['psxmarketingwithgoogle.link'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getLink();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.shop' shared service.
     *
     * @return \Shop
     */
    protected static function getPsxmarketingwithgoogle_ShopService($container)
    {
        return $container->services['psxmarketingwithgoogle.shop'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getShop();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.smarty' shared service.
     *
     * @return \Smarty
     */
    protected static function getPsxmarketingwithgoogle_SmartyService($container)
    {
        return $container->services['psxmarketingwithgoogle.smarty'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getSmarty();
    }

    /**
     * Gets the private 'PrestaShopCorp\Billing\Wrappers\BillingContextWrapper' shared service.
     *
     * @return \PrestaShopCorp\Billing\Wrappers\BillingContextWrapper
     */
    protected static function getBillingContextWrapperService($container)
    {
        return $container->privates['PrestaShopCorp\\Billing\\Wrappers\\BillingContextWrapper'] = new \PrestaShopCorp\Billing\Wrappers\BillingContextWrapper(($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] ?? self::getPsAccountsService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)), ($container->services['psxmarketingwithgoogle.billing_env'] ?? self::getPsxmarketingwithgoogle_BillingEnvService($container)));
    }
}
