<?php

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Ps_checkout9506FrontContainer extends Container
{
    protected $parameters = [];

    public function __construct()
    {
        $this->services = $this->privates = [];
        $this->methodMap = [
            'Monolog\\Handler\\HandlerInterface' => 'getHandlerInterfaceService',
            'PrestaShop\\ModuleLibCacheDirectoryProvider\\Cache\\CacheDirectoryProvider' => 'getCacheDirectoryProviderService',
            'PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts' => 'getPsAccountsService',
            'PrestaShop\\PsAccountsInstaller\\Installer\\Installer' => 'getInstallerService',
            'PsCheckout\\Api\\Http\\CheckoutHttpClient' => 'getCheckoutHttpClientService',
            'PsCheckout\\Api\\Http\\Configuration\\CheckoutClientConfigurationBuilder' => 'getCheckoutClientConfigurationBuilderService',
            'PsCheckout\\Api\\Http\\Configuration\\OrderHttpClientConfigurationBuilder' => 'getOrderHttpClientConfigurationBuilderService',
            'PsCheckout\\Api\\Http\\Configuration\\OrderShipmentTrackingConfigurationBuilder' => 'getOrderShipmentTrackingConfigurationBuilderService',
            'PsCheckout\\Api\\Http\\OrderHttpClient' => 'getOrderHttpClientService',
            'PsCheckout\\Api\\Http\\OrderShipmentTrackingHttpClient' => 'getOrderShipmentTrackingHttpClientService',
            'PsCheckout\\Cache\\Array\\PayPalOrder' => 'getPayPalOrderService',
            'PsCheckout\\Cache\\Array\\ShippingTracking' => 'getShippingTrackingService',
            'PsCheckout\\Cache\\FileSystem\\PayPalOrder' => 'getPayPalOrder2Service',
            'PsCheckout\\Cache\\FileSystem\\ShippingTracking' => 'getShippingTracking2Service',
            'PsCheckout\\Core\\Customer\\Action\\ExpressCheckoutAction' => 'getExpressCheckoutActionService',
            'PsCheckout\\Core\\FundingSource\\Factory\\FundingSourceTokenFactory' => 'getFundingSourceTokenFactoryService',
            'PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction' => 'getChangeOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetCompletedOrderStateAction' => 'getSetCompletedOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetDeclinedOrderStateAction' => 'getSetDeclinedOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetPendingOrderStateAction' => 'getSetPendingOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetRefundedOrderStateAction' => 'getSetRefundedOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetReversedOrderStateAction' => 'getSetReversedOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper' => 'getOrderStateMapperService',
            'PsCheckout\\Core\\Order\\Action\\CreateOrderAction' => 'getCreateOrderActionService',
            'PsCheckout\\Core\\Order\\Action\\CreateOrderPaymentAction' => 'getCreateOrderPaymentActionService',
            'PsCheckout\\Core\\Order\\Action\\CreateValidateOrderDataAction' => 'getCreateValidateOrderDataActionService',
            'PsCheckout\\Core\\Order\\Action\\ValidateOrderAction' => 'getValidateOrderActionService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\AmountBreakdownNode' => 'getAmountBreakdownNodeService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\ApplicationContextNodeBuilder' => 'getApplicationContextNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\BaseNodeBuilder' => 'getBaseNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\CardPaymentSourceNodeBuilder' => 'getCardPaymentSourceNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\GooglePayPaymentSourceNodeBuilder' => 'getGooglePayPaymentSourceNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\PayPalPaymentSourceNodeBuilder' => 'getPayPalPaymentSourceNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\PayerNodeBuilder' => 'getPayerNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\ShippingNodeBuilder' => 'getShippingNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\SupplementaryDataNodeBuilder' => 'getSupplementaryDataNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder' => 'getOrderPayloadBuilderService',
            'PsCheckout\\Core\\Order\\Exception\\Handler\\OrderCreationExceptionHandler' => 'getOrderCreationExceptionHandlerService',
            'PsCheckout\\Core\\Order\\Processor\\CreateOrderProcessor' => 'getCreateOrderProcessorService',
            'PsCheckout\\Core\\Order\\Validator\\CheckoutValidator' => 'getCheckoutValidatorService',
            'PsCheckout\\Core\\Order\\Validator\\OrderAmountValidator' => 'getOrderAmountValidatorService',
            'PsCheckout\\Core\\Order\\Validator\\OrderAuthorizationValidator' => 'getOrderAuthorizationValidatorService',
            'PsCheckout\\Core\\PayPal\\ApplePay\\Builder\\ApplePayPaymentRequestDataBuilder' => 'getApplePayPaymentRequestDataBuilderService',
            'PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator' => 'getCard3DSecureValidatorService',
            'PsCheckout\\Core\\PayPal\\GooglePay\\Builder\\GooglePayPaymentRequestDataBuilder' => 'getGooglePayPaymentRequestDataBuilderService',
            'PsCheckout\\Core\\PayPal\\OAuth\\OAuthService' => 'getOAuthServiceService',
            'PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction' => 'getPayPalCheckOrderStatusActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\CancelPayPalOrderAction' => 'getCancelPayPalOrderActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\CapturePayPalOrderAction' => 'getCapturePayPalOrderActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\CreatePayPalOrderAction' => 'getCreatePayPalOrderActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\RefundPayPalOrderAction' => 'getRefundPayPalOrderActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction' => 'getUpdatePayPalOrderPurchaseUnitActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache' => 'getPayPalOrderCacheService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovalReversedEventHandler' => 'getOrderApprovalReversedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovedEventHandler' => 'getOrderApprovedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderCompletedEventHandler' => 'getOrderCompletedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PayPalEventDispatcher' => 'getPayPalEventDispatcherService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentCompletedEventHandler' => 'getPaymentCompletedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentDeniedEventHandler' => 'getPaymentDeniedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentPendingEventHandler' => 'getPaymentPendingEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentRefundedEventHandler' => 'getPaymentRefundedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentReversedEventHandler' => 'getPaymentReversedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Processor\\CreatePayPalOrderProcessor' => 'getCreatePayPalOrderProcessorService',
            'PsCheckout\\Core\\PayPal\\Order\\Processor\\UpdateExternalPayPalOrderProcessor' => 'getUpdateExternalPayPalOrderProcessorService',
            'PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider' => 'getPayPalOrderProviderService',
            'PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderTranslationProvider' => 'getPayPalOrderTranslationProviderService',
            'PsCheckout\\Core\\PayPal\\Order\\Validator\\CreatedPayPalOrderValidator' => 'getCreatedPayPalOrderValidatorService',
            'PsCheckout\\Core\\PayPal\\Refund\\Provider\\PayPalRefundOrderProvider' => 'getPayPalRefundOrderProviderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingAction' => 'getAddTrackingActionService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingActionInterface' => 'getAddTrackingActionInterfaceService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\ProcessExternalShipmentAction' => 'getProcessExternalShipmentActionService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingBaseNodeBuilder' => 'getTrackingBaseNodeBuilderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingCarrierModuleNodeBuilder' => 'getTrackingCarrierModuleNodeBuilderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingItemsNodeBuilder' => 'getTrackingItemsNodeBuilderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder' => 'getTrackingPayloadBuilderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache' => 'getShippingTrackingCacheService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ExternalShipmentProcessor' => 'getExternalShipmentProcessorService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessor' => 'getShipmentProcessorService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessorInterface' => 'getShipmentProcessorInterfaceService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService' => 'getTrackingApiServiceService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler' => 'getTrackingDatabaseHandlerService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator' => 'getOrderTrackerValidatorService',
            'PsCheckout\\Core\\PaymentToken\\Action\\DeletePaymentTokenAction' => 'getDeletePaymentTokenActionService',
            'PsCheckout\\Core\\PaymentToken\\Action\\SavePaymentTokenAction' => 'getSavePaymentTokenActionService',
            'PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration' => 'getPayPalConfigurationService',
            'PsCheckout\\Core\\Settings\\Configuration\\PayPalSdkConfiguration' => 'getPayPalSdkConfigurationService',
            'PsCheckout\\Core\\WebhookDispatcher\\Action\\CheckPSLSignatureAction' => 'getCheckPSLSignatureActionService',
            'PsCheckout\\Core\\WebhookDispatcher\\Processor\\DispatchWebhookProcessor' => 'getDispatchWebhookProcessorService',
            'PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookBodyProvider' => 'getWebhookBodyProviderService',
            'PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookHeaderProvider' => 'getWebhookHeaderProviderService',
            'PsCheckout\\Core\\WebhookDispatcher\\Validator\\BodyValuesValidator' => 'getBodyValuesValidatorService',
            'PsCheckout\\Core\\WebhookDispatcher\\Validator\\HeaderValuesValidator' => 'getHeaderValuesValidatorService',
            'PsCheckout\\Core\\WebhookDispatcher\\Validator\\WebhookShopIdValidator' => 'getWebhookShopIdValidatorService',
            'PsCheckout\\Core\\Webhook\\Handler\\WebhookEventConfigurationUpdatedHandler' => 'getWebhookEventConfigurationUpdatedHandlerService',
            'PsCheckout\\Core\\Webhook\\Handler\\WebhookHandler' => 'getWebhookHandlerService',
            'PsCheckout\\Core\\Webhook\\Service\\WebhookSecretToken' => 'getWebhookSecretTokenService',
            'PsCheckout\\Infrastructure\\Action\\AddProductToCartAction' => 'getAddProductToCartActionService',
            'PsCheckout\\Infrastructure\\Action\\CreateOrUpdateAddressAction' => 'getCreateOrUpdateAddressActionService',
            'PsCheckout\\Infrastructure\\Action\\CustomerAuthenticationAction' => 'getCustomerAuthenticationActionService',
            'PsCheckout\\Infrastructure\\Action\\CustomerNotifyAction' => 'getCustomerNotifyActionService',
            'PsCheckout\\Infrastructure\\Adapter\\Address' => 'getAddressService',
            'PsCheckout\\Infrastructure\\Adapter\\Cart' => 'getCartService',
            'PsCheckout\\Infrastructure\\Adapter\\Configuration' => 'getConfigurationService',
            'PsCheckout\\Infrastructure\\Adapter\\Context' => 'getContextService',
            'PsCheckout\\Infrastructure\\Adapter\\Country' => 'getCountryService',
            'PsCheckout\\Infrastructure\\Adapter\\Currency' => 'getCurrencyService',
            'PsCheckout\\Infrastructure\\Adapter\\Customer' => 'getCustomerService',
            'PsCheckout\\Infrastructure\\Adapter\\Language' => 'getLanguageService',
            'PsCheckout\\Infrastructure\\Adapter\\Link' => 'getLinkService',
            'PsCheckout\\Infrastructure\\Adapter\\ShopContext' => 'getShopContextService',
            'PsCheckout\\Infrastructure\\Adapter\\SystemConfiguration' => 'getSystemConfigurationService',
            'PsCheckout\\Infrastructure\\Adapter\\Tools' => 'getToolsService',
            'PsCheckout\\Infrastructure\\Adapter\\Validate' => 'getValidateService',
            'PsCheckout\\Infrastructure\\Environment\\Env' => 'getEnvService',
            'PsCheckout\\Infrastructure\\Environment\\EnvLoader' => 'getEnvLoaderService',
            'PsCheckout\\Infrastructure\\Logger\\LoggerFactory' => 'getLoggerFactoryService',
            'PsCheckout\\Infrastructure\\Logger\\LoggerFileFinder' => 'getLoggerFileFinderService',
            'PsCheckout\\Infrastructure\\Logger\\LoggerFileReader' => 'getLoggerFileReaderService',
            'PsCheckout\\Infrastructure\\Logger\\LoggerHandlerFactory' => 'getLoggerHandlerFactoryService',
            'PsCheckout\\Infrastructure\\Repository\\AddressRepository' => 'getAddressRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\CartRepository' => 'getCartRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\ConfigurationRepository' => 'getConfigurationRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\CountryRepository' => 'getCountryRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\CurrencyRepository' => 'getCurrencyRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\CustomerRepository' => 'getCustomerRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\FundingSourceRepository' => 'getFundingSourceRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\GenderRepository' => 'getGenderRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\LanguageRepository' => 'getLanguageRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\OrderHistoryRepository' => 'getOrderHistoryRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\OrderRepository' => 'getOrderRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\OrderStateRepository' => 'getOrderStateRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository' => 'getPayPalCustomerRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderAuthorizationRepository' => 'getPayPalOrderAuthorizationRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository' => 'getPayPalOrderCaptureRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderMatrixRepository' => 'getPayPalOrderMatrixRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderPurchaseUnitRepository' => 'getPayPalOrderPurchaseUnitRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderRefundRepository' => 'getPayPalOrderRefundRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository' => 'getPayPalOrderRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository' => 'getPaymentTokenRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PsAccountRepository' => 'getPsAccountRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository' => 'getShippingTrackingRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\StateRepository' => 'getStateRepositoryService',
            'PsCheckout\\Infrastructure\\Validator\\FrontControllerValidator' => 'getFrontControllerValidatorService',
            'PsCheckout\\Infrastructure\\Validator\\MerchantValidator' => 'getMerchantValidatorService',
            'PsCheckout\\Module\\Presentation\\Translator' => 'getTranslatorService',
            'PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter' => 'getCartPresenterService',
            'PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter' => 'getFundingSourcePresenterService',
            'PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTokenPresenter' => 'getFundingSourceTokenPresenterService',
            'PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider' => 'getFundingSourceTranslationProviderService',
            'PsCheckout\\Presentation\\Presenter\\FundingSource\\LogoPresenter' => 'getLogoPresenterService',
            'PsCheckout\\Presentation\\Presenter\\OrderSummary\\OrderSummaryPresenter' => 'getOrderSummaryPresenterService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\FrontSettingsPresenter' => 'getFrontSettingsPresenterService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\ConfigurationModule' => 'getConfigurationModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\LinkModule' => 'getLinkModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\MediaModule' => 'getMediaModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\PayPalModule' => 'getPayPalModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\TranslationModule' => 'getTranslationModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\SupportedCardBrandsPresenter' => 'getSupportedCardBrandsPresenterService',
            'PsCheckout\\Utility\\Common\\InputStreamUtility' => 'getInputStreamUtilityService',
            'Psr\\Log\\LoggerInterface' => 'getLoggerInterfaceService',
            'ps_checkout.db' => 'getPsCheckout_DbService',
            'ps_checkout.module' => 'getPsCheckout_ModuleService',
        ];

        $this->aliases = [];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    /**
     * Gets the public 'Monolog\Handler\HandlerInterface' shared service.
     *
     * @return \Monolog\Handler\HandlerInterface
     */
    protected static function getHandlerInterfaceService($container)
    {
        return $container->services['Monolog\\Handler\\HandlerInterface'] = ($container->services['PsCheckout\\Infrastructure\\Logger\\LoggerHandlerFactory'] ?? self::getLoggerHandlerFactoryService($container))->build();
    }

    /**
     * Gets the public 'PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider' shared service.
     *
     * @return \PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider
     */
    protected static function getCacheDirectoryProviderService($container)
    {
        return $container->services['PrestaShop\\ModuleLibCacheDirectoryProvider\\Cache\\CacheDirectoryProvider'] = new \PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider('9.0.2', '/home/fletcher/public_html/fletchermall.com', false);
    }

    /**
     * Gets the public 'PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts' shared service.
     *
     * @return \PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts
     */
    protected static function getPsAccountsService($container)
    {
        return $container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] = new \PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts(($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Installer'] ??= new \PrestaShop\PsAccountsInstaller\Installer\Installer('4.0.0')));
    }

    /**
     * Gets the public 'PrestaShop\PsAccountsInstaller\Installer\Installer' shared service.
     *
     * @return \PrestaShop\PsAccountsInstaller\Installer\Installer
     */
    protected static function getInstallerService($container)
    {
        return $container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Installer'] = new \PrestaShop\PsAccountsInstaller\Installer\Installer('4.0.0');
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\CheckoutHttpClient' shared service.
     *
     * @return \PsCheckout\Api\Http\CheckoutHttpClient
     */
    protected static function getCheckoutHttpClientService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\CheckoutHttpClient'] = new \PsCheckout\Api\Http\CheckoutHttpClient(($container->services['PsCheckout\\Api\\Http\\Configuration\\CheckoutClientConfigurationBuilder'] ?? self::getCheckoutClientConfigurationBuilderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\Configuration\CheckoutClientConfigurationBuilder' shared service.
     *
     * @return \PsCheckout\Api\Http\Configuration\CheckoutClientConfigurationBuilder
     */
    protected static function getCheckoutClientConfigurationBuilderService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\Configuration\\CheckoutClientConfigurationBuilder'] = new \PsCheckout\Api\Http\Configuration\CheckoutClientConfigurationBuilder(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->version, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnvService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\Configuration\OrderHttpClientConfigurationBuilder' shared service.
     *
     * @return \PsCheckout\Api\Http\Configuration\OrderHttpClientConfigurationBuilder
     */
    protected static function getOrderHttpClientConfigurationBuilderService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\Configuration\\OrderHttpClientConfigurationBuilder'] = new \PsCheckout\Api\Http\Configuration\OrderHttpClientConfigurationBuilder(($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnvService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->version);
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\Configuration\OrderShipmentTrackingConfigurationBuilder' shared service.
     *
     * @return \PsCheckout\Api\Http\Configuration\OrderShipmentTrackingConfigurationBuilder
     */
    protected static function getOrderShipmentTrackingConfigurationBuilderService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\Configuration\\OrderShipmentTrackingConfigurationBuilder'] = new \PsCheckout\Api\Http\Configuration\OrderShipmentTrackingConfigurationBuilder(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->version, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnvService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\OrderHttpClient' shared service.
     *
     * @return \PsCheckout\Api\Http\OrderHttpClient
     */
    protected static function getOrderHttpClientService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] = new \PsCheckout\Api\Http\OrderHttpClient(($container->services['PsCheckout\\Api\\Http\\Configuration\\OrderHttpClientConfigurationBuilder'] ?? self::getOrderHttpClientConfigurationBuilderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\OrderShipmentTrackingHttpClient' shared service.
     *
     * @return \PsCheckout\Api\Http\OrderShipmentTrackingHttpClient
     */
    protected static function getOrderShipmentTrackingHttpClientService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\OrderShipmentTrackingHttpClient'] = new \PsCheckout\Api\Http\OrderShipmentTrackingHttpClient(($container->services['PsCheckout\\Api\\Http\\Configuration\\OrderShipmentTrackingConfigurationBuilder'] ?? self::getOrderShipmentTrackingConfigurationBuilderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Cache\Array\PayPalOrder' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\ArrayAdapter
     */
    protected static function getPayPalOrderService($container)
    {
        return $container->services['PsCheckout\\Cache\\Array\\PayPalOrder'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
    }

    /**
     * Gets the public 'PsCheckout\Cache\Array\ShippingTracking' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\ArrayAdapter
     */
    protected static function getShippingTrackingService($container)
    {
        return $container->services['PsCheckout\\Cache\\Array\\ShippingTracking'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
    }

    /**
     * Gets the public 'PsCheckout\Cache\FileSystem\PayPalOrder' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getPayPalOrder2Service($container)
    {
        return $container->services['PsCheckout\\Cache\\FileSystem\\PayPalOrder'] = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('paypal-orders', 3600, ($container->services['PrestaShop\\ModuleLibCacheDirectoryProvider\\Cache\\CacheDirectoryProvider'] ??= new \PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider('9.0.2', '/home/fletcher/public_html/fletchermall.com', false))->getPath());
    }

    /**
     * Gets the public 'PsCheckout\Cache\FileSystem\ShippingTracking' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getShippingTracking2Service($container)
    {
        return $container->services['PsCheckout\\Cache\\FileSystem\\ShippingTracking'] = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('shipping-tracking', 3600, ($container->services['PrestaShop\\ModuleLibCacheDirectoryProvider\\Cache\\CacheDirectoryProvider'] ??= new \PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider('9.0.2', '/home/fletcher/public_html/fletchermall.com', false))->getPath());
    }

    /**
     * Gets the public 'PsCheckout\Core\Customer\Action\ExpressCheckoutAction' shared service.
     *
     * @return \PsCheckout\Core\Customer\Action\ExpressCheckoutAction
     */
    protected static function getExpressCheckoutActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Customer\\Action\\ExpressCheckoutAction'] = new \PsCheckout\Core\Customer\Action\ExpressCheckoutAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Action\\CustomerAuthenticationAction'] ?? self::getCustomerAuthenticationActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Action\\CreateOrUpdateAddressAction'] ?? self::getCreateOrUpdateAddressActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\FundingSource\Factory\FundingSourceTokenFactory' shared service.
     *
     * @return \PsCheckout\Core\FundingSource\Factory\FundingSourceTokenFactory
     */
    protected static function getFundingSourceTokenFactoryService($container)
    {
        return $container->services['PsCheckout\\Core\\FundingSource\\Factory\\FundingSourceTokenFactory'] = new \PsCheckout\Core\FundingSource\Factory\FundingSourceTokenFactory(($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\LogoPresenter'] ?? self::getLogoPresenterService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\ChangeOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\ChangeOrderStateAction
     */
    protected static function getChangeOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\ChangeOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderStateRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderStateRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderHistoryRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderHistoryRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetCompletedOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetCompletedOrderStateAction
     */
    protected static function getSetCompletedOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetCompletedOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetCompletedOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Core\\Order\\Validator\\OrderAmountValidator'] ??= new \PsCheckout\Core\Order\Validator\OrderAmountValidator()), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetDeclinedOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetDeclinedOrderStateAction
     */
    protected static function getSetDeclinedOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetDeclinedOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetDeclinedOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetPendingOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetPendingOrderStateAction
     */
    protected static function getSetPendingOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetPendingOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetPendingOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetRefundedOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetRefundedOrderStateAction
     */
    protected static function getSetRefundedOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetRefundedOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetRefundedOrderStateAction(($container->services['PsCheckout\\Core\\PayPal\\Refund\\Provider\\PayPalRefundOrderProvider'] ?? self::getPayPalRefundOrderProviderService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetReversedOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetReversedOrderStateAction
     */
    protected static function getSetReversedOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetReversedOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetReversedOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Service\OrderStateMapper' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Service\OrderStateMapper
     */
    protected static function getOrderStateMapperService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] = new \PsCheckout\Core\OrderState\Service\OrderStateMapper(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Action\CreateOrderAction' shared service.
     *
     * @return \PsCheckout\Core\Order\Action\CreateOrderAction
     */
    protected static function getCreateOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderAction'] = new \PsCheckout\Core\Order\Action\CreateOrderAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Core\\Order\\Action\\CreateValidateOrderDataAction'] ?? self::getCreateValidateOrderDataActionService($container)), ($container->services['PsCheckout\\Core\\Order\\Action\\ValidateOrderAction'] ?? self::getValidateOrderActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderMatrixRepository'] ?? self::getPayPalOrderMatrixRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Action\CreateOrderPaymentAction' shared service.
     *
     * @return \PsCheckout\Core\Order\Action\CreateOrderPaymentAction
     */
    protected static function getCreateOrderPaymentActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderPaymentAction'] = new \PsCheckout\Core\Order\Action\CreateOrderPaymentAction(($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Currency'] ??= new \PsCheckout\Infrastructure\Adapter\Currency()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Action\CreateValidateOrderDataAction' shared service.
     *
     * @return \PsCheckout\Core\Order\Action\CreateValidateOrderDataAction
     */
    protected static function getCreateValidateOrderDataActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Action\\CreateValidateOrderDataAction'] = new \PsCheckout\Core\Order\Action\CreateValidateOrderDataAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\CurrencyRepository'] ?? self::getCurrencyRepositoryService($container)), ($container->services['PsCheckout\\Core\\Order\\Validator\\OrderAmountValidator'] ??= new \PsCheckout\Core\Order\Validator\OrderAmountValidator()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Action\ValidateOrderAction' shared service.
     *
     * @return \PsCheckout\Core\Order\Action\ValidateOrderAction
     */
    protected static function getValidateOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Action\\ValidateOrderAction'] = new \PsCheckout\Core\Order\Action\ValidateOrderAction(($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\AmountBreakdownNode' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\AmountBreakdownNode
     */
    protected static function getAmountBreakdownNodeService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\AmountBreakdownNode'] = new \PsCheckout\Core\Order\Builder\Node\AmountBreakdownNode();
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\ApplicationContextNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\ApplicationContextNodeBuilder
     */
    protected static function getApplicationContextNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\ApplicationContextNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\ApplicationContextNodeBuilder(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\BaseNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\BaseNodeBuilder
     */
    protected static function getBaseNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\BaseNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\BaseNodeBuilder(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\CardPaymentSourceNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\CardPaymentSourceNodeBuilder
     */
    protected static function getCardPaymentSourceNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\CardPaymentSourceNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\CardPaymentSourceNodeBuilder(($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] ?? self::getPayPalConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] ??= new \PsCheckout\Infrastructure\Repository\StateRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\GooglePayPaymentSourceNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\GooglePayPaymentSourceNodeBuilder
     */
    protected static function getGooglePayPaymentSourceNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\GooglePayPaymentSourceNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\GooglePayPaymentSourceNodeBuilder(($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] ?? self::getPayPalConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\PayPalPaymentSourceNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\PayPalPaymentSourceNodeBuilder
     */
    protected static function getPayPalPaymentSourceNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\PayPalPaymentSourceNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\PayPalPaymentSourceNodeBuilder();
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\PayerNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\PayerNodeBuilder
     */
    protected static function getPayerNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\PayerNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\PayerNodeBuilder(($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Validate'] ??= new \PsCheckout\Infrastructure\Adapter\Validate()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] ??= new \PsCheckout\Infrastructure\Repository\StateRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\ShippingNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\ShippingNodeBuilder
     */
    protected static function getShippingNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\ShippingNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\ShippingNodeBuilder(($container->services['PsCheckout\\Infrastructure\\Repository\\GenderRepository'] ??= new \PsCheckout\Infrastructure\Repository\GenderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] ??= new \PsCheckout\Infrastructure\Repository\StateRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\SupplementaryDataNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\SupplementaryDataNodeBuilder
     */
    protected static function getSupplementaryDataNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\SupplementaryDataNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\SupplementaryDataNodeBuilder(($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] ??= new \PsCheckout\Infrastructure\Repository\StateRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\OrderPayloadBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\OrderPayloadBuilder
     */
    protected static function getOrderPayloadBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] = new \PsCheckout\Core\Order\Builder\OrderPayloadBuilder(($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\BaseNodeBuilder'] ?? self::getBaseNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\AmountBreakdownNode'] ??= new \PsCheckout\Core\Order\Builder\Node\AmountBreakdownNode()), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\ShippingNodeBuilder'] ?? self::getShippingNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\PayerNodeBuilder'] ?? self::getPayerNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\CardPaymentSourceNodeBuilder'] ?? self::getCardPaymentSourceNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\SupplementaryDataNodeBuilder'] ?? self::getSupplementaryDataNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\ApplicationContextNodeBuilder'] ?? self::getApplicationContextNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\PayPalPaymentSourceNodeBuilder'] ??= new \PsCheckout\Core\Order\Builder\Node\PayPalPaymentSourceNodeBuilder()), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\GooglePayPaymentSourceNodeBuilder'] ?? self::getGooglePayPaymentSourceNodeBuilderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Exception\Handler\OrderCreationExceptionHandler' shared service.
     *
     * @return \PsCheckout\Core\Order\Exception\Handler\OrderCreationExceptionHandler
     */
    protected static function getOrderCreationExceptionHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Exception\\Handler\\OrderCreationExceptionHandler'] = new \PsCheckout\Core\Order\Exception\Handler\OrderCreationExceptionHandler(($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Infrastructure\\Action\\CustomerNotifyAction'] ?? self::getCustomerNotifyActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Processor\CreateOrderProcessor' shared service.
     *
     * @return \PsCheckout\Core\Order\Processor\CreateOrderProcessor
     */
    protected static function getCreateOrderProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Processor\\CreateOrderProcessor'] = new \PsCheckout\Core\Order\Processor\CreateOrderProcessor(($container->services['PsCheckout\\Core\\Order\\Validator\\OrderAuthorizationValidator'] ?? self::getOrderAuthorizationValidatorService($container)), ($container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderAction'] ?? self::getCreateOrderActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\CartRepository'] ??= new \PsCheckout\Infrastructure\Repository\CartRepository()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Core\\Order\\Validator\\CheckoutValidator'] ?? self::getCheckoutValidatorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CapturePayPalOrderAction'] ?? self::getCapturePayPalOrderActionService($container)), ($container->services['PsCheckout\\Core\\PaymentToken\\Action\\SavePaymentTokenAction'] ?? self::getSavePaymentTokenActionService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PaymentToken\\Action\\DeletePaymentTokenAction'] ?? self::getDeletePaymentTokenActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Validator\CheckoutValidator' shared service.
     *
     * @return \PsCheckout\Core\Order\Validator\CheckoutValidator
     */
    protected static function getCheckoutValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Validator\\CheckoutValidator'] = new \PsCheckout\Core\Order\Validator\CheckoutValidator(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CartRepository'] ??= new \PsCheckout\Infrastructure\Repository\CartRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Validator\OrderAmountValidator' shared service.
     *
     * @return \PsCheckout\Core\Order\Validator\OrderAmountValidator
     */
    protected static function getOrderAmountValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Validator\\OrderAmountValidator'] = new \PsCheckout\Core\Order\Validator\OrderAmountValidator();
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Validator\OrderAuthorizationValidator' shared service.
     *
     * @return \PsCheckout\Core\Order\Validator\OrderAuthorizationValidator
     */
    protected static function getOrderAuthorizationValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Validator\\OrderAuthorizationValidator'] = new \PsCheckout\Core\Order\Validator\OrderAuthorizationValidator(($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Customer'] ??= new \PsCheckout\Infrastructure\Adapter\Customer()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Cart'] ??= new \PsCheckout\Infrastructure\Adapter\Cart()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator'] ??= new \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ApplePay\Builder\ApplePayPaymentRequestDataBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ApplePay\Builder\ApplePayPaymentRequestDataBuilder
     */
    protected static function getApplePayPaymentRequestDataBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ApplePay\\Builder\\ApplePayPaymentRequestDataBuilder'] = new \PsCheckout\Core\PayPal\ApplePay\Builder\ApplePayPaymentRequestDataBuilder(($container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] ?? self::getOrderPayloadBuilderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] ?? self::getCartPresenterService($container)), ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator
     */
    protected static function getCard3DSecureValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator'] = new \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator();
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\GooglePay\Builder\GooglePayPaymentRequestDataBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\GooglePay\Builder\GooglePayPaymentRequestDataBuilder
     */
    protected static function getGooglePayPaymentRequestDataBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\GooglePay\\Builder\\GooglePayPaymentRequestDataBuilder'] = new \PsCheckout\Core\PayPal\GooglePay\Builder\GooglePayPaymentRequestDataBuilder(($container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] ?? self::getOrderPayloadBuilderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] ?? self::getCartPresenterService($container)), ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\OAuth\OAuthService' shared service.
     *
     * @return \PsCheckout\Core\PayPal\OAuth\OAuthService
     */
    protected static function getOAuthServiceService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\OAuth\\OAuthService'] = new \PsCheckout\Core\PayPal\OAuth\OAuthService(($container->services['PsCheckout\\Api\\Http\\CheckoutHttpClient'] ?? self::getCheckoutHttpClientService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction
     */
    protected static function getPayPalCheckOrderStatusActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] = new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction();
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\CancelPayPalOrderAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\CancelPayPalOrderAction
     */
    protected static function getCancelPayPalOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CancelPayPalOrderAction'] = new \PsCheckout\Core\PayPal\Order\Action\CancelPayPalOrderAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\CapturePayPalOrderAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\CapturePayPalOrderAction
     */
    protected static function getCapturePayPalOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CapturePayPalOrderAction'] = new \PsCheckout\Core\PayPal\Order\Action\CapturePayPalOrderAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderCompletedEventHandler'] ?? self::getOrderCompletedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentPendingEventHandler'] ?? self::getPaymentPendingEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentCompletedEventHandler'] ?? self::getPaymentCompletedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentDeniedEventHandler'] ?? self::getPaymentDeniedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\CreatePayPalOrderAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\CreatePayPalOrderAction
     */
    protected static function getCreatePayPalOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CreatePayPalOrderAction'] = new \PsCheckout\Core\PayPal\Order\Action\CreatePayPalOrderAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] ?? self::getPayPalCustomerRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] ?? self::getOrderPayloadBuilderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] ?? self::getCartPresenterService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Processor\\CreatePayPalOrderProcessor'] ?? self::getCreatePayPalOrderProcessorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Core\\PaymentToken\\Action\\DeletePaymentTokenAction'] ?? self::getDeletePaymentTokenActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\RefundPayPalOrderAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\RefundPayPalOrderAction
     */
    protected static function getRefundPayPalOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\RefundPayPalOrderAction'] = new \PsCheckout\Core\PayPal\Order\Action\RefundPayPalOrderAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\SetRefundedOrderStateAction'] ?? self::getSetRefundedOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\UpdatePayPalOrderPurchaseUnitAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\UpdatePayPalOrderPurchaseUnitAction
     */
    protected static function getUpdatePayPalOrderPurchaseUnitActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction'] = new \PsCheckout\Core\PayPal\Order\Action\UpdatePayPalOrderPurchaseUnitAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderPurchaseUnitRepository'] ?? self::getPayPalOrderPurchaseUnitRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository'] ?? self::getPayPalOrderCaptureRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderAuthorizationRepository'] ?? self::getPayPalOrderAuthorizationRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRefundRepository'] ?? self::getPayPalOrderRefundRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Cache\PayPalOrderCache' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Cache\PayPalOrderCache
     */
    protected static function getPayPalOrderCacheService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] = new \PsCheckout\Core\PayPal\Order\Cache\PayPalOrderCache(($container->services['PsCheckout\\Cache\\Array\\PayPalOrder'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()), ($container->services['PsCheckout\\Cache\\FileSystem\\PayPalOrder'] ?? self::getPayPalOrder2Service($container)), ($container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] ??= new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\OrderApprovalReversedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\OrderApprovalReversedEventHandler
     */
    protected static function getOrderApprovalReversedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovalReversedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\OrderApprovalReversedEventHandler(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] ??= new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\OrderApprovedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\OrderApprovedEventHandler
     */
    protected static function getOrderApprovedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\OrderApprovedEventHandler(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] ??= new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction()), ($container->services['PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator'] ??= new \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator()), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CapturePayPalOrderAction'] ?? self::getCapturePayPalOrderActionService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction'] ?? self::getUpdatePayPalOrderPurchaseUnitActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\OrderCompletedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\OrderCompletedEventHandler
     */
    protected static function getOrderCompletedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderCompletedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\OrderCompletedEventHandler(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] ??= new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction()), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction'] ?? self::getUpdatePayPalOrderPurchaseUnitActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator'] ??= new \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PayPalEventDispatcher' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PayPalEventDispatcher
     */
    protected static function getPayPalEventDispatcherService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PayPalEventDispatcher'] = new \PsCheckout\Core\PayPal\Order\Handler\PayPalEventDispatcher(($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentCompletedEventHandler'] ?? self::getPaymentCompletedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentPendingEventHandler'] ?? self::getPaymentPendingEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentDeniedEventHandler'] ?? self::getPaymentDeniedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentRefundedEventHandler'] ?? self::getPaymentRefundedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentReversedEventHandler'] ?? self::getPaymentReversedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovedEventHandler'] ?? self::getOrderApprovedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderCompletedEventHandler'] ?? self::getOrderCompletedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovalReversedEventHandler'] ?? self::getOrderApprovalReversedEventHandlerService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentCompletedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentCompletedEventHandler
     */
    protected static function getPaymentCompletedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentCompletedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentCompletedEventHandler(($container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderAction'] ?? self::getCreateOrderActionService($container)), ($container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderPaymentAction'] ?? self::getCreateOrderPaymentActionService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\SetCompletedOrderStateAction'] ?? self::getSetCompletedOrderStateActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentDeniedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentDeniedEventHandler
     */
    protected static function getPaymentDeniedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentDeniedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentDeniedEventHandler(($container->services['PsCheckout\\Core\\OrderState\\Action\\SetDeclinedOrderStateAction'] ?? self::getSetDeclinedOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentPendingEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentPendingEventHandler
     */
    protected static function getPaymentPendingEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentPendingEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentPendingEventHandler(($container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderAction'] ?? self::getCreateOrderActionService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\SetPendingOrderStateAction'] ?? self::getSetPendingOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentRefundedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentRefundedEventHandler
     */
    protected static function getPaymentRefundedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentRefundedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentRefundedEventHandler(($container->services['PsCheckout\\Core\\OrderState\\Action\\SetRefundedOrderStateAction'] ?? self::getSetRefundedOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentReversedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentReversedEventHandler
     */
    protected static function getPaymentReversedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentReversedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentReversedEventHandler(($container->services['PsCheckout\\Core\\OrderState\\Action\\SetReversedOrderStateAction'] ?? self::getSetReversedOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Processor\CreatePayPalOrderProcessor' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Processor\CreatePayPalOrderProcessor
     */
    protected static function getCreatePayPalOrderProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Processor\\CreatePayPalOrderProcessor'] = new \PsCheckout\Core\PayPal\Order\Processor\CreatePayPalOrderProcessor(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] ?? self::getPayPalCustomerRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderPurchaseUnitRepository'] ?? self::getPayPalOrderPurchaseUnitRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository'] ?? self::getPayPalOrderCaptureRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderAuthorizationRepository'] ?? self::getPayPalOrderAuthorizationRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRefundRepository'] ?? self::getPayPalOrderRefundRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Processor\UpdateExternalPayPalOrderProcessor' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Processor\UpdateExternalPayPalOrderProcessor
     */
    protected static function getUpdateExternalPayPalOrderProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Processor\\UpdateExternalPayPalOrderProcessor'] = new \PsCheckout\Core\PayPal\Order\Processor\UpdateExternalPayPalOrderProcessor(($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] ?? self::getCartPresenterService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] ?? self::getOrderPayloadBuilderService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction'] ?? self::getUpdatePayPalOrderPurchaseUnitActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Provider\PayPalOrderProvider' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Provider\PayPalOrderProvider
     */
    protected static function getPayPalOrderProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] = new \PsCheckout\Core\PayPal\Order\Provider\PayPalOrderProvider(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Provider\PayPalOrderTranslationProvider' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Provider\PayPalOrderTranslationProvider
     */
    protected static function getPayPalOrderTranslationProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderTranslationProvider'] = new \PsCheckout\Core\PayPal\Order\Provider\PayPalOrderTranslationProvider(($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Validator\CreatedPayPalOrderValidator' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Validator\CreatedPayPalOrderValidator
     */
    protected static function getCreatedPayPalOrderValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Validator\\CreatedPayPalOrderValidator'] = new \PsCheckout\Core\PayPal\Order\Validator\CreatedPayPalOrderValidator(($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Cart'] ??= new \PsCheckout\Infrastructure\Adapter\Cart()), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->id);
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Refund\Provider\PayPalRefundOrderProvider' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Refund\Provider\PayPalRefundOrderProvider
     */
    protected static function getPayPalRefundOrderProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Refund\\Provider\\PayPalRefundOrderProvider'] = new \PsCheckout\Core\PayPal\Refund\Provider\PayPalRefundOrderProvider(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction
     */
    protected static function getAddTrackingActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingAction'] = new \PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessor'] ?? self::getShipmentProcessorService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingActionInterface' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction
     */
    protected static function getAddTrackingActionInterfaceService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingActionInterface'] = new \PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessorInterface'] ?? self::getShipmentProcessorInterfaceService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Action\ProcessExternalShipmentAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Action\ProcessExternalShipmentAction
     */
    protected static function getProcessExternalShipmentActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\ProcessExternalShipmentAction'] = new \PsCheckout\Core\PayPal\ShippingTracking\Action\ProcessExternalShipmentAction(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ExternalShipmentProcessor'] ?? self::getExternalShipmentProcessorService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingBaseNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingBaseNodeBuilder
     */
    protected static function getTrackingBaseNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingBaseNodeBuilder'] = new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingBaseNodeBuilder();
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingCarrierModuleNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingCarrierModuleNodeBuilder
     */
    protected static function getTrackingCarrierModuleNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingCarrierModuleNodeBuilder'] = new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingCarrierModuleNodeBuilder();
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingItemsNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingItemsNodeBuilder
     */
    protected static function getTrackingItemsNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingItemsNodeBuilder'] = new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingItemsNodeBuilder(($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Builder\TrackingPayloadBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Builder\TrackingPayloadBuilder
     */
    protected static function getTrackingPayloadBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder'] = new \PsCheckout\Core\PayPal\ShippingTracking\Builder\TrackingPayloadBuilder(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingBaseNodeBuilder'] ??= new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingBaseNodeBuilder()), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingItemsNodeBuilder'] ?? self::getTrackingItemsNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingCarrierModuleNodeBuilder'] ??= new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingCarrierModuleNodeBuilder()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Cache\ShippingTrackingCache' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Cache\ShippingTrackingCache
     */
    protected static function getShippingTrackingCacheService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache'] = new \PsCheckout\Core\PayPal\ShippingTracking\Cache\ShippingTrackingCache(($container->services['PsCheckout\\Cache\\Array\\ShippingTracking'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()), ($container->services['PsCheckout\\Cache\\FileSystem\\ShippingTracking'] ?? self::getShippingTracking2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Processor\ExternalShipmentProcessor' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Processor\ExternalShipmentProcessor
     */
    protected static function getExternalShipmentProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ExternalShipmentProcessor'] = new \PsCheckout\Core\PayPal\ShippingTracking\Processor\ExternalShipmentProcessor(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator'] ?? self::getOrderTrackerValidatorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder'] ?? self::getTrackingPayloadBuilderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] ?? self::getShippingTrackingRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache'] ?? self::getShippingTrackingCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService'] ?? self::getTrackingApiServiceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler'] ?? self::getTrackingDatabaseHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingActionInterface'] ?? self::getAddTrackingActionInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor
     */
    protected static function getShipmentProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessor'] = new \PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator'] ?? self::getOrderTrackerValidatorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder'] ?? self::getTrackingPayloadBuilderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] ?? self::getShippingTrackingRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache'] ?? self::getShippingTrackingCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService'] ?? self::getTrackingApiServiceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler'] ?? self::getTrackingDatabaseHandlerService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessorInterface' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor
     */
    protected static function getShipmentProcessorInterfaceService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessorInterface'] = new \PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator'] ?? self::getOrderTrackerValidatorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder'] ?? self::getTrackingPayloadBuilderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] ?? self::getShippingTrackingRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache'] ?? self::getShippingTrackingCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService'] ?? self::getTrackingApiServiceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler'] ?? self::getTrackingDatabaseHandlerService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingApiService' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingApiService
     */
    protected static function getTrackingApiServiceService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService'] = new \PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingApiService(($container->services['PsCheckout\\Api\\Http\\OrderShipmentTrackingHttpClient'] ?? self::getOrderShipmentTrackingHttpClientService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingDatabaseHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingDatabaseHandler
     */
    protected static function getTrackingDatabaseHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler'] = new \PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingDatabaseHandler(($container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] ?? self::getShippingTrackingRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Validator\OrderTrackerValidator' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Validator\OrderTrackerValidator
     */
    protected static function getOrderTrackerValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator'] = new \PsCheckout\Core\PayPal\ShippingTracking\Validator\OrderTrackerValidator(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository'] ?? self::getPayPalOrderCaptureRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PaymentToken\Action\DeletePaymentTokenAction' shared service.
     *
     * @return \PsCheckout\Core\PaymentToken\Action\DeletePaymentTokenAction
     */
    protected static function getDeletePaymentTokenActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PaymentToken\\Action\\DeletePaymentTokenAction'] = new \PsCheckout\Core\PaymentToken\Action\DeletePaymentTokenAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)), ($container->services['PsCheckout\\Api\\Http\\CheckoutHttpClient'] ?? self::getCheckoutHttpClientService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PaymentToken\Action\SavePaymentTokenAction' shared service.
     *
     * @return \PsCheckout\Core\PaymentToken\Action\SavePaymentTokenAction
     */
    protected static function getSavePaymentTokenActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PaymentToken\\Action\\SavePaymentTokenAction'] = new \PsCheckout\Core\PaymentToken\Action\SavePaymentTokenAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] ?? self::getPayPalCustomerRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Settings\Configuration\PayPalConfiguration' shared service.
     *
     * @return \PsCheckout\Core\Settings\Configuration\PayPalConfiguration
     */
    protected static function getPayPalConfigurationService($container)
    {
        return $container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] = new \PsCheckout\Core\Settings\Configuration\PayPalConfiguration(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Settings\Configuration\PayPalSdkConfiguration' shared service.
     *
     * @return \PsCheckout\Core\Settings\Configuration\PayPalSdkConfiguration
     */
    protected static function getPayPalSdkConfigurationService($container)
    {
        return $container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalSdkConfiguration'] = new \PsCheckout\Core\Settings\Configuration\PayPalSdkConfiguration(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] ?? self::getPayPalConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnvService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter'] ?? self::getFundingSourcePresenterService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] ?? self::getPayPalCustomerRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\OAuth\\OAuthService'] ?? self::getOAuthServiceService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Action\CheckPSLSignatureAction' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Action\CheckPSLSignatureAction
     */
    protected static function getCheckPSLSignatureActionService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Action\\CheckPSLSignatureAction'] = new \PsCheckout\Core\WebhookDispatcher\Action\CheckPSLSignatureAction(($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Processor\DispatchWebhookProcessor' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Processor\DispatchWebhookProcessor
     */
    protected static function getDispatchWebhookProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Processor\\DispatchWebhookProcessor'] = new \PsCheckout\Core\WebhookDispatcher\Processor\DispatchWebhookProcessor(($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PayPalEventDispatcher'] ?? self::getPayPalEventDispatcherService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Core\\PaymentToken\\Action\\SavePaymentTokenAction'] ?? self::getSavePaymentTokenActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Provider\WebhookBodyProvider' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Provider\WebhookBodyProvider
     */
    protected static function getWebhookBodyProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookBodyProvider'] = new \PsCheckout\Core\WebhookDispatcher\Provider\WebhookBodyProvider(($container->services['PsCheckout\\Utility\\Common\\InputStreamUtility'] ??= new \PsCheckout\Utility\Common\InputStreamUtility()));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Provider\WebhookHeaderProvider' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Provider\WebhookHeaderProvider
     */
    protected static function getWebhookHeaderProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookHeaderProvider'] = new \PsCheckout\Core\WebhookDispatcher\Provider\WebhookHeaderProvider();
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Validator\BodyValuesValidator' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Validator\BodyValuesValidator
     */
    protected static function getBodyValuesValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Validator\\BodyValuesValidator'] = new \PsCheckout\Core\WebhookDispatcher\Validator\BodyValuesValidator(($container->services['PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookBodyProvider'] ?? self::getWebhookBodyProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Validator\HeaderValuesValidator' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Validator\HeaderValuesValidator
     */
    protected static function getHeaderValuesValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Validator\\HeaderValuesValidator'] = new \PsCheckout\Core\WebhookDispatcher\Validator\HeaderValuesValidator(($container->services['PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookHeaderProvider'] ??= new \PsCheckout\Core\WebhookDispatcher\Provider\WebhookHeaderProvider()));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Validator\WebhookShopIdValidator' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Validator\WebhookShopIdValidator
     */
    protected static function getWebhookShopIdValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Validator\\WebhookShopIdValidator'] = new \PsCheckout\Core\WebhookDispatcher\Validator\WebhookShopIdValidator(($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Webhook\Handler\WebhookEventConfigurationUpdatedHandler' shared service.
     *
     * @return \PsCheckout\Core\Webhook\Handler\WebhookEventConfigurationUpdatedHandler
     */
    protected static function getWebhookEventConfigurationUpdatedHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\Webhook\\Handler\\WebhookEventConfigurationUpdatedHandler'] = new \PsCheckout\Core\Webhook\Handler\WebhookEventConfigurationUpdatedHandler(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Webhook\Handler\WebhookHandler' shared service.
     *
     * @return \PsCheckout\Core\Webhook\Handler\WebhookHandler
     */
    protected static function getWebhookHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\Webhook\\Handler\\WebhookHandler'] = new \PsCheckout\Core\Webhook\Handler\WebhookHandler(($container->services['PsCheckout\\Core\\Webhook\\Service\\WebhookSecretToken'] ?? self::getWebhookSecretTokenService($container)), [($container->services['PsCheckout\\Core\\Webhook\\Handler\\WebhookEventConfigurationUpdatedHandler'] ?? self::getWebhookEventConfigurationUpdatedHandlerService($container))]);
    }

    /**
     * Gets the public 'PsCheckout\Core\Webhook\Service\WebhookSecretToken' shared service.
     *
     * @return \PsCheckout\Core\Webhook\Service\WebhookSecretToken
     */
    protected static function getWebhookSecretTokenService($container)
    {
        return $container->services['PsCheckout\\Core\\Webhook\\Service\\WebhookSecretToken'] = new \PsCheckout\Core\Webhook\Service\WebhookSecretToken(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Action\AddProductToCartAction' shared service.
     *
     * @return \PsCheckout\Infrastructure\Action\AddProductToCartAction
     */
    protected static function getAddProductToCartActionService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Action\\AddProductToCartAction'] = new \PsCheckout\Infrastructure\Action\AddProductToCartAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Action\CreateOrUpdateAddressAction' shared service.
     *
     * @return \PsCheckout\Infrastructure\Action\CreateOrUpdateAddressAction
     */
    protected static function getCreateOrUpdateAddressActionService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Action\\CreateOrUpdateAddressAction'] = new \PsCheckout\Infrastructure\Action\CreateOrUpdateAddressAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Country'] ??= new \PsCheckout\Infrastructure\Adapter\Country()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\AddressRepository'] ?? self::getAddressRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Action\CustomerAuthenticationAction' shared service.
     *
     * @return \PsCheckout\Infrastructure\Action\CustomerAuthenticationAction
     */
    protected static function getCustomerAuthenticationActionService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Action\\CustomerAuthenticationAction'] = new \PsCheckout\Infrastructure\Action\CustomerAuthenticationAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Customer'] ??= new \PsCheckout\Infrastructure\Adapter\Customer()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Action\CustomerNotifyAction' shared service.
     *
     * @return \PsCheckout\Infrastructure\Action\CustomerNotifyAction
     */
    protected static function getCustomerNotifyActionService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Action\\CustomerNotifyAction'] = new \PsCheckout\Infrastructure\Action\CustomerNotifyAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)), ($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Address' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Address
     */
    protected static function getAddressService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Address'] = new \PsCheckout\Infrastructure\Adapter\Address();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Cart' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Cart
     */
    protected static function getCartService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Cart'] = new \PsCheckout\Infrastructure\Adapter\Cart();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Configuration' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Configuration
     */
    protected static function getConfigurationService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] = new \PsCheckout\Infrastructure\Adapter\Configuration(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Context' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Context
     */
    protected static function getContextService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] = new \PsCheckout\Infrastructure\Adapter\Context();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Country' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Country
     */
    protected static function getCountryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Country'] = new \PsCheckout\Infrastructure\Adapter\Country();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Currency' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Currency
     */
    protected static function getCurrencyService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Currency'] = new \PsCheckout\Infrastructure\Adapter\Currency();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Customer' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Customer
     */
    protected static function getCustomerService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Customer'] = new \PsCheckout\Infrastructure\Adapter\Customer();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Language' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Language
     */
    protected static function getLanguageService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Language'] = new \PsCheckout\Infrastructure\Adapter\Language();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Link' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Link
     */
    protected static function getLinkService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] = new \PsCheckout\Infrastructure\Adapter\Link(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name);
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\ShopContext' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\ShopContext
     */
    protected static function getShopContextService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\ShopContext'] = new \PsCheckout\Infrastructure\Adapter\ShopContext();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\SystemConfiguration' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\SystemConfiguration
     */
    protected static function getSystemConfigurationService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\SystemConfiguration'] = new \PsCheckout\Infrastructure\Adapter\SystemConfiguration();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Tools' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Tools
     */
    protected static function getToolsService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Tools'] = new \PsCheckout\Infrastructure\Adapter\Tools();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Validate' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Validate
     */
    protected static function getValidateService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Validate'] = new \PsCheckout\Infrastructure\Adapter\Validate();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Environment\Env' shared service.
     *
     * @return \PsCheckout\Infrastructure\Environment\Env
     */
    protected static function getEnvService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Environment\\Env'] = new \PsCheckout\Infrastructure\Environment\Env(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Environment\EnvLoader' shared service.
     *
     * @return \PsCheckout\Infrastructure\Environment\EnvLoader
     */
    protected static function getEnvLoaderService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Environment\\EnvLoader'] = new \PsCheckout\Infrastructure\Environment\EnvLoader();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Logger\LoggerFactory' shared service.
     *
     * @return \PsCheckout\Infrastructure\Logger\LoggerFactory
     */
    protected static function getLoggerFactoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFactory'] = new \PsCheckout\Infrastructure\Logger\LoggerFactory(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['Monolog\\Handler\\HandlerInterface'] ?? self::getHandlerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Logger\LoggerFileFinder' shared service.
     *
     * @return \PsCheckout\Infrastructure\Logger\LoggerFileFinder
     */
    protected static function getLoggerFileFinderService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFileFinder'] = new \PsCheckout\Infrastructure\Logger\LoggerFileFinder(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Logger\LoggerFileReader' shared service.
     *
     * @return \PsCheckout\Infrastructure\Logger\LoggerFileReader
     */
    protected static function getLoggerFileReaderService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFileReader'] = new \PsCheckout\Infrastructure\Logger\LoggerFileReader(($container->services['PsCheckout\\Infrastructure\\Adapter\\Validate'] ??= new \PsCheckout\Infrastructure\Adapter\Validate()), ($container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFileFinder'] ?? self::getLoggerFileFinderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Logger\LoggerHandlerFactory' shared service.
     *
     * @return \PsCheckout\Infrastructure\Logger\LoggerHandlerFactory
     */
    protected static function getLoggerHandlerFactoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Logger\\LoggerHandlerFactory'] = new \PsCheckout\Infrastructure\Logger\LoggerHandlerFactory(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name);
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\AddressRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\AddressRepository
     */
    protected static function getAddressRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\AddressRepository'] = new \PsCheckout\Infrastructure\Repository\AddressRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\CartRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\CartRepository
     */
    protected static function getCartRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\CartRepository'] = new \PsCheckout\Infrastructure\Repository\CartRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\ConfigurationRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\ConfigurationRepository
     */
    protected static function getConfigurationRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\ConfigurationRepository'] = new \PsCheckout\Infrastructure\Repository\ConfigurationRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\CountryRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\CountryRepository
     */
    protected static function getCountryRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] = new \PsCheckout\Infrastructure\Repository\CountryRepository(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name);
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\CurrencyRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\CurrencyRepository
     */
    protected static function getCurrencyRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\CurrencyRepository'] = new \PsCheckout\Infrastructure\Repository\CurrencyRepository(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name);
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\CustomerRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\CustomerRepository
     */
    protected static function getCustomerRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\CustomerRepository'] = new \PsCheckout\Infrastructure\Repository\CustomerRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\FundingSourceRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\FundingSourceRepository
     */
    protected static function getFundingSourceRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\FundingSourceRepository'] = new \PsCheckout\Infrastructure\Repository\FundingSourceRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\GenderRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\GenderRepository
     */
    protected static function getGenderRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\GenderRepository'] = new \PsCheckout\Infrastructure\Repository\GenderRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\LanguageRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\LanguageRepository
     */
    protected static function getLanguageRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\LanguageRepository'] = new \PsCheckout\Infrastructure\Repository\LanguageRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\OrderHistoryRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\OrderHistoryRepository
     */
    protected static function getOrderHistoryRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\OrderHistoryRepository'] = new \PsCheckout\Infrastructure\Repository\OrderHistoryRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\OrderRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\OrderRepository
     */
    protected static function getOrderRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] = new \PsCheckout\Infrastructure\Repository\OrderRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\OrderStateRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\OrderStateRepository
     */
    protected static function getOrderStateRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\OrderStateRepository'] = new \PsCheckout\Infrastructure\Repository\OrderStateRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalCustomerRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalCustomerRepository
     */
    protected static function getPayPalCustomerRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalCustomerRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderAuthorizationRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderAuthorizationRepository
     */
    protected static function getPayPalOrderAuthorizationRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderAuthorizationRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderAuthorizationRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderCaptureRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderCaptureRepository
     */
    protected static function getPayPalOrderCaptureRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderCaptureRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderMatrixRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderMatrixRepository
     */
    protected static function getPayPalOrderMatrixRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderMatrixRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderMatrixRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderPurchaseUnitRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderPurchaseUnitRepository
     */
    protected static function getPayPalOrderPurchaseUnitRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderPurchaseUnitRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderPurchaseUnitRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderRefundRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderRefundRepository
     */
    protected static function getPayPalOrderRefundRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRefundRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderRefundRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderRepository
     */
    protected static function getPayPalOrderRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PaymentTokenRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PaymentTokenRepository
     */
    protected static function getPaymentTokenRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] = new \PsCheckout\Infrastructure\Repository\PaymentTokenRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PsAccountRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PsAccountRepository
     */
    protected static function getPsAccountRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] = new \PsCheckout\Infrastructure\Repository\PsAccountRepository(($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] ?? self::getPsAccountsService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\ShippingTrackingRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\ShippingTrackingRepository
     */
    protected static function getShippingTrackingRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] = new \PsCheckout\Infrastructure\Repository\ShippingTrackingRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\StateRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\StateRepository
     */
    protected static function getStateRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] = new \PsCheckout\Infrastructure\Repository\StateRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Validator\FrontControllerValidator' shared service.
     *
     * @return \PsCheckout\Infrastructure\Validator\FrontControllerValidator
     */
    protected static function getFrontControllerValidatorService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Validator\\FrontControllerValidator'] = new \PsCheckout\Infrastructure\Validator\FrontControllerValidator(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Validator\MerchantValidator' shared service.
     *
     * @return \PsCheckout\Infrastructure\Validator\MerchantValidator
     */
    protected static function getMerchantValidatorService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Validator\\MerchantValidator'] = new \PsCheckout\Infrastructure\Validator\MerchantValidator(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Module\Presentation\Translator' shared service.
     *
     * @return \PsCheckout\Module\Presentation\Translator
     */
    protected static function getTranslatorService($container)
    {
        return $container->services['PsCheckout\\Module\\Presentation\\Translator'] = new \PsCheckout\Module\Presentation\Translator(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->getTranslator());
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Cart\CartPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Cart\CartPresenter
     */
    protected static function getCartPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] = new \PsCheckout\Presentation\Presenter\Cart\CartPresenter(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Address'] ??= new \PsCheckout\Infrastructure\Adapter\Address()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Currency'] ??= new \PsCheckout\Infrastructure\Adapter\Currency()), ($container->services['PsCheckout\\Infrastructure\\Repository\\LanguageRepository'] ??= new \PsCheckout\Infrastructure\Repository\LanguageRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CustomerRepository'] ??= new \PsCheckout\Infrastructure\Repository\CustomerRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\FundingSource\FundingSourcePresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\FundingSource\FundingSourcePresenter
     */
    protected static function getFundingSourcePresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter'] = new \PsCheckout\Presentation\Presenter\FundingSource\FundingSourcePresenter(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->getPathUri(), ($container->services['PsCheckout\\Infrastructure\\Repository\\FundingSourceRepository'] ?? self::getFundingSourceRepositoryService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTokenPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTokenPresenter
     */
    protected static function getFundingSourceTokenPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTokenPresenter'] = new \PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTokenPresenter(($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Core\\FundingSource\\Factory\\FundingSourceTokenFactory'] ?? self::getFundingSourceTokenFactoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTranslationProvider' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTranslationProvider
     */
    protected static function getFundingSourceTranslationProviderService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] = new \PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTranslationProvider(($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\FundingSource\LogoPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\FundingSource\LogoPresenter
     */
    protected static function getLogoPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\LogoPresenter'] = new \PsCheckout\Presentation\Presenter\FundingSource\LogoPresenter(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->getPathUri());
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\OrderSummary\OrderSummaryPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\OrderSummary\OrderSummaryPresenter
     */
    protected static function getOrderSummaryPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\OrderSummary\\OrderSummaryPresenter'] = new \PsCheckout\Presentation\Presenter\OrderSummary\OrderSummaryPresenter(($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderTranslationProvider'] ?? self::getPayPalOrderTranslationProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\FrontSettingsPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\FrontSettingsPresenter
     */
    protected static function getFrontSettingsPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\FrontSettingsPresenter'] = new \PsCheckout\Presentation\Presenter\Settings\Front\FrontSettingsPresenter([($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\PayPalModule'] ?? self::getPayPalModuleService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\ConfigurationModule'] ?? self::getConfigurationModuleService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\MediaModule'] ?? self::getMediaModuleService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\LinkModule'] ?? self::getLinkModuleService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\TranslationModule'] ?? self::getTranslationModuleService($container))]);
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\ConfigurationModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\ConfigurationModule
     */
    protected static function getConfigurationModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\ConfigurationModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\ConfigurationModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfigurationService($container)), ($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] ?? self::getPayPalConfigurationService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter'] ?? self::getFundingSourcePresenterService($container)), ($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalSdkConfiguration'] ?? self::getPayPalSdkConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\LinkModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\LinkModule
     */
    protected static function getLinkModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\LinkModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\LinkModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Tools'] ??= new \PsCheckout\Infrastructure\Adapter\Tools()));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\MediaModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\MediaModule
     */
    protected static function getMediaModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\MediaModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\MediaModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->getPathUri());
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\PayPalModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\PayPalModule
     */
    protected static function getPayPalModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\PayPalModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\PayPalModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->version, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnvService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter'] ?? self::getFundingSourcePresenterService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTokenPresenter'] ?? self::getFundingSourceTokenPresenterService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\SupportedCardBrandsPresenter'] ?? self::getSupportedCardBrandsPresenterService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\TranslationModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\TranslationModule
     */
    protected static function getTranslationModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\TranslationModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\TranslationModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\SupportedCardBrandsPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\SupportedCardBrandsPresenter
     */
    protected static function getSupportedCardBrandsPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\SupportedCardBrandsPresenter'] = new \PsCheckout\Presentation\Presenter\Settings\Front\SupportedCardBrandsPresenter(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Utility\Common\InputStreamUtility' shared service.
     *
     * @return \PsCheckout\Utility\Common\InputStreamUtility
     */
    protected static function getInputStreamUtilityService($container)
    {
        return $container->services['PsCheckout\\Utility\\Common\\InputStreamUtility'] = new \PsCheckout\Utility\Common\InputStreamUtility();
    }

    /**
     * Gets the public 'Psr\Log\LoggerInterface' shared service.
     *
     * @return \Psr\Log\LoggerInterface
     */
    protected static function getLoggerInterfaceService($container)
    {
        return $container->services['Psr\\Log\\LoggerInterface'] = ($container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFactory'] ?? self::getLoggerFactoryService($container))->build();
    }

    /**
     * Gets the public 'ps_checkout.db' shared service.
     *
     * @return \Db
     */
    protected static function getPsCheckout_DbService($container)
    {
        return $container->services['ps_checkout.db'] = \Db::getInstance();
    }

    /**
     * Gets the public 'ps_checkout.module' shared service.
     *
     * @return \ps_checkout
     */
    protected static function getPsCheckout_ModuleService($container)
    {
        return $container->services['ps_checkout.module'] = \Module::getInstanceByName('ps_checkout');
    }
}
