<?php

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class FrontContainer extends \PrestaShop\PrestaShop\Adapter\Container\LegacyContainer
{
    protected $parameters = [];
    protected \Closure $getService;

    public function __construct()
    {
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'employee' => true,
            'shop' => true,
        ];
        $this->methodMap = [
            'Monolog\\Handler\\HandlerInterface' => 'getHandlerInterfaceService',
            'PrestaShopBundle\\Security\\Admin\\LegacyAdminTokenValidator' => 'getLegacyAdminTokenValidatorService',
            'PrestaShopCorp\\Billing\\Presenter\\BillingPresenter' => 'getBillingPresenterService',
            'PrestaShopCorp\\Billing\\Services\\BillingService' => 'getBillingServiceService',
            'PrestaShop\\ModuleLibCacheDirectoryProvider\\Cache\\CacheDirectoryProvider' => 'getCacheDirectoryProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\API\\Client\\FacebookCategoryClient' => 'getFacebookCategoryClientService',
            'PrestaShop\\Module\\PrestashopFacebook\\API\\Client\\FacebookClient' => 'getFacebookClientService',
            'PrestaShop\\Module\\PrestashopFacebook\\API\\EventSubscriber\\AccountSuspendedSubscriber' => 'getAccountSuspendedSubscriberService',
            'PrestaShop\\Module\\PrestashopFacebook\\API\\EventSubscriber\\ApiErrorSubscriber' => 'getApiErrorSubscriberService',
            'PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter' => 'getConfigurationAdapterService',
            'PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ToolsAdapter' => 'getToolsAdapterService',
            'PrestaShop\\Module\\PrestashopFacebook\\Buffer\\TemplateBuffer' => 'getTemplateBufferService',
            'PrestaShop\\Module\\PrestashopFacebook\\Config\\Env' => 'getEnvService',
            'PrestaShop\\Module\\PrestashopFacebook\\Dispatcher\\EventDispatcher' => 'getEventDispatcherService',
            'PrestaShop\\Module\\PrestashopFacebook\\Factory\\FacebookEssentialsApiClientFactory' => 'getFacebookEssentialsApiClientFactoryService',
            'PrestaShop\\Module\\PrestashopFacebook\\Factory\\PsApiClientFactory' => 'getPsApiClientFactoryService',
            'PrestaShop\\Module\\PrestashopFacebook\\Handler\\ApiConversionHandler' => 'getApiConversionHandlerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Handler\\CategoryMatchHandler' => 'getCategoryMatchHandlerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Handler\\ConfigurationHandler' => 'getConfigurationHandlerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Handler\\ErrorHandler\\ErrorHandler' => 'getErrorHandlerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Handler\\EventBusProductHandler' => 'getEventBusProductHandlerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Handler\\MessengerHandler' => 'getMessengerHandlerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Handler\\PixelHandler' => 'getPixelHandlerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Handler\\PrevalidationScanRefreshHandler' => 'getPrevalidationScanRefreshHandlerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Manager\\FbeFeatureManager' => 'getFbeFeatureManagerService',
            'PrestaShop\\Module\\PrestashopFacebook\\Presenter\\ModuleUpgradePresenter' => 'getModuleUpgradePresenterService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\AccessTokenProvider' => 'getAccessTokenProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\EventDataProvider' => 'getEventDataProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\FacebookDataProvider' => 'getFacebookDataProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\FbeDataProvider' => 'getFbeDataProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\FbeFeatureDataProvider' => 'getFbeFeatureDataProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\GoogleCategoryProvider' => 'getGoogleCategoryProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\MultishopDataProvider' => 'getMultishopDataProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\PrevalidationScanCacheProvider' => 'getPrevalidationScanCacheProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\PrevalidationScanDataProvider' => 'getPrevalidationScanDataProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\ProductAvailabilityProvider' => 'getProductAvailabilityProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\ProductSyncReportProvider' => 'getProductSyncReportProviderService',
            'PrestaShop\\Module\\PrestashopFacebook\\Repository\\GoogleCategoryRepository' => 'getGoogleCategoryRepositoryService',
            'PrestaShop\\Module\\PrestashopFacebook\\Repository\\ProductRepository' => 'getProductRepositoryService',
            'PrestaShop\\Module\\PrestashopFacebook\\Repository\\ServerInformationRepository' => 'getServerInformationRepositoryService',
            'PrestaShop\\Module\\PrestashopFacebook\\Repository\\ShopRepository' => 'getShopRepositoryService',
            'PrestaShop\\Module\\PrestashopFacebook\\Repository\\TabRepository' => 'getTabRepositoryService',
            'PrestaShop\\Module\\PsAccounts\\Presenter\\PsAccountsPresenter' => 'getPsAccountsPresenterService',
            'PrestaShop\\Module\\PsAccounts\\Repository\\UserTokenRepository' => 'getUserTokenRepositoryService',
            'PrestaShop\\Module\\PsAccounts\\Service\\PsAccountsService' => 'getPsAccountsServiceService',
            'PrestaShop\\Module\\PsAccounts\\Service\\PsBillingService' => 'getPsBillingServiceService',
            'PrestaShop\\Module\\Ps_facebook\\Tracker\\Segment' => 'getSegmentService',
            'PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingCarrierController' => 'getPsshippingCarrierControllerService',
            'PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingConfigurationController' => 'getPsshippingConfigurationControllerService',
            'PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingFaqController' => 'getPsshippingFaqControllerService',
            'PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingHomeController' => 'getPsshippingHomeControllerService',
            'PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingKeycloakAuthController' => 'getPsshippingKeycloakAuthControllerService',
            'PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingOrdersController' => 'getPsshippingOrdersControllerService',
            'PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierRepository' => 'getCarrierRepositoryService',
            'PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierService' => 'getCarrierServiceService',
            'PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupCarrierConfiguration' => 'getPickupCarrierConfigurationService',
            'PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupPoints\\PsshippingAddressOrdersRepository' => 'getPsshippingAddressOrdersRepositoryService',
            'PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupPoints\\PsshippingAddressRepository' => 'getPsshippingAddressRepositoryService',
            'PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\StandardCarrierConfiguration' => 'getStandardCarrierConfigurationService',
            'PrestaShop\\Module\\Psshipping\\Domain\\GelProximity\\GelProximityService' => 'getGelProximityServiceService',
            'PrestaShop\\Module\\Psshipping\\Domain\\Orders\\OrdersRepository' => 'getOrdersRepositoryService',
            'PrestaShop\\Module\\Psshipping\\Handler\\ErrorHandler' => 'getErrorHandler2Service',
            'PrestaShop\\Module\\Psshipping\\Hooks\\HookActionObjectCarrierUpdateAfter' => 'getHookActionObjectCarrierUpdateAfterService',
            'PrestaShop\\Module\\Psshipping\\Hooks\\HookActionValidateOrder' => 'getHookActionValidateOrderService',
            'PrestaShop\\Module\\Psshipping\\Hooks\\HookDisplayCarrierExtraContent' => 'getHookDisplayCarrierExtraContentService',
            'PrestaShop\\Module\\Psshipping\\Hooks\\HookDisplayHeader' => 'getHookDisplayHeaderService',
            'PrestaShop\\Module\\Psshipping\\Hooks\\HookDisplayOrderConfirmation' => 'getHookDisplayOrderConfirmationService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter' => 'getConfigurationAdapter2Service',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Buffer\\TemplateBuffer' => 'getTemplateBuffer2Service',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Config\\Env' => 'getEnv2Service',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Conversion\\EnhancedConversionToggle' => 'getEnhancedConversionToggleService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Conversion\\UserDataProvider' => 'getUserDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\ErrorHandler' => 'getErrorHandler3Service',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\RemarketingHookHandler' => 'getRemarketingHookHandlerService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\CartEventDataProvider' => 'getCartEventDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\PageViewEventDataProvider' => 'getPageViewEventDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\ProductDataProvider' => 'getProductDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\PurchaseEventDataProvider' => 'getPurchaseEventDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\VerificationTagDataProvider' => 'getVerificationTagDataProviderService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\AttributesRepository' => 'getAttributesRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CarrierRepository' => 'getCarrierRepository2Service',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CategoryRepository' => 'getCategoryRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CountryRepository' => 'getCountryRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CurrencyRepository' => 'getCurrencyRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\LanguageRepository' => 'getLanguageRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ManufacturerRepository' => 'getManufacturerRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ProductRepository' => 'getProductRepository2Service',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\StateRepository' => 'getStateRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TabRepository' => 'getTabRepository2Service',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TaxRepository' => 'getTaxRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\VerificationTagRepository' => 'getVerificationTagRepositoryService',
            'PrestaShop\\Module\\PsxMarketingWithGoogle\\Tracker\\Segment' => 'getSegment2Service',
            'PrestaShop\\PrestaShop\\Adapter\\Bundle\\AssetsInstaller' => 'getAssetsInstallerService',
            'PrestaShop\\PrestaShop\\Adapter\\Configuration' => 'getConfigurationService',
            'PrestaShop\\PrestaShop\\Adapter\\ContextStateManager' => 'getContextStateManagerService',
            'PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider' => 'getCurrencyDataProviderService',
            'PrestaShop\\PrestaShop\\Adapter\\Employee\\EmployeeRepository' => 'getEmployeeRepositoryService',
            'PrestaShop\\PrestaShop\\Adapter\\LegacyContext' => 'getLegacyContextService',
            'PrestaShop\\PrestaShop\\Adapter\\Tools' => 'getToolsService',
            'PrestaShop\\PrestaShop\\Core\\Crypto\\Hashing' => 'getHashingService',
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\FeatureFlagStateCheckerInterface' => 'getFeatureFlagStateCheckerInterfaceService',
            'PrestaShop\\PrestaShop\\Core\\Hook\\HookModuleFilter' => 'getHookModuleFilterService',
            'PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository' => 'getLocaleRepositoryService',
            'PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository' => 'getRepositoryService',
            'PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts' => 'getPsAccountsService',
            'PrestaShop\\PsAccountsInstaller\\Installer\\Installer' => 'getInstallerService',
            'PsCheckout\\Api\\Http\\CheckoutHttpClient' => 'getCheckoutHttpClientService',
            'PsCheckout\\Api\\Http\\Configuration\\CheckoutClientConfigurationBuilder' => 'getCheckoutClientConfigurationBuilderService',
            'PsCheckout\\Api\\Http\\Configuration\\OrderHttpClientConfigurationBuilder' => 'getOrderHttpClientConfigurationBuilderService',
            'PsCheckout\\Api\\Http\\Configuration\\OrderShipmentTrackingConfigurationBuilder' => 'getOrderShipmentTrackingConfigurationBuilderService',
            'PsCheckout\\Api\\Http\\OrderHttpClient' => 'getOrderHttpClientService',
            'PsCheckout\\Api\\Http\\OrderShipmentTrackingHttpClient' => 'getOrderShipmentTrackingHttpClientService',
            'PsCheckout\\Cache\\Array\\PayPalOrder' => 'getPayPalOrderService',
            'PsCheckout\\Cache\\Array\\ShippingTracking' => 'getShippingTrackingService',
            'PsCheckout\\Cache\\FileSystem\\PayPalOrder' => 'getPayPalOrder2Service',
            'PsCheckout\\Cache\\FileSystem\\ShippingTracking' => 'getShippingTracking2Service',
            'PsCheckout\\Core\\Customer\\Action\\ExpressCheckoutAction' => 'getExpressCheckoutActionService',
            'PsCheckout\\Core\\FundingSource\\Factory\\FundingSourceTokenFactory' => 'getFundingSourceTokenFactoryService',
            'PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction' => 'getChangeOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetCompletedOrderStateAction' => 'getSetCompletedOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetDeclinedOrderStateAction' => 'getSetDeclinedOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetPendingOrderStateAction' => 'getSetPendingOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetRefundedOrderStateAction' => 'getSetRefundedOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Action\\SetReversedOrderStateAction' => 'getSetReversedOrderStateActionService',
            'PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper' => 'getOrderStateMapperService',
            'PsCheckout\\Core\\Order\\Action\\CreateOrderAction' => 'getCreateOrderActionService',
            'PsCheckout\\Core\\Order\\Action\\CreateOrderPaymentAction' => 'getCreateOrderPaymentActionService',
            'PsCheckout\\Core\\Order\\Action\\CreateValidateOrderDataAction' => 'getCreateValidateOrderDataActionService',
            'PsCheckout\\Core\\Order\\Action\\ValidateOrderAction' => 'getValidateOrderActionService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\AmountBreakdownNode' => 'getAmountBreakdownNodeService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\ApplicationContextNodeBuilder' => 'getApplicationContextNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\BaseNodeBuilder' => 'getBaseNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\CardPaymentSourceNodeBuilder' => 'getCardPaymentSourceNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\GooglePayPaymentSourceNodeBuilder' => 'getGooglePayPaymentSourceNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\PayPalPaymentSourceNodeBuilder' => 'getPayPalPaymentSourceNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\PayerNodeBuilder' => 'getPayerNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\ShippingNodeBuilder' => 'getShippingNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\Node\\SupplementaryDataNodeBuilder' => 'getSupplementaryDataNodeBuilderService',
            'PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder' => 'getOrderPayloadBuilderService',
            'PsCheckout\\Core\\Order\\Exception\\Handler\\OrderCreationExceptionHandler' => 'getOrderCreationExceptionHandlerService',
            'PsCheckout\\Core\\Order\\Processor\\CreateOrderProcessor' => 'getCreateOrderProcessorService',
            'PsCheckout\\Core\\Order\\Validator\\CheckoutValidator' => 'getCheckoutValidatorService',
            'PsCheckout\\Core\\Order\\Validator\\OrderAmountValidator' => 'getOrderAmountValidatorService',
            'PsCheckout\\Core\\Order\\Validator\\OrderAuthorizationValidator' => 'getOrderAuthorizationValidatorService',
            'PsCheckout\\Core\\PayPal\\ApplePay\\Builder\\ApplePayPaymentRequestDataBuilder' => 'getApplePayPaymentRequestDataBuilderService',
            'PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator' => 'getCard3DSecureValidatorService',
            'PsCheckout\\Core\\PayPal\\GooglePay\\Builder\\GooglePayPaymentRequestDataBuilder' => 'getGooglePayPaymentRequestDataBuilderService',
            'PsCheckout\\Core\\PayPal\\OAuth\\OAuthService' => 'getOAuthServiceService',
            'PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction' => 'getPayPalCheckOrderStatusActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\CancelPayPalOrderAction' => 'getCancelPayPalOrderActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\CapturePayPalOrderAction' => 'getCapturePayPalOrderActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\CreatePayPalOrderAction' => 'getCreatePayPalOrderActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\RefundPayPalOrderAction' => 'getRefundPayPalOrderActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction' => 'getUpdatePayPalOrderPurchaseUnitActionService',
            'PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache' => 'getPayPalOrderCacheService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovalReversedEventHandler' => 'getOrderApprovalReversedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovedEventHandler' => 'getOrderApprovedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderCompletedEventHandler' => 'getOrderCompletedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PayPalEventDispatcher' => 'getPayPalEventDispatcherService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentCompletedEventHandler' => 'getPaymentCompletedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentDeniedEventHandler' => 'getPaymentDeniedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentPendingEventHandler' => 'getPaymentPendingEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentRefundedEventHandler' => 'getPaymentRefundedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentReversedEventHandler' => 'getPaymentReversedEventHandlerService',
            'PsCheckout\\Core\\PayPal\\Order\\Processor\\CreatePayPalOrderProcessor' => 'getCreatePayPalOrderProcessorService',
            'PsCheckout\\Core\\PayPal\\Order\\Processor\\UpdateExternalPayPalOrderProcessor' => 'getUpdateExternalPayPalOrderProcessorService',
            'PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider' => 'getPayPalOrderProviderService',
            'PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderTranslationProvider' => 'getPayPalOrderTranslationProviderService',
            'PsCheckout\\Core\\PayPal\\Order\\Validator\\CreatedPayPalOrderValidator' => 'getCreatedPayPalOrderValidatorService',
            'PsCheckout\\Core\\PayPal\\Refund\\Provider\\PayPalRefundOrderProvider' => 'getPayPalRefundOrderProviderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingAction' => 'getAddTrackingActionService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingActionInterface' => 'getAddTrackingActionInterfaceService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\ProcessExternalShipmentAction' => 'getProcessExternalShipmentActionService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingBaseNodeBuilder' => 'getTrackingBaseNodeBuilderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingCarrierModuleNodeBuilder' => 'getTrackingCarrierModuleNodeBuilderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingItemsNodeBuilder' => 'getTrackingItemsNodeBuilderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder' => 'getTrackingPayloadBuilderService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache' => 'getShippingTrackingCacheService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ExternalShipmentProcessor' => 'getExternalShipmentProcessorService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessor' => 'getShipmentProcessorService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessorInterface' => 'getShipmentProcessorInterfaceService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService' => 'getTrackingApiServiceService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler' => 'getTrackingDatabaseHandlerService',
            'PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator' => 'getOrderTrackerValidatorService',
            'PsCheckout\\Core\\PaymentToken\\Action\\DeletePaymentTokenAction' => 'getDeletePaymentTokenActionService',
            'PsCheckout\\Core\\PaymentToken\\Action\\SavePaymentTokenAction' => 'getSavePaymentTokenActionService',
            'PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration' => 'getPayPalConfigurationService',
            'PsCheckout\\Core\\Settings\\Configuration\\PayPalSdkConfiguration' => 'getPayPalSdkConfigurationService',
            'PsCheckout\\Core\\WebhookDispatcher\\Action\\CheckPSLSignatureAction' => 'getCheckPSLSignatureActionService',
            'PsCheckout\\Core\\WebhookDispatcher\\Processor\\DispatchWebhookProcessor' => 'getDispatchWebhookProcessorService',
            'PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookBodyProvider' => 'getWebhookBodyProviderService',
            'PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookHeaderProvider' => 'getWebhookHeaderProviderService',
            'PsCheckout\\Core\\WebhookDispatcher\\Validator\\BodyValuesValidator' => 'getBodyValuesValidatorService',
            'PsCheckout\\Core\\WebhookDispatcher\\Validator\\HeaderValuesValidator' => 'getHeaderValuesValidatorService',
            'PsCheckout\\Core\\WebhookDispatcher\\Validator\\WebhookShopIdValidator' => 'getWebhookShopIdValidatorService',
            'PsCheckout\\Core\\Webhook\\Handler\\WebhookEventConfigurationUpdatedHandler' => 'getWebhookEventConfigurationUpdatedHandlerService',
            'PsCheckout\\Core\\Webhook\\Handler\\WebhookHandler' => 'getWebhookHandlerService',
            'PsCheckout\\Core\\Webhook\\Service\\WebhookSecretToken' => 'getWebhookSecretTokenService',
            'PsCheckout\\Infrastructure\\Action\\AddProductToCartAction' => 'getAddProductToCartActionService',
            'PsCheckout\\Infrastructure\\Action\\CreateOrUpdateAddressAction' => 'getCreateOrUpdateAddressActionService',
            'PsCheckout\\Infrastructure\\Action\\CustomerAuthenticationAction' => 'getCustomerAuthenticationActionService',
            'PsCheckout\\Infrastructure\\Action\\CustomerNotifyAction' => 'getCustomerNotifyActionService',
            'PsCheckout\\Infrastructure\\Adapter\\Address' => 'getAddressService',
            'PsCheckout\\Infrastructure\\Adapter\\Cart' => 'getCartService',
            'PsCheckout\\Infrastructure\\Adapter\\Configuration' => 'getConfiguration2Service',
            'PsCheckout\\Infrastructure\\Adapter\\Context' => 'getContextService',
            'PsCheckout\\Infrastructure\\Adapter\\Country' => 'getCountryService',
            'PsCheckout\\Infrastructure\\Adapter\\Currency' => 'getCurrencyService',
            'PsCheckout\\Infrastructure\\Adapter\\Customer' => 'getCustomerService',
            'PsCheckout\\Infrastructure\\Adapter\\Language' => 'getLanguageService',
            'PsCheckout\\Infrastructure\\Adapter\\Link' => 'getLinkService',
            'PsCheckout\\Infrastructure\\Adapter\\ShopContext' => 'getShopContextService',
            'PsCheckout\\Infrastructure\\Adapter\\SystemConfiguration' => 'getSystemConfigurationService',
            'PsCheckout\\Infrastructure\\Adapter\\Tools' => 'getTools2Service',
            'PsCheckout\\Infrastructure\\Adapter\\Validate' => 'getValidateService',
            'PsCheckout\\Infrastructure\\Environment\\Env' => 'getEnv3Service',
            'PsCheckout\\Infrastructure\\Environment\\EnvLoader' => 'getEnvLoaderService',
            'PsCheckout\\Infrastructure\\Logger\\LoggerFactory' => 'getLoggerFactoryService',
            'PsCheckout\\Infrastructure\\Logger\\LoggerFileFinder' => 'getLoggerFileFinderService',
            'PsCheckout\\Infrastructure\\Logger\\LoggerFileReader' => 'getLoggerFileReaderService',
            'PsCheckout\\Infrastructure\\Logger\\LoggerHandlerFactory' => 'getLoggerHandlerFactoryService',
            'PsCheckout\\Infrastructure\\Repository\\AddressRepository' => 'getAddressRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\CartRepository' => 'getCartRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\ConfigurationRepository' => 'getConfigurationRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\CountryRepository' => 'getCountryRepository2Service',
            'PsCheckout\\Infrastructure\\Repository\\CurrencyRepository' => 'getCurrencyRepository2Service',
            'PsCheckout\\Infrastructure\\Repository\\CustomerRepository' => 'getCustomerRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\FundingSourceRepository' => 'getFundingSourceRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\GenderRepository' => 'getGenderRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\LanguageRepository' => 'getLanguageRepository2Service',
            'PsCheckout\\Infrastructure\\Repository\\OrderHistoryRepository' => 'getOrderHistoryRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\OrderRepository' => 'getOrderRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\OrderStateRepository' => 'getOrderStateRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository' => 'getPayPalCustomerRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderAuthorizationRepository' => 'getPayPalOrderAuthorizationRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository' => 'getPayPalOrderCaptureRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderMatrixRepository' => 'getPayPalOrderMatrixRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderPurchaseUnitRepository' => 'getPayPalOrderPurchaseUnitRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderRefundRepository' => 'getPayPalOrderRefundRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository' => 'getPayPalOrderRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository' => 'getPaymentTokenRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\PsAccountRepository' => 'getPsAccountRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository' => 'getShippingTrackingRepositoryService',
            'PsCheckout\\Infrastructure\\Repository\\StateRepository' => 'getStateRepository2Service',
            'PsCheckout\\Infrastructure\\Validator\\FrontControllerValidator' => 'getFrontControllerValidatorService',
            'PsCheckout\\Infrastructure\\Validator\\MerchantValidator' => 'getMerchantValidatorService',
            'PsCheckout\\Module\\Presentation\\Translator' => 'getTranslatorService',
            'PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter' => 'getCartPresenterService',
            'PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter' => 'getFundingSourcePresenterService',
            'PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTokenPresenter' => 'getFundingSourceTokenPresenterService',
            'PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider' => 'getFundingSourceTranslationProviderService',
            'PsCheckout\\Presentation\\Presenter\\FundingSource\\LogoPresenter' => 'getLogoPresenterService',
            'PsCheckout\\Presentation\\Presenter\\OrderSummary\\OrderSummaryPresenter' => 'getOrderSummaryPresenterService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\FrontSettingsPresenter' => 'getFrontSettingsPresenterService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\ConfigurationModule' => 'getConfigurationModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\LinkModule' => 'getLinkModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\MediaModule' => 'getMediaModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\PayPalModule' => 'getPayPalModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\TranslationModule' => 'getTranslationModuleService',
            'PsCheckout\\Presentation\\Presenter\\Settings\\Front\\SupportedCardBrandsPresenter' => 'getSupportedCardBrandsPresenterService',
            'PsCheckout\\Utility\\Common\\InputStreamUtility' => 'getInputStreamUtilityService',
            'Psr\\Log\\LoggerInterface' => 'getLoggerInterfaceService',
            'Symfony\\Component\\HttpFoundation\\RequestStack' => 'getRequestStackService',
            'annotation_reader' => 'getAnnotationReaderService',
            'array' => 'getArrayService',
            'configuration' => 'getConfiguration3Service',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'context' => 'getContext2Service',
            'db' => 'getDbService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'prestashop.adapter.data_provider.country' => 'getPrestashop_Adapter_DataProvider_CountryService',
            'prestashop.adapter.employee_language_updater' => 'getPrestashop_Adapter_EmployeeLanguageUpdaterService',
            'prestashop.adapter.environment' => 'getPrestashop_Adapter_EnvironmentService',
            'prestashop.adapter.module.repository.module_repository' => 'getPrestashop_Adapter_Module_Repository_ModuleRepositoryService',
            'prestashop.adapter.validate' => 'getPrestashop_Adapter_ValidateService',
            'prestashop.core.circuit_breaker.advanced_factory' => 'getPrestashop_Core_CircuitBreaker_AdvancedFactoryService',
            'prestashop.core.circuit_breaker.cache' => 'getPrestashop_Core_CircuitBreaker_CacheService',
            'prestashop.core.circuit_breaker.doctrine_cache' => 'getPrestashop_Core_CircuitBreaker_DoctrineCacheService',
            'prestashop.core.circuit_breaker.storage' => 'getPrestashop_Core_CircuitBreaker_StorageService',
            'prestashop.core.filter.front_end_object.cart' => 'getPrestashop_Core_Filter_FrontEndObject_CartService',
            'prestashop.core.filter.front_end_object.configuration' => 'getPrestashop_Core_Filter_FrontEndObject_ConfigurationService',
            'prestashop.core.filter.front_end_object.customer' => 'getPrestashop_Core_Filter_FrontEndObject_CustomerService',
            'prestashop.core.filter.front_end_object.main' => 'getPrestashop_Core_Filter_FrontEndObject_MainService',
            'prestashop.core.filter.front_end_object.product' => 'getPrestashop_Core_Filter_FrontEndObject_ProductService',
            'prestashop.core.filter.front_end_object.product_collection' => 'getPrestashop_Core_Filter_FrontEndObject_ProductCollectionService',
            'prestashop.core.filter.front_end_object.search_result_product' => 'getPrestashop_Core_Filter_FrontEndObject_SearchResultProductService',
            'prestashop.core.filter.front_end_object.search_result_product_collection' => 'getPrestashop_Core_Filter_FrontEndObject_SearchResultProductCollectionService',
            'prestashop.core.filter.front_end_object.shop' => 'getPrestashop_Core_Filter_FrontEndObject_ShopService',
            'prestashop.core.localization.cache.adapter' => 'getPrestashop_Core_Localization_Cache_AdapterService',
            'prestashop.core.localization.cldr.cache.adapter' => 'getPrestashop_Core_Localization_Cldr_Cache_AdapterService',
            'prestashop.core.localization.cldr.datalayer.locale_cache' => 'getPrestashop_Core_Localization_Cldr_Datalayer_LocaleCacheService',
            'prestashop.core.localization.cldr.datalayer.locale_reference' => 'getPrestashop_Core_Localization_Cldr_Datalayer_LocaleReferenceService',
            'prestashop.core.localization.cldr.locale_data_source' => 'getPrestashop_Core_Localization_Cldr_LocaleDataSourceService',
            'prestashop.core.localization.cldr.reader' => 'getPrestashop_Core_Localization_Cldr_ReaderService',
            'prestashop.core.localization.currency.datasource' => 'getPrestashop_Core_Localization_Currency_DatasourceService',
            'prestashop.core.localization.currency.middleware.cache' => 'getPrestashop_Core_Localization_Currency_Middleware_CacheService',
            'prestashop.core.localization.currency.middleware.database' => 'getPrestashop_Core_Localization_Currency_Middleware_DatabaseService',
            'prestashop.core.localization.currency.middleware.installed' => 'getPrestashop_Core_Localization_Currency_Middleware_InstalledService',
            'prestashop.core.localization.currency.middleware.reference' => 'getPrestashop_Core_Localization_Currency_Middleware_ReferenceService',
            'prestashop.core.localization.currency.repository' => 'getPrestashop_Core_Localization_Currency_RepositoryService',
            'prestashop.core.localization.locale.context_locale' => 'getPrestashop_Core_Localization_Locale_ContextLocaleService',
            'prestashop.database.naming_strategy' => 'getPrestashop_Database_NamingStrategyService',
            'prestashop.translation.translator_language_loader' => 'getPrestashop_Translation_TranslatorLanguageLoaderService',
            'product_comment_criterion_repository' => 'getProductCommentCriterionRepositoryService',
            'product_comment_repository' => 'getProductCommentRepositoryService',
            'ps_accounts.facade' => 'getPsAccounts_FacadeService',
            'ps_accounts.installer' => 'getPsAccounts_InstallerService',
            'ps_checkout.db' => 'getPsCheckout_DbService',
            'ps_checkout.module' => 'getPsCheckout_ModuleService',
            'ps_facebook' => 'getPsFacebookService',
            'ps_facebook.billing_env' => 'getPsFacebook_BillingEnvService',
            'ps_facebook.cache' => 'getPsFacebook_CacheService',
            'ps_facebook.context' => 'getPsFacebook_ContextService',
            'ps_facebook.controller' => 'getPsFacebook_ControllerService',
            'ps_facebook.cookie' => 'getPsFacebook_CookieService',
            'ps_facebook.currency' => 'getPsFacebook_CurrencyService',
            'ps_facebook.language' => 'getPsFacebook_LanguageService',
            'ps_facebook.link' => 'getPsFacebook_LinkService',
            'ps_facebook.shop' => 'getPsFacebook_ShopService',
            'ps_facebook.smarty' => 'getPsFacebook_SmartyService',
            'psshipping' => 'getPsshippingService',
            'psshipping.context' => 'getPsshipping_ContextService',
            'psshipping.helper.config' => 'getPsshipping_Helper_ConfigService',
            'psshipping.ps_billings_context_wrapper' => 'getPsshipping_PsBillingsContextWrapperService',
            'psshipping.ps_billings_facade' => 'getPsshipping_PsBillingsFacadeService',
            'psshipping.ps_billings_service' => 'getPsshipping_PsBillingsServiceService',
            'psxmarketingwithgoogle' => 'getPsxmarketingwithgoogleService',
            'psxmarketingwithgoogle.billing_env' => 'getPsxmarketingwithgoogle_BillingEnvService',
            'psxmarketingwithgoogle.cart' => 'getPsxmarketingwithgoogle_CartService',
            'psxmarketingwithgoogle.context' => 'getPsxmarketingwithgoogle_ContextService',
            'psxmarketingwithgoogle.controller' => 'getPsxmarketingwithgoogle_ControllerService',
            'psxmarketingwithgoogle.cookie' => 'getPsxmarketingwithgoogle_CookieService',
            'psxmarketingwithgoogle.country' => 'getPsxmarketingwithgoogle_CountryService',
            'psxmarketingwithgoogle.currency' => 'getPsxmarketingwithgoogle_CurrencyService',
            'psxmarketingwithgoogle.customer' => 'getPsxmarketingwithgoogle_CustomerService',
            'psxmarketingwithgoogle.db' => 'getPsxmarketingwithgoogle_DbService',
            'psxmarketingwithgoogle.language' => 'getPsxmarketingwithgoogle_LanguageService',
            'psxmarketingwithgoogle.link' => 'getPsxmarketingwithgoogle_LinkService',
            'psxmarketingwithgoogle.shop' => 'getPsxmarketingwithgoogle_ShopService',
            'psxmarketingwithgoogle.smarty' => 'getPsxmarketingwithgoogle_SmartyService',
            'prestashop.core.localization.cldr.locale_repository' => 'getPrestashop_Core_Localization_Cldr_LocaleRepositoryService',
            'prestashop.adapter.tools' => 'getPrestashop_Adapter_ToolsService',
        ];
        $this->aliases = [
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\GoogleCategoryProviderInterface' => 'PrestaShop\\Module\\PrestashopFacebook\\Provider\\GoogleCategoryProvider',
            'PrestaShop\\Module\\PrestashopFacebook\\Provider\\ProductAvailabilityProviderInterface' => 'PrestaShop\\Module\\PrestashopFacebook\\Provider\\ProductAvailabilityProvider',
            'PrestaShop\\PrestaShop\\Core\\Currency\\CurrencyDataProviderInterface' => 'PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider',
            'PrestaShop\\PrestaShop\\Core\\Localization\\LocaleInterface' => 'prestashop.core.localization.locale.context_locale',
            'PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\RepositoryInterface' => 'PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
            'hashing' => 'PrestaShop\\PrestaShop\\Core\\Crypto\\Hashing',
            'prestashop.adapter.context_state_manager' => 'PrestaShop\\PrestaShop\\Adapter\\ContextStateManager',
            'prestashop.adapter.data_provider.currency' => 'PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider',
            'prestashop.adapter.legacy.configuration' => 'PrestaShop\\PrestaShop\\Adapter\\Configuration',
            'prestashop.adapter.legacy.context' => 'PrestaShop\\PrestaShop\\Adapter\\LegacyContext',
            'prestashop.core.localization.cldr.datalayer.top_layer' => 'prestashop.core.localization.cldr.datalayer.locale_cache',
            'prestashop.core.localization.currency.middleware.top_layer' => 'prestashop.core.localization.currency.middleware.cache',
            'prestashop.core.localization.locale.repository' => 'PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository',
            'request_stack' => 'Symfony\\Component\\HttpFoundation\\RequestStack',
        ];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return [
            '.abstract.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer' => true,
            '.abstract.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer' => true,
            '.abstract.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer' => true,
            '.abstract.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer' => true,
            '.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\TypeLayerInterface.0.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer' => true,
            '.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\TypeLayerInterface.0.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer' => true,
            '.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\TypeLayerInterface.0.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer' => true,
            '.instanceof.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\TypeLayerInterface.0.PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer' => true,
            '.service_locator.fiyeV0.' => true,
            '.service_locator.lWqUA3s' => true,
            'Doctrine\\Bundle\\DoctrineBundle\\Controller\\ProfilerController' => true,
            'Doctrine\\Bundle\\DoctrineBundle\\Dbal\\ManagerRegistryAwareConnectionProvider' => true,
            'Doctrine\\Common\\Persistence\\ManagerRegistry' => true,
            'Doctrine\\DBAL\\Connection' => true,
            'Doctrine\\DBAL\\Connection $defaultConnection' => true,
            'Doctrine\\DBAL\\Driver\\Connection' => true,
            'Doctrine\\DBAL\\Tools\\Console\\Command\\RunSqlCommand' => true,
            'Doctrine\\ORM\\EntityManagerInterface' => true,
            'Doctrine\\ORM\\EntityManagerInterface $defaultEntityManager' => true,
            'Doctrine\\Persistence\\ManagerRegistry' => true,
            'PrestaShopBundle\\DependencyInjection\\CacheAdapterFactory' => true,
            'PrestaShopBundle\\DependencyInjection\\RuntimeConstEnvVarProcessor' => true,
            'PrestaShopBundle\\Entity\\Repository\\FeatureFlagRepository' => true,
            'PrestaShopBundle\\Entity\\Repository\\TabRepository' => true,
            'PrestaShopCorp\\Billing\\Wrappers\\BillingContextWrapper' => true,
            'PrestaShop\\PrestaShop\\Adapter\\Country\\CountryDataProvider' => true,
            'PrestaShop\\PrestaShop\\Core\\EnvironmentInterface' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\FeatureFlagManager' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer' => true,
            'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer' => true,
            'PrestaShop\\PrestaShop\\Core\\Security\\Hashing' => true,
            'data_collector.doctrine' => true,
            'doctrine.cache_clear_metadata_command' => true,
            'doctrine.cache_clear_query_cache_command' => true,
            'doctrine.cache_clear_result_command' => true,
            'doctrine.cache_collection_region_command' => true,
            'doctrine.clear_entity_region_command' => true,
            'doctrine.clear_query_region_command' => true,
            'doctrine.database_create_command' => true,
            'doctrine.database_drop_command' => true,
            'doctrine.dbal.connection' => true,
            'doctrine.dbal.connection.configuration' => true,
            'doctrine.dbal.connection.event_manager' => true,
            'doctrine.dbal.connection_factory' => true,
            'doctrine.dbal.default_connection.configuration' => true,
            'doctrine.dbal.default_connection.event_manager' => true,
            'doctrine.dbal.event_manager' => true,
            'doctrine.dbal.logger' => true,
            'doctrine.dbal.logger.backtrace' => true,
            'doctrine.dbal.logger.chain' => true,
            'doctrine.dbal.logger.profiling' => true,
            'doctrine.dbal.logging_middleware' => true,
            'doctrine.dbal.schema_asset_filter_manager' => true,
            'doctrine.dbal.well_known_schema_asset_filter' => true,
            'doctrine.ensure_production_settings_command' => true,
            'doctrine.mapping_convert_command' => true,
            'doctrine.mapping_import_command' => true,
            'doctrine.mapping_info_command' => true,
            'doctrine.orm.configuration' => true,
            'doctrine.orm.container_repository_factory' => true,
            'doctrine.orm.default_annotation_metadata_driver' => true,
            'doctrine.orm.default_configuration' => true,
            'doctrine.orm.default_entity_listener_resolver' => true,
            'doctrine.orm.default_entity_manager.event_manager' => true,
            'doctrine.orm.default_entity_manager.property_info_extractor' => true,
            'doctrine.orm.default_entity_manager.validator_loader' => true,
            'doctrine.orm.default_listeners.attach_entity_listeners' => true,
            'doctrine.orm.default_manager_configurator' => true,
            'doctrine.orm.default_metadata_cache' => true,
            'doctrine.orm.default_metadata_driver' => true,
            'doctrine.orm.default_query_cache' => true,
            'doctrine.orm.default_result_cache' => true,
            'doctrine.orm.entity_manager.abstract' => true,
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber' => true,
            'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber' => true,
            'doctrine.orm.listeners.resolve_target_entity' => true,
            'doctrine.orm.manager_configurator.abstract' => true,
            'doctrine.orm.messenger.doctrine_schema_subscriber' => true,
            'doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager' => true,
            'doctrine.orm.metadata.annotation_reader' => true,
            'doctrine.orm.naming_strategy.default' => true,
            'doctrine.orm.naming_strategy.underscore' => true,
            'doctrine.orm.naming_strategy.underscore_number_aware' => true,
            'doctrine.orm.proxy_cache_warmer' => true,
            'doctrine.orm.quote_strategy.ansi' => true,
            'doctrine.orm.quote_strategy.default' => true,
            'doctrine.orm.security.user.provider' => true,
            'doctrine.orm.validator.unique' => true,
            'doctrine.orm.validator_initializer' => true,
            'doctrine.query_dql_command' => true,
            'doctrine.query_sql_command' => true,
            'doctrine.schema_create_command' => true,
            'doctrine.schema_drop_command' => true,
            'doctrine.schema_update_command' => true,
            'doctrine.schema_validate_command' => true,
            'doctrine.twig.doctrine_extension' => true,
            'doctrine.ulid_generator' => true,
            'doctrine.uuid_generator' => true,
            'form.type.entity' => true,
            'form.type_guesser.doctrine' => true,
            'messenger.middleware.doctrine_close_connection' => true,
            'messenger.middleware.doctrine_open_transaction_logger' => true,
            'messenger.middleware.doctrine_ping_connection' => true,
            'messenger.middleware.doctrine_transaction' => true,
            'messenger.transport.doctrine.factory' => true,
            'prestashop.core.crypto.hashing' => true,
        ];
    }

    protected function createProxy($class, \Closure $factory)
    {
        return $factory();
    }

    /**
     * Gets the public 'Monolog\Handler\HandlerInterface' shared service.
     *
     * @return \Monolog\Handler\HandlerInterface
     */
    protected static function getHandlerInterfaceService($container)
    {
        return $container->services['Monolog\\Handler\\HandlerInterface'] = ($container->services['PsCheckout\\Infrastructure\\Logger\\LoggerHandlerFactory'] ?? self::getLoggerHandlerFactoryService($container))->build();
    }

    /**
     * Gets the public 'PrestaShopBundle\Security\Admin\LegacyAdminTokenValidator' shared service.
     *
     * @return \PrestaShopBundle\Security\Admin\LegacyAdminTokenValidator
     */
    protected static function getLegacyAdminTokenValidatorService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['PrestaShopBundle\\Security\\Admin\\LegacyAdminTokenValidator'] = $container->createProxy('LegacyAdminTokenValidatorGhost2817cf2', static fn () => \LegacyAdminTokenValidatorGhost2817cf2::createLazyGhost(static fn ($proxy) => self::getLegacyAdminTokenValidatorService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->services['PrestaShop\\PrestaShop\\Adapter\\Employee\\EmployeeRepository'] ??= new \PrestaShop\PrestaShop\Adapter\Employee\EmployeeRepository()), ($container->services['Symfony\\Component\\HttpFoundation\\RequestStack'] ?? self::getRequestStackService($container))) && false ?: $lazyLoad);
    }

    /**
     * Gets the public 'PrestaShopCorp\Billing\Presenter\BillingPresenter' shared service.
     *
     * @return \PrestaShopCorp\Billing\Presenter\BillingPresenter
     */
    protected static function getBillingPresenterService($container)
    {
        return $container->services['PrestaShopCorp\\Billing\\Presenter\\BillingPresenter'] = new \PrestaShopCorp\Billing\Presenter\BillingPresenter(($container->privates['PrestaShopCorp\\Billing\\Wrappers\\BillingContextWrapper'] ?? self::getBillingContextWrapperService($container)), ($container->services['ps_facebook'] ?? self::getPsFacebookService($container)));
    }

    /**
     * Gets the public 'PrestaShopCorp\Billing\Services\BillingService' shared service.
     *
     * @return \PrestaShopCorp\Billing\Services\BillingService
     */
    protected static function getBillingServiceService($container)
    {
        return $container->services['PrestaShopCorp\\Billing\\Services\\BillingService'] = new \PrestaShopCorp\Billing\Services\BillingService(($container->privates['PrestaShopCorp\\Billing\\Wrappers\\BillingContextWrapper'] ?? self::getBillingContextWrapperService($container)), ($container->services['ps_facebook'] ?? self::getPsFacebookService($container)));
    }

    /**
     * Gets the public 'PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider' shared service.
     *
     * @return \PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider
     */
    protected static function getCacheDirectoryProviderService($container)
    {
        return $container->services['PrestaShop\\ModuleLibCacheDirectoryProvider\\Cache\\CacheDirectoryProvider'] = new \PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider('9.0.2', '/home/fletcher/public_html/fletchermall.com', false);
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\API\Client\FacebookCategoryClient' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\API\Client\FacebookCategoryClient
     */
    protected static function getFacebookCategoryClientService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\API\\Client\\FacebookCategoryClient'] = new \PrestaShop\Module\PrestashopFacebook\API\Client\FacebookCategoryClient(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Factory\\PsApiClientFactory'] ?? self::getPsApiClientFactoryService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\GoogleCategoryRepository'] ?? self::getGoogleCategoryRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\API\Client\FacebookClient' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\API\Client\FacebookClient
     */
    protected static function getFacebookClientService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\API\\Client\\FacebookClient'] = new \PrestaShop\Module\PrestashopFacebook\API\Client\FacebookClient(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Factory\\FacebookEssentialsApiClientFactory'] ??= new \PrestaShop\Module\PrestashopFacebook\Factory\FacebookEssentialsApiClientFactory()), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\AccessTokenProvider'] ?? self::getAccessTokenProviderService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\ConfigurationHandler'] ?? self::getConfigurationHandlerService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\API\EventSubscriber\AccountSuspendedSubscriber' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\API\EventSubscriber\AccountSuspendedSubscriber
     */
    protected static function getAccountSuspendedSubscriberService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\API\\EventSubscriber\\AccountSuspendedSubscriber'] = new \PrestaShop\Module\PrestashopFacebook\API\EventSubscriber\AccountSuspendedSubscriber(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\API\EventSubscriber\ApiErrorSubscriber' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\API\EventSubscriber\ApiErrorSubscriber
     */
    protected static function getApiErrorSubscriberService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\API\\EventSubscriber\\ApiErrorSubscriber'] = new \PrestaShop\Module\PrestashopFacebook\API\EventSubscriber\ApiErrorSubscriber();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Adapter\ConfigurationAdapter' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Adapter\ConfigurationAdapter
     */
    protected static function getConfigurationAdapterService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] = new \PrestaShop\Module\PrestashopFacebook\Adapter\ConfigurationAdapter(($container->services['ps_facebook.shop'] ?? self::getPsFacebook_ShopService($container))->id);
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Adapter\ToolsAdapter' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Adapter\ToolsAdapter
     */
    protected static function getToolsAdapterService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ToolsAdapter'] = new \PrestaShop\Module\PrestashopFacebook\Adapter\ToolsAdapter();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Buffer\TemplateBuffer' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Buffer\TemplateBuffer
     */
    protected static function getTemplateBufferService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Buffer\\TemplateBuffer'] = new \PrestaShop\Module\PrestashopFacebook\Buffer\TemplateBuffer();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Config\Env' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Config\Env
     */
    protected static function getEnvService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Config\\Env'] = new \PrestaShop\Module\PrestashopFacebook\Config\Env();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Dispatcher\EventDispatcher' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Dispatcher\EventDispatcher
     */
    protected static function getEventDispatcherService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Dispatcher\\EventDispatcher'] = new \PrestaShop\Module\PrestashopFacebook\Dispatcher\EventDispatcher(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\ApiConversionHandler'] ?? self::getApiConversionHandlerService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\PixelHandler'] ?? self::getPixelHandlerService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\EventDataProvider'] ?? self::getEventDataProviderService($container)), ($container->services['ps_facebook.context'] ?? self::getPsFacebook_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Factory\FacebookEssentialsApiClientFactory' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Factory\FacebookEssentialsApiClientFactory
     */
    protected static function getFacebookEssentialsApiClientFactoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Factory\\FacebookEssentialsApiClientFactory'] = new \PrestaShop\Module\PrestashopFacebook\Factory\FacebookEssentialsApiClientFactory();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Factory\PsApiClientFactory' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Factory\PsApiClientFactory
     */
    protected static function getPsApiClientFactoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Factory\\PsApiClientFactory'] = new \PrestaShop\Module\PrestashopFacebook\Factory\PsApiClientFactory(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Config\\Env'] ??= new \PrestaShop\Module\PrestashopFacebook\Config\Env()), ($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] ?? self::getPsAccountsService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Handler\ApiConversionHandler' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Handler\ApiConversionHandler
     */
    protected static function getApiConversionHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\ApiConversionHandler'] = new \PrestaShop\Module\PrestashopFacebook\Handler\ApiConversionHandler(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\ErrorHandler\\ErrorHandler'] ??= new \PrestaShop\Module\PrestashopFacebook\Handler\ErrorHandler\ErrorHandler()), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\API\\Client\\FacebookClient'] ?? self::getFacebookClientService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Handler\CategoryMatchHandler' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Handler\CategoryMatchHandler
     */
    protected static function getCategoryMatchHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\CategoryMatchHandler'] = new \PrestaShop\Module\PrestashopFacebook\Handler\CategoryMatchHandler(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\GoogleCategoryRepository'] ?? self::getGoogleCategoryRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Handler\ConfigurationHandler' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Handler\ConfigurationHandler
     */
    protected static function getConfigurationHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\ConfigurationHandler'] = new \PrestaShop\Module\PrestashopFacebook\Handler\ConfigurationHandler(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Handler\ErrorHandler\ErrorHandler' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Handler\ErrorHandler\ErrorHandler
     */
    protected static function getErrorHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\ErrorHandler\\ErrorHandler'] = new \PrestaShop\Module\PrestashopFacebook\Handler\ErrorHandler\ErrorHandler();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Handler\EventBusProductHandler' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Handler\EventBusProductHandler
     */
    protected static function getEventBusProductHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\EventBusProductHandler'] = new \PrestaShop\Module\PrestashopFacebook\Handler\EventBusProductHandler(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\ProductRepository'] ??= new \PrestaShop\Module\PrestashopFacebook\Repository\ProductRepository()));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Handler\MessengerHandler' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Handler\MessengerHandler
     */
    protected static function getMessengerHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\MessengerHandler'] = new \PrestaShop\Module\PrestashopFacebook\Handler\MessengerHandler(($container->services['ps_facebook.language'] ?? self::getPsFacebook_LanguageService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Config\\Env'] ??= new \PrestaShop\Module\PrestashopFacebook\Config\Env()));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Handler\PixelHandler' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Handler\PixelHandler
     */
    protected static function getPixelHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\PixelHandler'] = new \PrestaShop\Module\PrestashopFacebook\Handler\PixelHandler(($container->services['ps_facebook'] ?? self::getPsFacebookService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Handler\PrevalidationScanRefreshHandler' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Handler\PrevalidationScanRefreshHandler
     */
    protected static function getPrevalidationScanRefreshHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Handler\\PrevalidationScanRefreshHandler'] = new \PrestaShop\Module\PrestashopFacebook\Handler\PrevalidationScanRefreshHandler(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\PrevalidationScanCacheProvider'] ?? self::getPrevalidationScanCacheProviderService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\ProductRepository'] ??= new \PrestaShop\Module\PrestashopFacebook\Repository\ProductRepository()), ($container->services['ps_facebook.shop'] ?? self::getPsFacebook_ShopService($container))->id);
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Manager\FbeFeatureManager' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Manager\FbeFeatureManager
     */
    protected static function getFbeFeatureManagerService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Manager\\FbeFeatureManager'] = new \PrestaShop\Module\PrestashopFacebook\Manager\FbeFeatureManager(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\API\\Client\\FacebookClient'] ?? self::getFacebookClientService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Presenter\ModuleUpgradePresenter' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Presenter\ModuleUpgradePresenter
     */
    protected static function getModuleUpgradePresenterService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Presenter\\ModuleUpgradePresenter'] = new \PrestaShop\Module\PrestashopFacebook\Presenter\ModuleUpgradePresenter(($container->services['ps_facebook.context'] ?? self::getPsFacebook_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\AccessTokenProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\AccessTokenProvider
     */
    protected static function getAccessTokenProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\AccessTokenProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\AccessTokenProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['ps_facebook.controller'] ?? self::getPsFacebook_ControllerService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Factory\\PsApiClientFactory'] ?? self::getPsApiClientFactoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\EventDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\EventDataProvider
     */
    protected static function getEventDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\EventDataProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\EventDataProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ToolsAdapter'] ??= new \PrestaShop\Module\PrestashopFacebook\Adapter\ToolsAdapter()), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\ProductRepository'] ??= new \PrestaShop\Module\PrestashopFacebook\Repository\ProductRepository()), ($container->services['ps_facebook.context'] ?? self::getPsFacebook_ContextService($container)), ($container->services['ps_facebook'] ?? self::getPsFacebookService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\ProductAvailabilityProvider'] ??= new \PrestaShop\Module\PrestashopFacebook\Provider\ProductAvailabilityProvider()), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\GoogleCategoryRepository'] ?? self::getGoogleCategoryRepositoryService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\GoogleCategoryProvider'] ?? self::getGoogleCategoryProviderService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\FacebookDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\FacebookDataProvider
     */
    protected static function getFacebookDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\FacebookDataProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\FacebookDataProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\API\\Client\\FacebookClient'] ?? self::getFacebookClientService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\FbeDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\FbeDataProvider
     */
    protected static function getFbeDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\FbeDataProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\FbeDataProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\FbeFeatureDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\FbeFeatureDataProvider
     */
    protected static function getFbeFeatureDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\FbeFeatureDataProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\FbeFeatureDataProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\API\\Client\\FacebookClient'] ?? self::getFacebookClientService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\GoogleCategoryProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\GoogleCategoryProvider
     */
    protected static function getGoogleCategoryProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\GoogleCategoryProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\GoogleCategoryProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\GoogleCategoryRepository'] ?? self::getGoogleCategoryRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\MultishopDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\MultishopDataProvider
     */
    protected static function getMultishopDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\MultishopDataProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\MultishopDataProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\ShopRepository'] ??= new \PrestaShop\Module\PrestashopFacebook\Repository\ShopRepository()), ($container->services['PrestaShop\\Module\\Ps_facebook\\Tracker\\Segment'] ?? self::getSegmentService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\PrevalidationScanCacheProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\PrevalidationScanCacheProvider
     */
    protected static function getPrevalidationScanCacheProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\PrevalidationScanCacheProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\PrevalidationScanCacheProvider(($container->services['ps_facebook'] ?? self::getPsFacebookService($container)), ($container->services['ps_facebook.cache'] ?? self::getPsFacebook_CacheService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\PrevalidationScanDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\PrevalidationScanDataProvider
     */
    protected static function getPrevalidationScanDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\PrevalidationScanDataProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\PrevalidationScanDataProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\PrevalidationScanCacheProvider'] ?? self::getPrevalidationScanCacheProviderService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\ProductAvailabilityProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\ProductAvailabilityProvider
     */
    protected static function getProductAvailabilityProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\ProductAvailabilityProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\ProductAvailabilityProvider();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Provider\ProductSyncReportProvider' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Provider\ProductSyncReportProvider
     */
    protected static function getProductSyncReportProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Provider\\ProductSyncReportProvider'] = new \PrestaShop\Module\PrestashopFacebook\Provider\ProductSyncReportProvider(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Factory\\PsApiClientFactory'] ?? self::getPsApiClientFactoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Repository\GoogleCategoryRepository' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Repository\GoogleCategoryRepository
     */
    protected static function getGoogleCategoryRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\GoogleCategoryRepository'] = new \PrestaShop\Module\PrestashopFacebook\Repository\GoogleCategoryRepository(($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Repository\ProductRepository' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Repository\ProductRepository
     */
    protected static function getProductRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\ProductRepository'] = new \PrestaShop\Module\PrestashopFacebook\Repository\ProductRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Repository\ServerInformationRepository' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Repository\ServerInformationRepository
     */
    protected static function getServerInformationRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\ServerInformationRepository'] = new \PrestaShop\Module\PrestashopFacebook\Repository\ServerInformationRepository(($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] ?? self::getPsAccountsService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Repository\ShopRepository' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Repository\ShopRepository
     */
    protected static function getShopRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\ShopRepository'] = new \PrestaShop\Module\PrestashopFacebook\Repository\ShopRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PrestashopFacebook\Repository\TabRepository' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Repository\TabRepository
     */
    protected static function getTabRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PrestashopFacebook\\Repository\\TabRepository'] = new \PrestaShop\Module\PrestashopFacebook\Repository\TabRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsAccounts\Presenter\PsAccountsPresenter' shared service.
     *
     * @return \PrestaShop\Module\PsAccounts\Presenter\PsAccountsPresenter
     */
    protected static function getPsAccountsPresenterService($container)
    {
        return $container->services['PrestaShop\\Module\\PsAccounts\\Presenter\\PsAccountsPresenter'] = \PrestaShop\Module\PsAccounts\ServiceProvider\StaticProvider::provide('PrestaShop\\Module\\PsAccounts\\Presenter\\PsAccountsPresenter');
    }

    /**
     * Gets the public 'PrestaShop\Module\PsAccounts\Repository\UserTokenRepository' shared service.
     *
     * @return \PrestaShop\Module\PsAccounts\Repository\UserTokenRepository
     */
    protected static function getUserTokenRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsAccounts\\Repository\\UserTokenRepository'] = \PrestaShop\Module\PsAccounts\ServiceProvider\StaticProvider::provide('PrestaShop\\Module\\PsAccounts\\Repository\\UserTokenRepository');
    }

    /**
     * Gets the public 'PrestaShop\Module\PsAccounts\Service\PsAccountsService' shared service.
     *
     * @return \PrestaShop\Module\PsAccounts\Service\PsAccountsService
     */
    protected static function getPsAccountsServiceService($container)
    {
        return $container->services['PrestaShop\\Module\\PsAccounts\\Service\\PsAccountsService'] = \PrestaShop\Module\PsAccounts\ServiceProvider\StaticProvider::provide('PrestaShop\\Module\\PsAccounts\\Service\\PsAccountsService');
    }

    /**
     * Gets the public 'PrestaShop\Module\PsAccounts\Service\PsBillingService' shared service.
     *
     * @return \PrestaShop\Module\PsAccounts\Service\PsBillingService
     */
    protected static function getPsBillingServiceService($container)
    {
        return $container->services['PrestaShop\\Module\\PsAccounts\\Service\\PsBillingService'] = \PrestaShop\Module\PsAccounts\ServiceProvider\StaticProvider::provide('PrestaShop\\Module\\PsAccounts\\Service\\PsBillingService');
    }

    /**
     * Gets the public 'PrestaShop\Module\Ps_facebook\Tracker\Segment' shared service.
     *
     * @return \PrestaShop\Module\Ps_facebook\Tracker\Segment
     */
    protected static function getSegmentService($container)
    {
        return $container->services['PrestaShop\\Module\\Ps_facebook\\Tracker\\Segment'] = new \PrestaShop\Module\Ps_facebook\Tracker\Segment(($container->services['ps_facebook.context'] ?? self::getPsFacebook_ContextService($container)), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Config\\Env'] ??= new \PrestaShop\Module\PrestashopFacebook\Config\Env()), ($container->services['PrestaShop\\Module\\PrestashopFacebook\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapterService($container)), ($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] ?? self::getPsAccountsService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Controller\Admin\PsshippingCarrierController' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingCarrierController
     */
    protected static function getPsshippingCarrierControllerService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingCarrierController'] = new \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingCarrierController(($container->services['psshipping'] ?? self::getPsshippingService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierService'] ?? self::getCarrierServiceService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Controller\Admin\PsshippingConfigurationController' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingConfigurationController
     */
    protected static function getPsshippingConfigurationControllerService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingConfigurationController'] = new \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingConfigurationController(($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Controller\Admin\PsshippingFaqController' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingFaqController
     */
    protected static function getPsshippingFaqControllerService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingFaqController'] = new \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingFaqController(($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Controller\Admin\PsshippingHomeController' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingHomeController
     */
    protected static function getPsshippingHomeControllerService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingHomeController'] = new \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingHomeController(($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Controller\Admin\PsshippingKeycloakAuthController' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingKeycloakAuthController
     */
    protected static function getPsshippingKeycloakAuthControllerService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingKeycloakAuthController'] = new \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingKeycloakAuthController();
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Controller\Admin\PsshippingOrdersController' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingOrdersController
     */
    protected static function getPsshippingOrdersControllerService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Controller\\Admin\\PsshippingOrdersController'] = new \PrestaShop\Module\Psshipping\Controller\Admin\PsshippingOrdersController(($container->services['psshipping'] ?? self::getPsshippingService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierService'] ?? self::getCarrierServiceService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Domain\Carriers\CarrierRepository' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Domain\Carriers\CarrierRepository
     */
    protected static function getCarrierRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierRepository'] = new \PrestaShop\Module\Psshipping\Domain\Carriers\CarrierRepository(($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Domain\Carriers\CarrierService' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Domain\Carriers\CarrierService
     */
    protected static function getCarrierServiceService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierService'] = new \PrestaShop\Module\Psshipping\Domain\Carriers\CarrierService(($container->services['psshipping'] ?? self::getPsshippingService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierRepository'] ?? self::getCarrierRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Domain\Carriers\PickupCarrierConfiguration' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Domain\Carriers\PickupCarrierConfiguration
     */
    protected static function getPickupCarrierConfigurationService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupCarrierConfiguration'] = new \PrestaShop\Module\Psshipping\Domain\Carriers\PickupCarrierConfiguration('prestashop.core.command_bus');
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Domain\Carriers\PickupPoints\PsshippingAddressOrdersRepository' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Domain\Carriers\PickupPoints\PsshippingAddressOrdersRepository
     */
    protected static function getPsshippingAddressOrdersRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupPoints\\PsshippingAddressOrdersRepository'] = new \PrestaShop\Module\Psshipping\Domain\Carriers\PickupPoints\PsshippingAddressOrdersRepository(($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Domain\Carriers\PickupPoints\PsshippingAddressRepository' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Domain\Carriers\PickupPoints\PsshippingAddressRepository
     */
    protected static function getPsshippingAddressRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupPoints\\PsshippingAddressRepository'] = new \PrestaShop\Module\Psshipping\Domain\Carriers\PickupPoints\PsshippingAddressRepository(($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Domain\Carriers\StandardCarrierConfiguration' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Domain\Carriers\StandardCarrierConfiguration
     */
    protected static function getStandardCarrierConfigurationService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\StandardCarrierConfiguration'] = new \PrestaShop\Module\Psshipping\Domain\Carriers\StandardCarrierConfiguration('prestashop.core.command_bus');
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Domain\GelProximity\GelProximityService' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Domain\GelProximity\GelProximityService
     */
    protected static function getGelProximityServiceService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Domain\\GelProximity\\GelProximityService'] = new \PrestaShop\Module\Psshipping\Domain\GelProximity\GelProximityService(($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Domain\Orders\OrdersRepository' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Domain\Orders\OrdersRepository
     */
    protected static function getOrdersRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Domain\\Orders\\OrdersRepository'] = new \PrestaShop\Module\Psshipping\Domain\Orders\OrdersRepository(($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Handler\ErrorHandler' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Handler\ErrorHandler
     */
    protected static function getErrorHandler2Service($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Handler\\ErrorHandler'] = new \PrestaShop\Module\Psshipping\Handler\ErrorHandler();
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Hooks\HookActionObjectCarrierUpdateAfter' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Hooks\HookActionObjectCarrierUpdateAfter
     */
    protected static function getHookActionObjectCarrierUpdateAfterService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Hooks\\HookActionObjectCarrierUpdateAfter'] = new \PrestaShop\Module\Psshipping\Hooks\HookActionObjectCarrierUpdateAfter(($container->services['psshipping'] ?? self::getPsshippingService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierRepository'] ?? self::getCarrierRepositoryService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Orders\\OrdersRepository'] ?? self::getOrdersRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Hooks\HookActionValidateOrder' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Hooks\HookActionValidateOrder
     */
    protected static function getHookActionValidateOrderService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Hooks\\HookActionValidateOrder'] = new \PrestaShop\Module\Psshipping\Hooks\HookActionValidateOrder(($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierRepository'] ?? self::getCarrierRepositoryService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupPoints\\PsshippingAddressRepository'] ?? self::getPsshippingAddressRepositoryService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupPoints\\PsshippingAddressOrdersRepository'] ?? self::getPsshippingAddressOrdersRepositoryService($container)), ($container->services['psshipping.context'] ?? self::getPsshipping_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Hooks\HookDisplayCarrierExtraContent' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Hooks\HookDisplayCarrierExtraContent
     */
    protected static function getHookDisplayCarrierExtraContentService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Hooks\\HookDisplayCarrierExtraContent'] = new \PrestaShop\Module\Psshipping\Hooks\HookDisplayCarrierExtraContent(($container->services['psshipping'] ?? self::getPsshippingService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierRepository'] ?? self::getCarrierRepositoryService($container)), ($container->services['psshipping.context'] ?? self::getPsshipping_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Hooks\HookDisplayHeader' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Hooks\HookDisplayHeader
     */
    protected static function getHookDisplayHeaderService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Hooks\\HookDisplayHeader'] = new \PrestaShop\Module\Psshipping\Hooks\HookDisplayHeader(($container->services['psshipping'] ?? self::getPsshippingService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\GelProximity\\GelProximityService'] ?? self::getGelProximityServiceService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierRepository'] ?? self::getCarrierRepositoryService($container)), ($container->services['psshipping.context'] ?? self::getPsshipping_ContextService($container)), 'https://platform.gelproximity.com/gel-enduser-client/');
    }

    /**
     * Gets the public 'PrestaShop\Module\Psshipping\Hooks\HookDisplayOrderConfirmation' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Hooks\HookDisplayOrderConfirmation
     */
    protected static function getHookDisplayOrderConfirmationService($container)
    {
        return $container->services['PrestaShop\\Module\\Psshipping\\Hooks\\HookDisplayOrderConfirmation'] = new \PrestaShop\Module\Psshipping\Hooks\HookDisplayOrderConfirmation(($container->services['psshipping'] ?? self::getPsshippingService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\CarrierRepository'] ?? self::getCarrierRepositoryService($container)), ($container->services['PrestaShop\\Module\\Psshipping\\Domain\\Carriers\\PickupPoints\\PsshippingAddressOrdersRepository'] ?? self::getPsshippingAddressOrdersRepositoryService($container)), ($container->services['psshipping.context'] ?? self::getPsshipping_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Adapter\ConfigurationAdapter' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Adapter\ConfigurationAdapter
     */
    protected static function getConfigurationAdapter2Service($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Adapter\ConfigurationAdapter(($container->services['psxmarketingwithgoogle.shop'] ?? self::getPsxmarketingwithgoogle_ShopService($container))->id);
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Buffer\TemplateBuffer' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Buffer\TemplateBuffer
     */
    protected static function getTemplateBuffer2Service($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Buffer\\TemplateBuffer'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Buffer\TemplateBuffer();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Config\Env' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Config\Env
     */
    protected static function getEnv2Service($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Config\\Env'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Config\Env();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Conversion\EnhancedConversionToggle' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Conversion\EnhancedConversionToggle
     */
    protected static function getEnhancedConversionToggleService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Conversion\\EnhancedConversionToggle'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Conversion\EnhancedConversionToggle(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapter2Service($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Conversion\UserDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Conversion\UserDataProvider
     */
    protected static function getUserDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Conversion\\UserDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Conversion\UserDataProvider(($container->services['psxmarketingwithgoogle.customer'] ?? self::getPsxmarketingwithgoogle_CustomerService($container)), ($container->services['psxmarketingwithgoogle.cart'] ?? self::getPsxmarketingwithgoogle_CartService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Handler\ErrorHandler' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Handler\ErrorHandler
     */
    protected static function getErrorHandler3Service($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\ErrorHandler'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Handler\ErrorHandler();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Handler\RemarketingHookHandler' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Handler\RemarketingHookHandler
     */
    protected static function getRemarketingHookHandlerService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Handler\\RemarketingHookHandler'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Handler\RemarketingHookHandler(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapter2Service($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Buffer\\TemplateBuffer'] ??= new \PrestaShop\Module\PsxMarketingWithGoogle\Buffer\TemplateBuffer()), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)), ($container->services['psxmarketingwithgoogle'] ?? self::getPsxmarketingwithgoogleService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\CartEventDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\CartEventDataProvider
     */
    protected static function getCartEventDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\CartEventDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\CartEventDataProvider(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\PageViewEventDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\PageViewEventDataProvider
     */
    protected static function getPageViewEventDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\PageViewEventDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\PageViewEventDataProvider(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\ProductDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\ProductDataProvider
     */
    protected static function getProductDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\ProductDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\ProductDataProvider(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\PurchaseEventDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\PurchaseEventDataProvider
     */
    protected static function getPurchaseEventDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\PurchaseEventDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\PurchaseEventDataProvider(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\ProductDataProvider'] ?? self::getProductDataProviderService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapter2Service($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\LanguageRepository'] ?? self::getLanguageRepositoryService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CountryRepository'] ?? self::getCountryRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Provider\VerificationTagDataProvider' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Provider\VerificationTagDataProvider
     */
    protected static function getVerificationTagDataProviderService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Provider\\VerificationTagDataProvider'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Provider\VerificationTagDataProvider(($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapter2Service($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\VerificationTagRepository'] ?? self::getVerificationTagRepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\AttributesRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\AttributesRepository
     */
    protected static function getAttributesRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\AttributesRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\AttributesRepository(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\CarrierRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CarrierRepository
     */
    protected static function getCarrierRepository2Service($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CarrierRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CarrierRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\CategoryRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CategoryRepository
     */
    protected static function getCategoryRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CategoryRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CategoryRepository(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\CountryRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CountryRepository
     */
    protected static function getCountryRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CountryRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CountryRepository(($container->services['psxmarketingwithgoogle.db'] ?? self::getPsxmarketingwithgoogle_DbService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)), ($container->services['psxmarketingwithgoogle.country'] ?? self::getPsxmarketingwithgoogle_CountryService($container)), ($container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Adapter\\ConfigurationAdapter'] ?? self::getConfigurationAdapter2Service($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\CurrencyRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CurrencyRepository
     */
    protected static function getCurrencyRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\CurrencyRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\CurrencyRepository(($container->services['psxmarketingwithgoogle.currency'] ?? self::getPsxmarketingwithgoogle_CurrencyService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\LanguageRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\LanguageRepository
     */
    protected static function getLanguageRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\LanguageRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\LanguageRepository(($container->services['psxmarketingwithgoogle.shop'] ?? self::getPsxmarketingwithgoogle_ShopService($container))->id);
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\ManufacturerRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\ManufacturerRepository
     */
    protected static function getManufacturerRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ManufacturerRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\ManufacturerRepository(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\ProductRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\ProductRepository
     */
    protected static function getProductRepository2Service($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\ProductRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\ProductRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\StateRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\StateRepository
     */
    protected static function getStateRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\StateRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\StateRepository(($container->services['psxmarketingwithgoogle.db'] ?? self::getPsxmarketingwithgoogle_DbService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\TabRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TabRepository
     */
    protected static function getTabRepository2Service($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TabRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TabRepository();
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\TaxRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TaxRepository
     */
    protected static function getTaxRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\TaxRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\TaxRepository(($container->services['psxmarketingwithgoogle.db'] ?? self::getPsxmarketingwithgoogle_DbService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Repository\VerificationTagRepository' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Repository\VerificationTagRepository
     */
    protected static function getVerificationTagRepositoryService($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Repository\\VerificationTagRepository'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Repository\VerificationTagRepository(($container->services['psxmarketingwithgoogle.db'] ?? self::getPsxmarketingwithgoogle_DbService($container)), ($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\Module\PsxMarketingWithGoogle\Tracker\Segment' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Tracker\Segment
     */
    protected static function getSegment2Service($container)
    {
        return $container->services['PrestaShop\\Module\\PsxMarketingWithGoogle\\Tracker\\Segment'] = new \PrestaShop\Module\PsxMarketingWithGoogle\Tracker\Segment(($container->services['psxmarketingwithgoogle.context'] ?? self::getPsxmarketingwithgoogle_ContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Bundle\AssetsInstaller' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Bundle\AssetsInstaller
     */
    protected static function getAssetsInstallerService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Bundle\\AssetsInstaller'] = new \PrestaShop\PrestaShop\Adapter\Bundle\AssetsInstaller();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Configuration' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Configuration
     */
    protected static function getConfigurationService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Configuration'] = new \PrestaShop\PrestaShop\Adapter\Configuration();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\ContextStateManager' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\ContextStateManager
     */
    protected static function getContextStateManagerService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\ContextStateManager'] = new \PrestaShop\PrestaShop\Adapter\ContextStateManager(($container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] ?? self::getLegacyContextService($container)));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Currency\CurrencyDataProvider' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Currency\CurrencyDataProvider
     */
    protected static function getCurrencyDataProviderService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider'] = new \PrestaShop\PrestaShop\Adapter\Currency\CurrencyDataProvider(($container->services['PrestaShop\\PrestaShop\\Adapter\\Configuration'] ??= new \PrestaShop\PrestaShop\Adapter\Configuration()), ((($container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] ?? self::getLegacyContextService($container))->getContext()->shop) ? (($container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] ?? self::getLegacyContextService($container))->getContext()->shop->id) : (null)));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Employee\EmployeeRepository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Employee\EmployeeRepository
     */
    protected static function getEmployeeRepositoryService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Employee\\EmployeeRepository'] = new \PrestaShop\PrestaShop\Adapter\Employee\EmployeeRepository();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\LegacyContext' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\LegacyContext
     */
    protected static function getLegacyContextService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] = new \PrestaShop\PrestaShop\Adapter\LegacyContext('/mails/themes', ($container->services['PrestaShop\\PrestaShop\\Adapter\\Tools'] ??= new \PrestaShop\PrestaShop\Adapter\Tools()));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Adapter\Tools' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Tools
     */
    protected static function getToolsService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Adapter\\Tools'] = new \PrestaShop\PrestaShop\Adapter\Tools();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\Crypto\Hashing' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Crypto\Hashing
     */
    protected static function getHashingService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Core\\Crypto\\Hashing'] = new \PrestaShop\PrestaShop\Core\Crypto\Hashing();
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\FeatureFlag\FeatureFlagStateCheckerInterface' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\FeatureFlagManager
     */
    protected static function getFeatureFlagStateCheckerInterfaceService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\FeatureFlagStateCheckerInterface'] = $container->createProxy('FeatureFlagManagerGhost61268b3', static fn () => \FeatureFlagManagerGhost61268b3::createLazyGhost(static fn ($proxy) => self::getFeatureFlagStateCheckerInterfaceService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->privates['.service_locator.lWqUA3s'] ?? self::get_ServiceLocator_LWqUA3sService($container)), ($container->privates['PrestaShopBundle\\Entity\\Repository\\FeatureFlagRepository'] ?? self::getFeatureFlagRepositoryService($container))) && false ?: $lazyLoad);
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\Hook\HookModuleFilter' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Hook\HookModuleFilter
     */
    protected static function getHookModuleFilterService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Core\\Hook\\HookModuleFilter'] = new \PrestaShop\PrestaShop\Core\Hook\HookModuleFilter(new RewindableGenerator(fn () => new \EmptyIterator(), 0));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleRepository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleRepository
     */
    protected static function getLocaleRepositoryService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository'] = new \PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleRepository(($container->services['prestashop.core.localization.cldr.locale_data_source'] ?? self::getPrestashop_Core_Localization_Cldr_LocaleDataSourceService($container)));
    }

    /**
     * Gets the public 'PrestaShop\PrestaShop\Core\Localization\Locale\Repository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Locale\Repository
     */
    protected static function getRepositoryService($container)
    {
        return $container->services['PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository'] = new \PrestaShop\PrestaShop\Core\Localization\Locale\Repository(($container->services['PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository'] ?? self::getLocaleRepositoryService($container)), ($container->services['prestashop.core.localization.currency.repository'] ?? self::getPrestashop_Core_Localization_Currency_RepositoryService($container)));
    }

    /**
     * Gets the public 'PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts' shared service.
     *
     * @return \PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts
     */
    protected static function getPsAccountsService($container)
    {
        return $container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] = new \PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts(($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Installer'] ??= new \PrestaShop\PsAccountsInstaller\Installer\Installer('3.0.0')));
    }

    /**
     * Gets the public 'PrestaShop\PsAccountsInstaller\Installer\Installer' shared service.
     *
     * @return \PrestaShop\PsAccountsInstaller\Installer\Installer
     */
    protected static function getInstallerService($container)
    {
        return $container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Installer'] = new \PrestaShop\PsAccountsInstaller\Installer\Installer('3.0.0');
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\CheckoutHttpClient' shared service.
     *
     * @return \PsCheckout\Api\Http\CheckoutHttpClient
     */
    protected static function getCheckoutHttpClientService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\CheckoutHttpClient'] = new \PsCheckout\Api\Http\CheckoutHttpClient(($container->services['PsCheckout\\Api\\Http\\Configuration\\CheckoutClientConfigurationBuilder'] ?? self::getCheckoutClientConfigurationBuilderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\Configuration\CheckoutClientConfigurationBuilder' shared service.
     *
     * @return \PsCheckout\Api\Http\Configuration\CheckoutClientConfigurationBuilder
     */
    protected static function getCheckoutClientConfigurationBuilderService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\Configuration\\CheckoutClientConfigurationBuilder'] = new \PsCheckout\Api\Http\Configuration\CheckoutClientConfigurationBuilder(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->version, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnv3Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\Configuration\OrderHttpClientConfigurationBuilder' shared service.
     *
     * @return \PsCheckout\Api\Http\Configuration\OrderHttpClientConfigurationBuilder
     */
    protected static function getOrderHttpClientConfigurationBuilderService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\Configuration\\OrderHttpClientConfigurationBuilder'] = new \PsCheckout\Api\Http\Configuration\OrderHttpClientConfigurationBuilder(($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnv3Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->version);
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\Configuration\OrderShipmentTrackingConfigurationBuilder' shared service.
     *
     * @return \PsCheckout\Api\Http\Configuration\OrderShipmentTrackingConfigurationBuilder
     */
    protected static function getOrderShipmentTrackingConfigurationBuilderService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\Configuration\\OrderShipmentTrackingConfigurationBuilder'] = new \PsCheckout\Api\Http\Configuration\OrderShipmentTrackingConfigurationBuilder(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->version, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnv3Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\OrderHttpClient' shared service.
     *
     * @return \PsCheckout\Api\Http\OrderHttpClient
     */
    protected static function getOrderHttpClientService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] = new \PsCheckout\Api\Http\OrderHttpClient(($container->services['PsCheckout\\Api\\Http\\Configuration\\OrderHttpClientConfigurationBuilder'] ?? self::getOrderHttpClientConfigurationBuilderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Api\Http\OrderShipmentTrackingHttpClient' shared service.
     *
     * @return \PsCheckout\Api\Http\OrderShipmentTrackingHttpClient
     */
    protected static function getOrderShipmentTrackingHttpClientService($container)
    {
        return $container->services['PsCheckout\\Api\\Http\\OrderShipmentTrackingHttpClient'] = new \PsCheckout\Api\Http\OrderShipmentTrackingHttpClient(($container->services['PsCheckout\\Api\\Http\\Configuration\\OrderShipmentTrackingConfigurationBuilder'] ?? self::getOrderShipmentTrackingConfigurationBuilderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Cache\Array\PayPalOrder' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\ArrayAdapter
     */
    protected static function getPayPalOrderService($container)
    {
        return $container->services['PsCheckout\\Cache\\Array\\PayPalOrder'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
    }

    /**
     * Gets the public 'PsCheckout\Cache\Array\ShippingTracking' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\ArrayAdapter
     */
    protected static function getShippingTrackingService($container)
    {
        return $container->services['PsCheckout\\Cache\\Array\\ShippingTracking'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
    }

    /**
     * Gets the public 'PsCheckout\Cache\FileSystem\PayPalOrder' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getPayPalOrder2Service($container)
    {
        return $container->services['PsCheckout\\Cache\\FileSystem\\PayPalOrder'] = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('paypal-orders', 3600, ($container->services['PrestaShop\\ModuleLibCacheDirectoryProvider\\Cache\\CacheDirectoryProvider'] ??= new \PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider('9.0.2', '/home/fletcher/public_html/fletchermall.com', false))->getPath());
    }

    /**
     * Gets the public 'PsCheckout\Cache\FileSystem\ShippingTracking' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getShippingTracking2Service($container)
    {
        return $container->services['PsCheckout\\Cache\\FileSystem\\ShippingTracking'] = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('shipping-tracking', 3600, ($container->services['PrestaShop\\ModuleLibCacheDirectoryProvider\\Cache\\CacheDirectoryProvider'] ??= new \PrestaShop\ModuleLibCacheDirectoryProvider\Cache\CacheDirectoryProvider('9.0.2', '/home/fletcher/public_html/fletchermall.com', false))->getPath());
    }

    /**
     * Gets the public 'PsCheckout\Core\Customer\Action\ExpressCheckoutAction' shared service.
     *
     * @return \PsCheckout\Core\Customer\Action\ExpressCheckoutAction
     */
    protected static function getExpressCheckoutActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Customer\\Action\\ExpressCheckoutAction'] = new \PsCheckout\Core\Customer\Action\ExpressCheckoutAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Action\\CustomerAuthenticationAction'] ?? self::getCustomerAuthenticationActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Action\\CreateOrUpdateAddressAction'] ?? self::getCreateOrUpdateAddressActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\FundingSource\Factory\FundingSourceTokenFactory' shared service.
     *
     * @return \PsCheckout\Core\FundingSource\Factory\FundingSourceTokenFactory
     */
    protected static function getFundingSourceTokenFactoryService($container)
    {
        return $container->services['PsCheckout\\Core\\FundingSource\\Factory\\FundingSourceTokenFactory'] = new \PsCheckout\Core\FundingSource\Factory\FundingSourceTokenFactory(($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\LogoPresenter'] ?? self::getLogoPresenterService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\ChangeOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\ChangeOrderStateAction
     */
    protected static function getChangeOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\ChangeOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderStateRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderStateRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderHistoryRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderHistoryRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetCompletedOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetCompletedOrderStateAction
     */
    protected static function getSetCompletedOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetCompletedOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetCompletedOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Core\\Order\\Validator\\OrderAmountValidator'] ??= new \PsCheckout\Core\Order\Validator\OrderAmountValidator()), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetDeclinedOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetDeclinedOrderStateAction
     */
    protected static function getSetDeclinedOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetDeclinedOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetDeclinedOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetPendingOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetPendingOrderStateAction
     */
    protected static function getSetPendingOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetPendingOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetPendingOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetRefundedOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetRefundedOrderStateAction
     */
    protected static function getSetRefundedOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetRefundedOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetRefundedOrderStateAction(($container->services['PsCheckout\\Core\\PayPal\\Refund\\Provider\\PayPalRefundOrderProvider'] ?? self::getPayPalRefundOrderProviderService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Action\SetReversedOrderStateAction' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Action\SetReversedOrderStateAction
     */
    protected static function getSetReversedOrderStateActionService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Action\\SetReversedOrderStateAction'] = new \PsCheckout\Core\OrderState\Action\SetReversedOrderStateAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\ChangeOrderStateAction'] ?? self::getChangeOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\OrderState\Service\OrderStateMapper' shared service.
     *
     * @return \PsCheckout\Core\OrderState\Service\OrderStateMapper
     */
    protected static function getOrderStateMapperService($container)
    {
        return $container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] = new \PsCheckout\Core\OrderState\Service\OrderStateMapper(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Action\CreateOrderAction' shared service.
     *
     * @return \PsCheckout\Core\Order\Action\CreateOrderAction
     */
    protected static function getCreateOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderAction'] = new \PsCheckout\Core\Order\Action\CreateOrderAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Core\\Order\\Action\\CreateValidateOrderDataAction'] ?? self::getCreateValidateOrderDataActionService($container)), ($container->services['PsCheckout\\Core\\Order\\Action\\ValidateOrderAction'] ?? self::getValidateOrderActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderMatrixRepository'] ?? self::getPayPalOrderMatrixRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Action\CreateOrderPaymentAction' shared service.
     *
     * @return \PsCheckout\Core\Order\Action\CreateOrderPaymentAction
     */
    protected static function getCreateOrderPaymentActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderPaymentAction'] = new \PsCheckout\Core\Order\Action\CreateOrderPaymentAction(($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Currency'] ??= new \PsCheckout\Infrastructure\Adapter\Currency()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Action\CreateValidateOrderDataAction' shared service.
     *
     * @return \PsCheckout\Core\Order\Action\CreateValidateOrderDataAction
     */
    protected static function getCreateValidateOrderDataActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Action\\CreateValidateOrderDataAction'] = new \PsCheckout\Core\Order\Action\CreateValidateOrderDataAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Core\\OrderState\\Service\\OrderStateMapper'] ?? self::getOrderStateMapperService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\CurrencyRepository'] ?? self::getCurrencyRepository2Service($container)), ($container->services['PsCheckout\\Core\\Order\\Validator\\OrderAmountValidator'] ??= new \PsCheckout\Core\Order\Validator\OrderAmountValidator()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Action\ValidateOrderAction' shared service.
     *
     * @return \PsCheckout\Core\Order\Action\ValidateOrderAction
     */
    protected static function getValidateOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Action\\ValidateOrderAction'] = new \PsCheckout\Core\Order\Action\ValidateOrderAction(($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\AmountBreakdownNode' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\AmountBreakdownNode
     */
    protected static function getAmountBreakdownNodeService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\AmountBreakdownNode'] = new \PsCheckout\Core\Order\Builder\Node\AmountBreakdownNode();
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\ApplicationContextNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\ApplicationContextNodeBuilder
     */
    protected static function getApplicationContextNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\ApplicationContextNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\ApplicationContextNodeBuilder(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\BaseNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\BaseNodeBuilder
     */
    protected static function getBaseNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\BaseNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\BaseNodeBuilder(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\CardPaymentSourceNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\CardPaymentSourceNodeBuilder
     */
    protected static function getCardPaymentSourceNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\CardPaymentSourceNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\CardPaymentSourceNodeBuilder(($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] ?? self::getPayPalConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepository2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] ??= new \PsCheckout\Infrastructure\Repository\StateRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\GooglePayPaymentSourceNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\GooglePayPaymentSourceNodeBuilder
     */
    protected static function getGooglePayPaymentSourceNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\GooglePayPaymentSourceNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\GooglePayPaymentSourceNodeBuilder(($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] ?? self::getPayPalConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\PayPalPaymentSourceNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\PayPalPaymentSourceNodeBuilder
     */
    protected static function getPayPalPaymentSourceNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\PayPalPaymentSourceNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\PayPalPaymentSourceNodeBuilder();
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\PayerNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\PayerNodeBuilder
     */
    protected static function getPayerNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\PayerNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\PayerNodeBuilder(($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Validate'] ??= new \PsCheckout\Infrastructure\Adapter\Validate()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepository2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] ??= new \PsCheckout\Infrastructure\Repository\StateRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\ShippingNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\ShippingNodeBuilder
     */
    protected static function getShippingNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\ShippingNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\ShippingNodeBuilder(($container->services['PsCheckout\\Infrastructure\\Repository\\GenderRepository'] ??= new \PsCheckout\Infrastructure\Repository\GenderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepository2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] ??= new \PsCheckout\Infrastructure\Repository\StateRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\Node\SupplementaryDataNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\Node\SupplementaryDataNodeBuilder
     */
    protected static function getSupplementaryDataNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\Node\\SupplementaryDataNodeBuilder'] = new \PsCheckout\Core\Order\Builder\Node\SupplementaryDataNodeBuilder(($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepository2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] ??= new \PsCheckout\Infrastructure\Repository\StateRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Builder\OrderPayloadBuilder' shared service.
     *
     * @return \PsCheckout\Core\Order\Builder\OrderPayloadBuilder
     */
    protected static function getOrderPayloadBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] = new \PsCheckout\Core\Order\Builder\OrderPayloadBuilder(($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\BaseNodeBuilder'] ?? self::getBaseNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\AmountBreakdownNode'] ??= new \PsCheckout\Core\Order\Builder\Node\AmountBreakdownNode()), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\ShippingNodeBuilder'] ?? self::getShippingNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\PayerNodeBuilder'] ?? self::getPayerNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\CardPaymentSourceNodeBuilder'] ?? self::getCardPaymentSourceNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\SupplementaryDataNodeBuilder'] ?? self::getSupplementaryDataNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\ApplicationContextNodeBuilder'] ?? self::getApplicationContextNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\PayPalPaymentSourceNodeBuilder'] ??= new \PsCheckout\Core\Order\Builder\Node\PayPalPaymentSourceNodeBuilder()), ($container->services['PsCheckout\\Core\\Order\\Builder\\Node\\GooglePayPaymentSourceNodeBuilder'] ?? self::getGooglePayPaymentSourceNodeBuilderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Exception\Handler\OrderCreationExceptionHandler' shared service.
     *
     * @return \PsCheckout\Core\Order\Exception\Handler\OrderCreationExceptionHandler
     */
    protected static function getOrderCreationExceptionHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Exception\\Handler\\OrderCreationExceptionHandler'] = new \PsCheckout\Core\Order\Exception\Handler\OrderCreationExceptionHandler(($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Infrastructure\\Action\\CustomerNotifyAction'] ?? self::getCustomerNotifyActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Processor\CreateOrderProcessor' shared service.
     *
     * @return \PsCheckout\Core\Order\Processor\CreateOrderProcessor
     */
    protected static function getCreateOrderProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Processor\\CreateOrderProcessor'] = new \PsCheckout\Core\Order\Processor\CreateOrderProcessor(($container->services['PsCheckout\\Core\\Order\\Validator\\OrderAuthorizationValidator'] ?? self::getOrderAuthorizationValidatorService($container)), ($container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderAction'] ?? self::getCreateOrderActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\CartRepository'] ??= new \PsCheckout\Infrastructure\Repository\CartRepository()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Core\\Order\\Validator\\CheckoutValidator'] ?? self::getCheckoutValidatorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CapturePayPalOrderAction'] ?? self::getCapturePayPalOrderActionService($container)), ($container->services['PsCheckout\\Core\\PaymentToken\\Action\\SavePaymentTokenAction'] ?? self::getSavePaymentTokenActionService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PaymentToken\\Action\\DeletePaymentTokenAction'] ?? self::getDeletePaymentTokenActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Validator\CheckoutValidator' shared service.
     *
     * @return \PsCheckout\Core\Order\Validator\CheckoutValidator
     */
    protected static function getCheckoutValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Validator\\CheckoutValidator'] = new \PsCheckout\Core\Order\Validator\CheckoutValidator(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CartRepository'] ??= new \PsCheckout\Infrastructure\Repository\CartRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Validator\OrderAmountValidator' shared service.
     *
     * @return \PsCheckout\Core\Order\Validator\OrderAmountValidator
     */
    protected static function getOrderAmountValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Validator\\OrderAmountValidator'] = new \PsCheckout\Core\Order\Validator\OrderAmountValidator();
    }

    /**
     * Gets the public 'PsCheckout\Core\Order\Validator\OrderAuthorizationValidator' shared service.
     *
     * @return \PsCheckout\Core\Order\Validator\OrderAuthorizationValidator
     */
    protected static function getOrderAuthorizationValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\Order\\Validator\\OrderAuthorizationValidator'] = new \PsCheckout\Core\Order\Validator\OrderAuthorizationValidator(($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Customer'] ??= new \PsCheckout\Infrastructure\Adapter\Customer()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Cart'] ??= new \PsCheckout\Infrastructure\Adapter\Cart()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator'] ??= new \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ApplePay\Builder\ApplePayPaymentRequestDataBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ApplePay\Builder\ApplePayPaymentRequestDataBuilder
     */
    protected static function getApplePayPaymentRequestDataBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ApplePay\\Builder\\ApplePayPaymentRequestDataBuilder'] = new \PsCheckout\Core\PayPal\ApplePay\Builder\ApplePayPaymentRequestDataBuilder(($container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] ?? self::getOrderPayloadBuilderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] ?? self::getCartPresenterService($container)), ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator
     */
    protected static function getCard3DSecureValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator'] = new \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator();
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\GooglePay\Builder\GooglePayPaymentRequestDataBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\GooglePay\Builder\GooglePayPaymentRequestDataBuilder
     */
    protected static function getGooglePayPaymentRequestDataBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\GooglePay\\Builder\\GooglePayPaymentRequestDataBuilder'] = new \PsCheckout\Core\PayPal\GooglePay\Builder\GooglePayPaymentRequestDataBuilder(($container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] ?? self::getOrderPayloadBuilderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] ?? self::getCartPresenterService($container)), ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\OAuth\OAuthService' shared service.
     *
     * @return \PsCheckout\Core\PayPal\OAuth\OAuthService
     */
    protected static function getOAuthServiceService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\OAuth\\OAuthService'] = new \PsCheckout\Core\PayPal\OAuth\OAuthService(($container->services['PsCheckout\\Api\\Http\\CheckoutHttpClient'] ?? self::getCheckoutHttpClientService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction
     */
    protected static function getPayPalCheckOrderStatusActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] = new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction();
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\CancelPayPalOrderAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\CancelPayPalOrderAction
     */
    protected static function getCancelPayPalOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CancelPayPalOrderAction'] = new \PsCheckout\Core\PayPal\Order\Action\CancelPayPalOrderAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\CapturePayPalOrderAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\CapturePayPalOrderAction
     */
    protected static function getCapturePayPalOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CapturePayPalOrderAction'] = new \PsCheckout\Core\PayPal\Order\Action\CapturePayPalOrderAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderCompletedEventHandler'] ?? self::getOrderCompletedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentPendingEventHandler'] ?? self::getPaymentPendingEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentCompletedEventHandler'] ?? self::getPaymentCompletedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentDeniedEventHandler'] ?? self::getPaymentDeniedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\CreatePayPalOrderAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\CreatePayPalOrderAction
     */
    protected static function getCreatePayPalOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CreatePayPalOrderAction'] = new \PsCheckout\Core\PayPal\Order\Action\CreatePayPalOrderAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] ?? self::getPayPalCustomerRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] ?? self::getOrderPayloadBuilderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] ?? self::getCartPresenterService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Processor\\CreatePayPalOrderProcessor'] ?? self::getCreatePayPalOrderProcessorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Core\\PaymentToken\\Action\\DeletePaymentTokenAction'] ?? self::getDeletePaymentTokenActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\RefundPayPalOrderAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\RefundPayPalOrderAction
     */
    protected static function getRefundPayPalOrderActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\RefundPayPalOrderAction'] = new \PsCheckout\Core\PayPal\Order\Action\RefundPayPalOrderAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\SetRefundedOrderStateAction'] ?? self::getSetRefundedOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Action\UpdatePayPalOrderPurchaseUnitAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Action\UpdatePayPalOrderPurchaseUnitAction
     */
    protected static function getUpdatePayPalOrderPurchaseUnitActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction'] = new \PsCheckout\Core\PayPal\Order\Action\UpdatePayPalOrderPurchaseUnitAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderPurchaseUnitRepository'] ?? self::getPayPalOrderPurchaseUnitRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository'] ?? self::getPayPalOrderCaptureRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderAuthorizationRepository'] ?? self::getPayPalOrderAuthorizationRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRefundRepository'] ?? self::getPayPalOrderRefundRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Cache\PayPalOrderCache' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Cache\PayPalOrderCache
     */
    protected static function getPayPalOrderCacheService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] = new \PsCheckout\Core\PayPal\Order\Cache\PayPalOrderCache(($container->services['PsCheckout\\Cache\\Array\\PayPalOrder'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()), ($container->services['PsCheckout\\Cache\\FileSystem\\PayPalOrder'] ?? self::getPayPalOrder2Service($container)), ($container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] ??= new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\OrderApprovalReversedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\OrderApprovalReversedEventHandler
     */
    protected static function getOrderApprovalReversedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovalReversedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\OrderApprovalReversedEventHandler(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] ??= new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\OrderApprovedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\OrderApprovedEventHandler
     */
    protected static function getOrderApprovedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\OrderApprovedEventHandler(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] ??= new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction()), ($container->services['PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator'] ??= new \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator()), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\CapturePayPalOrderAction'] ?? self::getCapturePayPalOrderActionService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction'] ?? self::getUpdatePayPalOrderPurchaseUnitActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\OrderCompletedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\OrderCompletedEventHandler
     */
    protected static function getOrderCompletedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderCompletedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\OrderCompletedEventHandler(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\OrderStatus\\Action\\PayPalCheckOrderStatusAction'] ??= new \PsCheckout\Core\PayPal\OrderStatus\Action\PayPalCheckOrderStatusAction()), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction'] ?? self::getUpdatePayPalOrderPurchaseUnitActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Core\\PayPal\\Card3DSecure\\Card3DSecureValidator'] ??= new \PsCheckout\Core\PayPal\Card3DSecure\Card3DSecureValidator()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PayPalEventDispatcher' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PayPalEventDispatcher
     */
    protected static function getPayPalEventDispatcherService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PayPalEventDispatcher'] = new \PsCheckout\Core\PayPal\Order\Handler\PayPalEventDispatcher(($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentCompletedEventHandler'] ?? self::getPaymentCompletedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentPendingEventHandler'] ?? self::getPaymentPendingEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentDeniedEventHandler'] ?? self::getPaymentDeniedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentRefundedEventHandler'] ?? self::getPaymentRefundedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentReversedEventHandler'] ?? self::getPaymentReversedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovedEventHandler'] ?? self::getOrderApprovedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderCompletedEventHandler'] ?? self::getOrderCompletedEventHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\OrderApprovalReversedEventHandler'] ?? self::getOrderApprovalReversedEventHandlerService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentCompletedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentCompletedEventHandler
     */
    protected static function getPaymentCompletedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentCompletedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentCompletedEventHandler(($container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderAction'] ?? self::getCreateOrderActionService($container)), ($container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderPaymentAction'] ?? self::getCreateOrderPaymentActionService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\SetCompletedOrderStateAction'] ?? self::getSetCompletedOrderStateActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentDeniedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentDeniedEventHandler
     */
    protected static function getPaymentDeniedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentDeniedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentDeniedEventHandler(($container->services['PsCheckout\\Core\\OrderState\\Action\\SetDeclinedOrderStateAction'] ?? self::getSetDeclinedOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentPendingEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentPendingEventHandler
     */
    protected static function getPaymentPendingEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentPendingEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentPendingEventHandler(($container->services['PsCheckout\\Core\\Order\\Action\\CreateOrderAction'] ?? self::getCreateOrderActionService($container)), ($container->services['PsCheckout\\Core\\OrderState\\Action\\SetPendingOrderStateAction'] ?? self::getSetPendingOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentRefundedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentRefundedEventHandler
     */
    protected static function getPaymentRefundedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentRefundedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentRefundedEventHandler(($container->services['PsCheckout\\Core\\OrderState\\Action\\SetRefundedOrderStateAction'] ?? self::getSetRefundedOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Handler\PaymentReversedEventHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Handler\PaymentReversedEventHandler
     */
    protected static function getPaymentReversedEventHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PaymentReversedEventHandler'] = new \PsCheckout\Core\PayPal\Order\Handler\PaymentReversedEventHandler(($container->services['PsCheckout\\Core\\OrderState\\Action\\SetReversedOrderStateAction'] ?? self::getSetReversedOrderStateActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Processor\CreatePayPalOrderProcessor' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Processor\CreatePayPalOrderProcessor
     */
    protected static function getCreatePayPalOrderProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Processor\\CreatePayPalOrderProcessor'] = new \PsCheckout\Core\PayPal\Order\Processor\CreatePayPalOrderProcessor(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] ?? self::getPayPalCustomerRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderPurchaseUnitRepository'] ?? self::getPayPalOrderPurchaseUnitRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository'] ?? self::getPayPalOrderCaptureRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderAuthorizationRepository'] ?? self::getPayPalOrderAuthorizationRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRefundRepository'] ?? self::getPayPalOrderRefundRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Processor\UpdateExternalPayPalOrderProcessor' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Processor\UpdateExternalPayPalOrderProcessor
     */
    protected static function getUpdateExternalPayPalOrderProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Processor\\UpdateExternalPayPalOrderProcessor'] = new \PsCheckout\Core\PayPal\Order\Processor\UpdateExternalPayPalOrderProcessor(($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] ?? self::getCartPresenterService($container)), ($container->services['PsCheckout\\Core\\Order\\Builder\\OrderPayloadBuilder'] ?? self::getOrderPayloadBuilderService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Action\\UpdatePayPalOrderPurchaseUnitAction'] ?? self::getUpdatePayPalOrderPurchaseUnitActionService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Provider\PayPalOrderProvider' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Provider\PayPalOrderProvider
     */
    protected static function getPayPalOrderProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] = new \PsCheckout\Core\PayPal\Order\Provider\PayPalOrderProvider(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Provider\PayPalOrderTranslationProvider' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Provider\PayPalOrderTranslationProvider
     */
    protected static function getPayPalOrderTranslationProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderTranslationProvider'] = new \PsCheckout\Core\PayPal\Order\Provider\PayPalOrderTranslationProvider(($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Order\Validator\CreatedPayPalOrderValidator' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Order\Validator\CreatedPayPalOrderValidator
     */
    protected static function getCreatedPayPalOrderValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Order\\Validator\\CreatedPayPalOrderValidator'] = new \PsCheckout\Core\PayPal\Order\Validator\CreatedPayPalOrderValidator(($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Cart'] ??= new \PsCheckout\Infrastructure\Adapter\Cart()), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->id);
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\Refund\Provider\PayPalRefundOrderProvider' shared service.
     *
     * @return \PsCheckout\Core\PayPal\Refund\Provider\PayPalRefundOrderProvider
     */
    protected static function getPayPalRefundOrderProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\Refund\\Provider\\PayPalRefundOrderProvider'] = new \PsCheckout\Core\PayPal\Refund\Provider\PayPalRefundOrderProvider(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction
     */
    protected static function getAddTrackingActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingAction'] = new \PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessor'] ?? self::getShipmentProcessorService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingActionInterface' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction
     */
    protected static function getAddTrackingActionInterfaceService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingActionInterface'] = new \PsCheckout\Core\PayPal\ShippingTracking\Action\AddTrackingAction(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessorInterface'] ?? self::getShipmentProcessorInterfaceService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Action\ProcessExternalShipmentAction' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Action\ProcessExternalShipmentAction
     */
    protected static function getProcessExternalShipmentActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\ProcessExternalShipmentAction'] = new \PsCheckout\Core\PayPal\ShippingTracking\Action\ProcessExternalShipmentAction(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ExternalShipmentProcessor'] ?? self::getExternalShipmentProcessorService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingBaseNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingBaseNodeBuilder
     */
    protected static function getTrackingBaseNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingBaseNodeBuilder'] = new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingBaseNodeBuilder();
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingCarrierModuleNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingCarrierModuleNodeBuilder
     */
    protected static function getTrackingCarrierModuleNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingCarrierModuleNodeBuilder'] = new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingCarrierModuleNodeBuilder();
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingItemsNodeBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingItemsNodeBuilder
     */
    protected static function getTrackingItemsNodeBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingItemsNodeBuilder'] = new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingItemsNodeBuilder(($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Builder\TrackingPayloadBuilder' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Builder\TrackingPayloadBuilder
     */
    protected static function getTrackingPayloadBuilderService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder'] = new \PsCheckout\Core\PayPal\ShippingTracking\Builder\TrackingPayloadBuilder(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingBaseNodeBuilder'] ??= new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingBaseNodeBuilder()), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingItemsNodeBuilder'] ?? self::getTrackingItemsNodeBuilderService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\Node\\TrackingCarrierModuleNodeBuilder'] ??= new \PsCheckout\Core\PayPal\ShippingTracking\Builder\Node\TrackingCarrierModuleNodeBuilder()));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Cache\ShippingTrackingCache' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Cache\ShippingTrackingCache
     */
    protected static function getShippingTrackingCacheService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache'] = new \PsCheckout\Core\PayPal\ShippingTracking\Cache\ShippingTrackingCache(($container->services['PsCheckout\\Cache\\Array\\ShippingTracking'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()), ($container->services['PsCheckout\\Cache\\FileSystem\\ShippingTracking'] ?? self::getShippingTracking2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Processor\ExternalShipmentProcessor' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Processor\ExternalShipmentProcessor
     */
    protected static function getExternalShipmentProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ExternalShipmentProcessor'] = new \PsCheckout\Core\PayPal\ShippingTracking\Processor\ExternalShipmentProcessor(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator'] ?? self::getOrderTrackerValidatorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder'] ?? self::getTrackingPayloadBuilderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] ?? self::getShippingTrackingRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache'] ?? self::getShippingTrackingCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService'] ?? self::getTrackingApiServiceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler'] ?? self::getTrackingDatabaseHandlerService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Action\\AddTrackingActionInterface'] ?? self::getAddTrackingActionInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor
     */
    protected static function getShipmentProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessor'] = new \PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator'] ?? self::getOrderTrackerValidatorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder'] ?? self::getTrackingPayloadBuilderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] ?? self::getShippingTrackingRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache'] ?? self::getShippingTrackingCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService'] ?? self::getTrackingApiServiceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler'] ?? self::getTrackingDatabaseHandlerService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessorInterface' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor
     */
    protected static function getShipmentProcessorInterfaceService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Processor\\ShipmentProcessorInterface'] = new \PsCheckout\Core\PayPal\ShippingTracking\Processor\ShipmentProcessor(($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator'] ?? self::getOrderTrackerValidatorService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Builder\\TrackingPayloadBuilder'] ?? self::getTrackingPayloadBuilderService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] ?? self::getShippingTrackingRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Cache\\ShippingTrackingCache'] ?? self::getShippingTrackingCacheService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService'] ?? self::getTrackingApiServiceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler'] ?? self::getTrackingDatabaseHandlerService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingApiService' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingApiService
     */
    protected static function getTrackingApiServiceService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingApiService'] = new \PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingApiService(($container->services['PsCheckout\\Api\\Http\\OrderShipmentTrackingHttpClient'] ?? self::getOrderShipmentTrackingHttpClientService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingDatabaseHandler' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingDatabaseHandler
     */
    protected static function getTrackingDatabaseHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Service\\TrackingDatabaseHandler'] = new \PsCheckout\Core\PayPal\ShippingTracking\Service\TrackingDatabaseHandler(($container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] ?? self::getShippingTrackingRepositoryService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PayPal\ShippingTracking\Validator\OrderTrackerValidator' shared service.
     *
     * @return \PsCheckout\Core\PayPal\ShippingTracking\Validator\OrderTrackerValidator
     */
    protected static function getOrderTrackerValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\PayPal\\ShippingTracking\\Validator\\OrderTrackerValidator'] = new \PsCheckout\Core\PayPal\ShippingTracking\Validator\OrderTrackerValidator(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository'] ?? self::getPayPalOrderCaptureRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PaymentToken\Action\DeletePaymentTokenAction' shared service.
     *
     * @return \PsCheckout\Core\PaymentToken\Action\DeletePaymentTokenAction
     */
    protected static function getDeletePaymentTokenActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PaymentToken\\Action\\DeletePaymentTokenAction'] = new \PsCheckout\Core\PaymentToken\Action\DeletePaymentTokenAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)), ($container->services['PsCheckout\\Api\\Http\\CheckoutHttpClient'] ?? self::getCheckoutHttpClientService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\PaymentToken\Action\SavePaymentTokenAction' shared service.
     *
     * @return \PsCheckout\Core\PaymentToken\Action\SavePaymentTokenAction
     */
    protected static function getSavePaymentTokenActionService($container)
    {
        return $container->services['PsCheckout\\Core\\PaymentToken\\Action\\SavePaymentTokenAction'] = new \PsCheckout\Core\PaymentToken\Action\SavePaymentTokenAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] ?? self::getPayPalCustomerRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Settings\Configuration\PayPalConfiguration' shared service.
     *
     * @return \PsCheckout\Core\Settings\Configuration\PayPalConfiguration
     */
    protected static function getPayPalConfigurationService($container)
    {
        return $container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] = new \PsCheckout\Core\Settings\Configuration\PayPalConfiguration(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Settings\Configuration\PayPalSdkConfiguration' shared service.
     *
     * @return \PsCheckout\Core\Settings\Configuration\PayPalSdkConfiguration
     */
    protected static function getPayPalSdkConfigurationService($container)
    {
        return $container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalSdkConfiguration'] = new \PsCheckout\Core\Settings\Configuration\PayPalSdkConfiguration(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] ?? self::getPayPalConfigurationService($container)), ($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnv3Service($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter'] ?? self::getFundingSourcePresenterService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] ?? self::getPayPalCustomerRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\OAuth\\OAuthService'] ?? self::getOAuthServiceService($container)), ($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Action\CheckPSLSignatureAction' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Action\CheckPSLSignatureAction
     */
    protected static function getCheckPSLSignatureActionService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Action\\CheckPSLSignatureAction'] = new \PsCheckout\Core\WebhookDispatcher\Action\CheckPSLSignatureAction(($container->services['PsCheckout\\Api\\Http\\OrderHttpClient'] ?? self::getOrderHttpClientService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Processor\DispatchWebhookProcessor' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Processor\DispatchWebhookProcessor
     */
    protected static function getDispatchWebhookProcessorService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Processor\\DispatchWebhookProcessor'] = new \PsCheckout\Core\WebhookDispatcher\Processor\DispatchWebhookProcessor(($container->services['Psr\\Log\\LoggerInterface'] ?? self::getLoggerInterfaceService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Handler\\PayPalEventDispatcher'] ?? self::getPayPalEventDispatcherService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Cache\\PayPalOrderCache'] ?? self::getPayPalOrderCacheService($container)), ($container->services['PsCheckout\\Core\\PaymentToken\\Action\\SavePaymentTokenAction'] ?? self::getSavePaymentTokenActionService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Provider\WebhookBodyProvider' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Provider\WebhookBodyProvider
     */
    protected static function getWebhookBodyProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookBodyProvider'] = new \PsCheckout\Core\WebhookDispatcher\Provider\WebhookBodyProvider(($container->services['PsCheckout\\Utility\\Common\\InputStreamUtility'] ??= new \PsCheckout\Utility\Common\InputStreamUtility()));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Provider\WebhookHeaderProvider' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Provider\WebhookHeaderProvider
     */
    protected static function getWebhookHeaderProviderService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookHeaderProvider'] = new \PsCheckout\Core\WebhookDispatcher\Provider\WebhookHeaderProvider();
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Validator\BodyValuesValidator' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Validator\BodyValuesValidator
     */
    protected static function getBodyValuesValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Validator\\BodyValuesValidator'] = new \PsCheckout\Core\WebhookDispatcher\Validator\BodyValuesValidator(($container->services['PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookBodyProvider'] ?? self::getWebhookBodyProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Validator\HeaderValuesValidator' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Validator\HeaderValuesValidator
     */
    protected static function getHeaderValuesValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Validator\\HeaderValuesValidator'] = new \PsCheckout\Core\WebhookDispatcher\Validator\HeaderValuesValidator(($container->services['PsCheckout\\Core\\WebhookDispatcher\\Provider\\WebhookHeaderProvider'] ??= new \PsCheckout\Core\WebhookDispatcher\Provider\WebhookHeaderProvider()));
    }

    /**
     * Gets the public 'PsCheckout\Core\WebhookDispatcher\Validator\WebhookShopIdValidator' shared service.
     *
     * @return \PsCheckout\Core\WebhookDispatcher\Validator\WebhookShopIdValidator
     */
    protected static function getWebhookShopIdValidatorService($container)
    {
        return $container->services['PsCheckout\\Core\\WebhookDispatcher\\Validator\\WebhookShopIdValidator'] = new \PsCheckout\Core\WebhookDispatcher\Validator\WebhookShopIdValidator(($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Webhook\Handler\WebhookEventConfigurationUpdatedHandler' shared service.
     *
     * @return \PsCheckout\Core\Webhook\Handler\WebhookEventConfigurationUpdatedHandler
     */
    protected static function getWebhookEventConfigurationUpdatedHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\Webhook\\Handler\\WebhookEventConfigurationUpdatedHandler'] = new \PsCheckout\Core\Webhook\Handler\WebhookEventConfigurationUpdatedHandler(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Core\Webhook\Handler\WebhookHandler' shared service.
     *
     * @return \PsCheckout\Core\Webhook\Handler\WebhookHandler
     */
    protected static function getWebhookHandlerService($container)
    {
        return $container->services['PsCheckout\\Core\\Webhook\\Handler\\WebhookHandler'] = new \PsCheckout\Core\Webhook\Handler\WebhookHandler(($container->services['PsCheckout\\Core\\Webhook\\Service\\WebhookSecretToken'] ?? self::getWebhookSecretTokenService($container)), [($container->services['PsCheckout\\Core\\Webhook\\Handler\\WebhookEventConfigurationUpdatedHandler'] ?? self::getWebhookEventConfigurationUpdatedHandlerService($container))]);
    }

    /**
     * Gets the public 'PsCheckout\Core\Webhook\Service\WebhookSecretToken' shared service.
     *
     * @return \PsCheckout\Core\Webhook\Service\WebhookSecretToken
     */
    protected static function getWebhookSecretTokenService($container)
    {
        return $container->services['PsCheckout\\Core\\Webhook\\Service\\WebhookSecretToken'] = new \PsCheckout\Core\Webhook\Service\WebhookSecretToken(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Action\AddProductToCartAction' shared service.
     *
     * @return \PsCheckout\Infrastructure\Action\AddProductToCartAction
     */
    protected static function getAddProductToCartActionService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Action\\AddProductToCartAction'] = new \PsCheckout\Infrastructure\Action\AddProductToCartAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Action\CreateOrUpdateAddressAction' shared service.
     *
     * @return \PsCheckout\Infrastructure\Action\CreateOrUpdateAddressAction
     */
    protected static function getCreateOrUpdateAddressActionService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Action\\CreateOrUpdateAddressAction'] = new \PsCheckout\Infrastructure\Action\CreateOrUpdateAddressAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Country'] ??= new \PsCheckout\Infrastructure\Adapter\Country()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] ?? self::getCountryRepository2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\AddressRepository'] ?? self::getAddressRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Action\CustomerAuthenticationAction' shared service.
     *
     * @return \PsCheckout\Infrastructure\Action\CustomerAuthenticationAction
     */
    protected static function getCustomerAuthenticationActionService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Action\\CustomerAuthenticationAction'] = new \PsCheckout\Infrastructure\Action\CustomerAuthenticationAction(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Customer'] ??= new \PsCheckout\Infrastructure\Adapter\Customer()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Action\CustomerNotifyAction' shared service.
     *
     * @return \PsCheckout\Infrastructure\Action\CustomerNotifyAction
     */
    protected static function getCustomerNotifyActionService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Action\\CustomerNotifyAction'] = new \PsCheckout\Infrastructure\Action\CustomerNotifyAction(($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] ??= new \PsCheckout\Infrastructure\Repository\OrderRepository()), ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)), ($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Address' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Address
     */
    protected static function getAddressService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Address'] = new \PsCheckout\Infrastructure\Adapter\Address();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Cart' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Cart
     */
    protected static function getCartService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Cart'] = new \PsCheckout\Infrastructure\Adapter\Cart();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Configuration' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Configuration
     */
    protected static function getConfiguration2Service($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] = new \PsCheckout\Infrastructure\Adapter\Configuration(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Context' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Context
     */
    protected static function getContextService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] = new \PsCheckout\Infrastructure\Adapter\Context();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Country' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Country
     */
    protected static function getCountryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Country'] = new \PsCheckout\Infrastructure\Adapter\Country();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Currency' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Currency
     */
    protected static function getCurrencyService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Currency'] = new \PsCheckout\Infrastructure\Adapter\Currency();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Customer' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Customer
     */
    protected static function getCustomerService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Customer'] = new \PsCheckout\Infrastructure\Adapter\Customer();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Language' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Language
     */
    protected static function getLanguageService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Language'] = new \PsCheckout\Infrastructure\Adapter\Language();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Link' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Link
     */
    protected static function getLinkService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] = new \PsCheckout\Infrastructure\Adapter\Link(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name);
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\ShopContext' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\ShopContext
     */
    protected static function getShopContextService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\ShopContext'] = new \PsCheckout\Infrastructure\Adapter\ShopContext();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\SystemConfiguration' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\SystemConfiguration
     */
    protected static function getSystemConfigurationService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\SystemConfiguration'] = new \PsCheckout\Infrastructure\Adapter\SystemConfiguration();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Tools' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Tools
     */
    protected static function getTools2Service($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Tools'] = new \PsCheckout\Infrastructure\Adapter\Tools();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Adapter\Validate' shared service.
     *
     * @return \PsCheckout\Infrastructure\Adapter\Validate
     */
    protected static function getValidateService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Adapter\\Validate'] = new \PsCheckout\Infrastructure\Adapter\Validate();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Environment\Env' shared service.
     *
     * @return \PsCheckout\Infrastructure\Environment\Env
     */
    protected static function getEnv3Service($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Environment\\Env'] = new \PsCheckout\Infrastructure\Environment\Env(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Environment\EnvLoader' shared service.
     *
     * @return \PsCheckout\Infrastructure\Environment\EnvLoader
     */
    protected static function getEnvLoaderService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Environment\\EnvLoader'] = new \PsCheckout\Infrastructure\Environment\EnvLoader();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Logger\LoggerFactory' shared service.
     *
     * @return \PsCheckout\Infrastructure\Logger\LoggerFactory
     */
    protected static function getLoggerFactoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFactory'] = new \PsCheckout\Infrastructure\Logger\LoggerFactory(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['Monolog\\Handler\\HandlerInterface'] ?? self::getHandlerInterfaceService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Logger\LoggerFileFinder' shared service.
     *
     * @return \PsCheckout\Infrastructure\Logger\LoggerFileFinder
     */
    protected static function getLoggerFileFinderService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFileFinder'] = new \PsCheckout\Infrastructure\Logger\LoggerFileFinder(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Logger\LoggerFileReader' shared service.
     *
     * @return \PsCheckout\Infrastructure\Logger\LoggerFileReader
     */
    protected static function getLoggerFileReaderService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFileReader'] = new \PsCheckout\Infrastructure\Logger\LoggerFileReader(($container->services['PsCheckout\\Infrastructure\\Adapter\\Validate'] ??= new \PsCheckout\Infrastructure\Adapter\Validate()), ($container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFileFinder'] ?? self::getLoggerFileFinderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Logger\LoggerHandlerFactory' shared service.
     *
     * @return \PsCheckout\Infrastructure\Logger\LoggerHandlerFactory
     */
    protected static function getLoggerHandlerFactoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Logger\\LoggerHandlerFactory'] = new \PsCheckout\Infrastructure\Logger\LoggerHandlerFactory(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name);
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\AddressRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\AddressRepository
     */
    protected static function getAddressRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\AddressRepository'] = new \PsCheckout\Infrastructure\Repository\AddressRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\CartRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\CartRepository
     */
    protected static function getCartRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\CartRepository'] = new \PsCheckout\Infrastructure\Repository\CartRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\ConfigurationRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\ConfigurationRepository
     */
    protected static function getConfigurationRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\ConfigurationRepository'] = new \PsCheckout\Infrastructure\Repository\ConfigurationRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\CountryRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\CountryRepository
     */
    protected static function getCountryRepository2Service($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\CountryRepository'] = new \PsCheckout\Infrastructure\Repository\CountryRepository(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name);
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\CurrencyRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\CurrencyRepository
     */
    protected static function getCurrencyRepository2Service($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\CurrencyRepository'] = new \PsCheckout\Infrastructure\Repository\CurrencyRepository(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name);
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\CustomerRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\CustomerRepository
     */
    protected static function getCustomerRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\CustomerRepository'] = new \PsCheckout\Infrastructure\Repository\CustomerRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\FundingSourceRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\FundingSourceRepository
     */
    protected static function getFundingSourceRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\FundingSourceRepository'] = new \PsCheckout\Infrastructure\Repository\FundingSourceRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\GenderRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\GenderRepository
     */
    protected static function getGenderRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\GenderRepository'] = new \PsCheckout\Infrastructure\Repository\GenderRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\LanguageRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\LanguageRepository
     */
    protected static function getLanguageRepository2Service($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\LanguageRepository'] = new \PsCheckout\Infrastructure\Repository\LanguageRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\OrderHistoryRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\OrderHistoryRepository
     */
    protected static function getOrderHistoryRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\OrderHistoryRepository'] = new \PsCheckout\Infrastructure\Repository\OrderHistoryRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\OrderRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\OrderRepository
     */
    protected static function getOrderRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\OrderRepository'] = new \PsCheckout\Infrastructure\Repository\OrderRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\OrderStateRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\OrderStateRepository
     */
    protected static function getOrderStateRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\OrderStateRepository'] = new \PsCheckout\Infrastructure\Repository\OrderStateRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalCustomerRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalCustomerRepository
     */
    protected static function getPayPalCustomerRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalCustomerRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalCustomerRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderAuthorizationRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderAuthorizationRepository
     */
    protected static function getPayPalOrderAuthorizationRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderAuthorizationRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderAuthorizationRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderCaptureRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderCaptureRepository
     */
    protected static function getPayPalOrderCaptureRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderCaptureRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderCaptureRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderMatrixRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderMatrixRepository
     */
    protected static function getPayPalOrderMatrixRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderMatrixRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderMatrixRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderPurchaseUnitRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderPurchaseUnitRepository
     */
    protected static function getPayPalOrderPurchaseUnitRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderPurchaseUnitRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderPurchaseUnitRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderRefundRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderRefundRepository
     */
    protected static function getPayPalOrderRefundRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRefundRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderRefundRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PayPalOrderRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PayPalOrderRepository
     */
    protected static function getPayPalOrderRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] = new \PsCheckout\Infrastructure\Repository\PayPalOrderRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PaymentTokenRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PaymentTokenRepository
     */
    protected static function getPaymentTokenRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] = new \PsCheckout\Infrastructure\Repository\PaymentTokenRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\PsAccountRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\PsAccountRepository
     */
    protected static function getPsAccountRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] = new \PsCheckout\Infrastructure\Repository\PsAccountRepository(($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] ?? self::getPsAccountsService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\ShippingTrackingRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\ShippingTrackingRepository
     */
    protected static function getShippingTrackingRepositoryService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\ShippingTrackingRepository'] = new \PsCheckout\Infrastructure\Repository\ShippingTrackingRepository(($container->services['ps_checkout.db'] ?? self::getPsCheckout_DbService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Repository\StateRepository' shared service.
     *
     * @return \PsCheckout\Infrastructure\Repository\StateRepository
     */
    protected static function getStateRepository2Service($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Repository\\StateRepository'] = new \PsCheckout\Infrastructure\Repository\StateRepository();
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Validator\FrontControllerValidator' shared service.
     *
     * @return \PsCheckout\Infrastructure\Validator\FrontControllerValidator
     */
    protected static function getFrontControllerValidatorService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Validator\\FrontControllerValidator'] = new \PsCheckout\Infrastructure\Validator\FrontControllerValidator(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)));
    }

    /**
     * Gets the public 'PsCheckout\Infrastructure\Validator\MerchantValidator' shared service.
     *
     * @return \PsCheckout\Infrastructure\Validator\MerchantValidator
     */
    protected static function getMerchantValidatorService($container)
    {
        return $container->services['PsCheckout\\Infrastructure\\Validator\\MerchantValidator'] = new \PsCheckout\Infrastructure\Validator\MerchantValidator(($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PsAccountRepository'] ?? self::getPsAccountRepositoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Module\Presentation\Translator' shared service.
     *
     * @return \PsCheckout\Module\Presentation\Translator
     */
    protected static function getTranslatorService($container)
    {
        return $container->services['PsCheckout\\Module\\Presentation\\Translator'] = new \PsCheckout\Module\Presentation\Translator(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->getTranslator());
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Cart\CartPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Cart\CartPresenter
     */
    protected static function getCartPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Cart\\CartPresenter'] = new \PsCheckout\Presentation\Presenter\Cart\CartPresenter(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Address'] ??= new \PsCheckout\Infrastructure\Adapter\Address()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Currency'] ??= new \PsCheckout\Infrastructure\Adapter\Currency()), ($container->services['PsCheckout\\Infrastructure\\Repository\\LanguageRepository'] ??= new \PsCheckout\Infrastructure\Repository\LanguageRepository()), ($container->services['PsCheckout\\Infrastructure\\Repository\\CustomerRepository'] ??= new \PsCheckout\Infrastructure\Repository\CustomerRepository()));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\FundingSource\FundingSourcePresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\FundingSource\FundingSourcePresenter
     */
    protected static function getFundingSourcePresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter'] = new \PsCheckout\Presentation\Presenter\FundingSource\FundingSourcePresenter(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->getPathUri(), ($container->services['PsCheckout\\Infrastructure\\Repository\\FundingSourceRepository'] ?? self::getFundingSourceRepositoryService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTokenPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTokenPresenter
     */
    protected static function getFundingSourceTokenPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTokenPresenter'] = new \PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTokenPresenter(($container->services['PsCheckout\\Infrastructure\\Repository\\PaymentTokenRepository'] ?? self::getPaymentTokenRepositoryService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Core\\FundingSource\\Factory\\FundingSourceTokenFactory'] ?? self::getFundingSourceTokenFactoryService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTranslationProvider' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTranslationProvider
     */
    protected static function getFundingSourceTranslationProviderService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] = new \PsCheckout\Presentation\Presenter\FundingSource\FundingSourceTranslationProvider(($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\FundingSource\LogoPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\FundingSource\LogoPresenter
     */
    protected static function getLogoPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\LogoPresenter'] = new \PsCheckout\Presentation\Presenter\FundingSource\LogoPresenter(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->getPathUri());
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\OrderSummary\OrderSummaryPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\OrderSummary\OrderSummaryPresenter
     */
    protected static function getOrderSummaryPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\OrderSummary\\OrderSummaryPresenter'] = new \PsCheckout\Presentation\Presenter\OrderSummary\OrderSummaryPresenter(($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderProvider'] ?? self::getPayPalOrderProviderService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)), ($container->services['PsCheckout\\Core\\PayPal\\Order\\Provider\\PayPalOrderTranslationProvider'] ?? self::getPayPalOrderTranslationProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\FrontSettingsPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\FrontSettingsPresenter
     */
    protected static function getFrontSettingsPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\FrontSettingsPresenter'] = new \PsCheckout\Presentation\Presenter\Settings\Front\FrontSettingsPresenter([($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\PayPalModule'] ?? self::getPayPalModuleService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\ConfigurationModule'] ?? self::getConfigurationModuleService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\MediaModule'] ?? self::getMediaModuleService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\LinkModule'] ?? self::getLinkModuleService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\TranslationModule'] ?? self::getTranslationModuleService($container))]);
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\ConfigurationModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\ConfigurationModule
     */
    protected static function getConfigurationModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\ConfigurationModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\ConfigurationModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Configuration'] ?? self::getConfiguration2Service($container)), ($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalConfiguration'] ?? self::getPayPalConfigurationService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter'] ?? self::getFundingSourcePresenterService($container)), ($container->services['PsCheckout\\Core\\Settings\\Configuration\\PayPalSdkConfiguration'] ?? self::getPayPalSdkConfigurationService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\LinkModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\LinkModule
     */
    protected static function getLinkModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\LinkModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\LinkModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Link'] ?? self::getLinkService($container)), ($container->services['PsCheckout\\Infrastructure\\Adapter\\Tools'] ??= new \PsCheckout\Infrastructure\Adapter\Tools()));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\MediaModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\MediaModule
     */
    protected static function getMediaModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\MediaModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\MediaModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->getPathUri());
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\PayPalModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\PayPalModule
     */
    protected static function getPayPalModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\PayPalModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\PayPalModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->version, ($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()), ($container->services['PsCheckout\\Infrastructure\\Environment\\Env'] ?? self::getEnv3Service($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourcePresenter'] ?? self::getFundingSourcePresenterService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTokenPresenter'] ?? self::getFundingSourceTokenPresenterService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\SupportedCardBrandsPresenter'] ?? self::getSupportedCardBrandsPresenterService($container)), ($container->services['PsCheckout\\Infrastructure\\Repository\\PayPalOrderRepository'] ?? self::getPayPalOrderRepositoryService($container)), ($container->services['PsCheckout\\Presentation\\Presenter\\FundingSource\\FundingSourceTranslationProvider'] ?? self::getFundingSourceTranslationProviderService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\Modules\TranslationModule' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\Modules\TranslationModule
     */
    protected static function getTranslationModuleService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\Modules\\TranslationModule'] = new \PsCheckout\Presentation\Presenter\Settings\Front\Modules\TranslationModule(($container->services['ps_checkout.module'] ?? self::getPsCheckout_ModuleService($container))->name, ($container->services['PsCheckout\\Module\\Presentation\\Translator'] ?? self::getTranslatorService($container)));
    }

    /**
     * Gets the public 'PsCheckout\Presentation\Presenter\Settings\Front\SupportedCardBrandsPresenter' shared service.
     *
     * @return \PsCheckout\Presentation\Presenter\Settings\Front\SupportedCardBrandsPresenter
     */
    protected static function getSupportedCardBrandsPresenterService($container)
    {
        return $container->services['PsCheckout\\Presentation\\Presenter\\Settings\\Front\\SupportedCardBrandsPresenter'] = new \PsCheckout\Presentation\Presenter\Settings\Front\SupportedCardBrandsPresenter(($container->services['PsCheckout\\Infrastructure\\Adapter\\Context'] ??= new \PsCheckout\Infrastructure\Adapter\Context()));
    }

    /**
     * Gets the public 'PsCheckout\Utility\Common\InputStreamUtility' shared service.
     *
     * @return \PsCheckout\Utility\Common\InputStreamUtility
     */
    protected static function getInputStreamUtilityService($container)
    {
        return $container->services['PsCheckout\\Utility\\Common\\InputStreamUtility'] = new \PsCheckout\Utility\Common\InputStreamUtility();
    }

    /**
     * Gets the public 'Psr\Log\LoggerInterface' shared service.
     *
     * @return \Psr\Log\LoggerInterface
     */
    protected static function getLoggerInterfaceService($container)
    {
        return $container->services['Psr\\Log\\LoggerInterface'] = ($container->services['PsCheckout\\Infrastructure\\Logger\\LoggerFactory'] ?? self::getLoggerFactoryService($container))->build();
    }

    /**
     * Gets the public 'Symfony\Component\HttpFoundation\RequestStack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected static function getRequestStackService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['Symfony\\Component\\HttpFoundation\\RequestStack'] = $container->createProxy('RequestStackProxyA9608a6', static fn () => \RequestStackProxyA9608a6::createLazyProxy(static fn () => self::getRequestStackService($container, false)));
        }

        return \PrestaShopBundle\Http\RequestStackFactory::buildRequestStack();
    }

    /**
     * Gets the public 'annotation_reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\AnnotationReader
     */
    protected static function getAnnotationReaderService($container)
    {
        return $container->services['annotation_reader'] = new \Doctrine\Common\Annotations\AnnotationReader();
    }

    /**
     * Gets the public 'array' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getArrayService($container)
    {
        return $container->services['array'] = (new \PrestaShopBundle\DependencyInjection\CacheAdapterFactory())->getCacheAdapter('array');
    }

    /**
     * Gets the public 'configuration' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Configuration
     */
    protected static function getConfiguration3Service($container)
    {
        return $container->services['configuration'] = new \PrestaShop\PrestaShop\Adapter\Configuration();
    }

    /**
     * Gets the public 'container.env_var_processors_locator' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function getContainer_EnvVarProcessorsLocatorService($container)
    {
        return $container->services['container.env_var_processors_locator'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'const' => ['privates', 'PrestaShopBundle\\DependencyInjection\\RuntimeConstEnvVarProcessor', 'getRuntimeConstEnvVarProcessorService', false],
        ], [
            'const' => '?',
        ]);
    }

    /**
     * Gets the public 'context' shared service.
     *
     * @return \Context
     */
    protected static function getContext2Service($container)
    {
        return $container->services['context'] = \Context::getContext();
    }

    /**
     * Gets the public 'db' shared service.
     *
     * @return \Db
     */
    protected static function getDbService($container)
    {
        return $container->services['db'] = \Db::getInstance();
    }

    /**
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected static function getDoctrineService($container)
    {
        return $container->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($container, $container->parameters['doctrine.connections'], $container->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /**
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \PrestaShopBundle\Doctrine\DatabaseConnection
     */
    protected static function getDoctrine_Dbal_DefaultConnectionService($container)
    {
        return $container->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory([]))->createConnection(['driver' => 'pdo_mysql', 'host' => 'localhost', 'port' => '', 'dbname' => 'fletcher_pres111', 'user' => 'fletcher_pres111', 'password' => ')1!1S7T37p', 'charset' => 'utf8mb4', 'driverOptions' => [1002 => 'SET sql_mode=(SELECT REPLACE(@@sql_mode,\'ONLY_FULL_GROUP_BY\',\'\'))', 1013 => $container->getEnv('const:runtime:_PS_ALLOW_MULTI_STATEMENTS_QUERIES_')], 'wrapperClass' => 'PrestaShopBundle\\Doctrine\\DatabaseConnection', 'defaultTableOptions' => []], new \Doctrine\DBAL\Configuration(), new \Symfony\Bridge\Doctrine\ContainerAwareEventManager($container), ['enum' => 'string']);
    }

    /**
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected static function getDoctrine_Orm_DefaultEntityManagerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['doctrine.orm.default_entity_manager'] = $container->createProxy('EntityManagerProxyCaac541', static fn () => \EntityManagerProxyCaac541::createLazyProxy(static fn () => self::getDoctrine_Orm_DefaultEntityManagerService($container, false)));
        }

        $instance = \Doctrine\ORM\EntityManager::create(($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), ($container->privates['doctrine.orm.default_configuration'] ?? self::getDoctrine_Orm_DefaultConfigurationService($container)));

        ($container->privates['doctrine.orm.default_manager_configurator'] ??= new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator([], []))->configure($instance);

        return $instance;
    }

    /**
     * Gets the public 'prestashop.adapter.data_provider.country' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Country\CountryDataProvider
     */
    protected static function getPrestashop_Adapter_DataProvider_CountryService($container)
    {
        return $container->services['prestashop.adapter.data_provider.country'] = new \PrestaShop\PrestaShop\Adapter\Country\CountryDataProvider();
    }

    /**
     * Gets the public 'prestashop.adapter.employee_language_updater' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Employee\EmployeeLanguageUpdater
     */
    protected static function getPrestashop_Adapter_EmployeeLanguageUpdaterService($container)
    {
        return $container->services['prestashop.adapter.employee_language_updater'] = new \PrestaShop\PrestaShop\Adapter\Employee\EmployeeLanguageUpdater(($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), 'psmm_', ($container->services['PrestaShop\\PrestaShop\\Adapter\\Configuration'] ??= new \PrestaShop\PrestaShop\Adapter\Configuration())->get("PS_LANG_DEFAULT"));
    }

    /**
     * Gets the public 'prestashop.adapter.environment' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Environment
     */
    protected static function getPrestashop_Adapter_EnvironmentService($container)
    {
        return $container->services['prestashop.adapter.environment'] = new \PrestaShop\PrestaShop\Adapter\Environment(false, 'prod', 'front');
    }

    /**
     * Gets the public 'prestashop.adapter.module.repository.module_repository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Module\Repository\ModuleRepository
     */
    protected static function getPrestashop_Adapter_Module_Repository_ModuleRepositoryService($container)
    {
        return $container->services['prestashop.adapter.module.repository.module_repository'] = new \PrestaShop\PrestaShop\Adapter\Module\Repository\ModuleRepository('/home/fletcher/public_html/fletchermall.com', '/home/fletcher/public_html/fletchermall.com/modules/');
    }

    /**
     * Gets the public 'prestashop.adapter.validate' shared service.
     *
     * @return \PrestaShop\PrestaShop\Adapter\Validate
     */
    protected static function getPrestashop_Adapter_ValidateService($container)
    {
        return $container->services['prestashop.adapter.validate'] = new \PrestaShop\PrestaShop\Adapter\Validate();
    }

    /**
     * Gets the public 'prestashop.core.circuit_breaker.advanced_factory' shared service.
     *
     * @return \PrestaShop\CircuitBreaker\AdvancedCircuitBreakerFactory
     */
    protected static function getPrestashop_Core_CircuitBreaker_AdvancedFactoryService($container)
    {
        return $container->services['prestashop.core.circuit_breaker.advanced_factory'] = new \PrestaShop\CircuitBreaker\AdvancedCircuitBreakerFactory();
    }

    /**
     * Gets the public 'prestashop.core.circuit_breaker.cache' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getPrestashop_Core_CircuitBreaker_CacheService($container)
    {
        return $container->services['prestashop.core.circuit_breaker.cache'] = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('', 0, (($container->services['prestashop.adapter.environment'] ??= new \PrestaShop\PrestaShop\Adapter\Environment(false, 'prod', 'front'))->getCacheDir() . "/circuit_breaker"));
    }

    /**
     * Gets the public 'prestashop.core.circuit_breaker.doctrine_cache' shared service.
     *
     * @return \Doctrine\Common\Cache\Psr6\DoctrineProvider
     */
    protected static function getPrestashop_Core_CircuitBreaker_DoctrineCacheService($container)
    {
        return $container->services['prestashop.core.circuit_breaker.doctrine_cache'] = \Doctrine\Common\Cache\Psr6\DoctrineProvider::wrap(($container->services['prestashop.core.circuit_breaker.cache'] ?? self::getPrestashop_Core_CircuitBreaker_CacheService($container)));
    }

    /**
     * Gets the public 'prestashop.core.circuit_breaker.storage' shared service.
     *
     * @return \PrestaShop\CircuitBreaker\Storage\DoctrineCache
     */
    protected static function getPrestashop_Core_CircuitBreaker_StorageService($container)
    {
        return $container->services['prestashop.core.circuit_breaker.storage'] = new \PrestaShop\CircuitBreaker\Storage\DoctrineCache(($container->services['prestashop.core.circuit_breaker.doctrine_cache'] ?? self::getPrestashop_Core_CircuitBreaker_DoctrineCacheService($container)));
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.cart' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\CartFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_CartService($container)
    {
        return $container->services['prestashop.core.filter.front_end_object.cart'] = new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\CartFilter(($container->services['prestashop.core.filter.front_end_object.product_collection'] ?? self::getPrestashop_Core_Filter_FrontEndObject_ProductCollectionService($container)));
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.configuration' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ConfigurationFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_ConfigurationService($container)
    {
        return $container->services['prestashop.core.filter.front_end_object.configuration'] = new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ConfigurationFilter();
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.customer' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\CustomerFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_CustomerService($container)
    {
        return $container->services['prestashop.core.filter.front_end_object.customer'] = new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\CustomerFilter();
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.main' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\MainFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_MainService($container)
    {
        return $container->services['prestashop.core.filter.front_end_object.main'] = new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\MainFilter(['cart' => ($container->services['prestashop.core.filter.front_end_object.cart'] ?? self::getPrestashop_Core_Filter_FrontEndObject_CartService($container)), 'customer' => ($container->services['prestashop.core.filter.front_end_object.customer'] ??= new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\CustomerFilter()), 'shop' => ($container->services['prestashop.core.filter.front_end_object.shop'] ??= new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ShopFilter()), 'configuration' => ($container->services['prestashop.core.filter.front_end_object.configuration'] ??= new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ConfigurationFilter())]);
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.product' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ProductFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_ProductService($container)
    {
        return $container->services['prestashop.core.filter.front_end_object.product'] = new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ProductFilter();
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.product_collection' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\CollectionFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_ProductCollectionService($container)
    {
        $container->services['prestashop.core.filter.front_end_object.product_collection'] = $instance = new \PrestaShop\PrestaShop\Core\Filter\CollectionFilter();

        $instance->queue([($container->services['prestashop.core.filter.front_end_object.product'] ??= new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ProductFilter())]);

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.search_result_product' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\SearchResultProductFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_SearchResultProductService($container)
    {
        return $container->services['prestashop.core.filter.front_end_object.search_result_product'] = new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\SearchResultProductFilter();
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.search_result_product_collection' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\CollectionFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_SearchResultProductCollectionService($container)
    {
        $container->services['prestashop.core.filter.front_end_object.search_result_product_collection'] = $instance = new \PrestaShop\PrestaShop\Core\Filter\CollectionFilter();

        $instance->queue([($container->services['prestashop.core.filter.front_end_object.search_result_product'] ??= new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\SearchResultProductFilter())]);

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.filter.front_end_object.shop' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ShopFilter
     */
    protected static function getPrestashop_Core_Filter_FrontEndObject_ShopService($container)
    {
        return $container->services['prestashop.core.filter.front_end_object.shop'] = new \PrestaShop\PrestaShop\Core\Filter\FrontEndObject\ShopFilter();
    }

    /**
     * Gets the public 'prestashop.core.localization.cache.adapter' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\ArrayAdapter
     */
    protected static function getPrestashop_Core_Localization_Cache_AdapterService($container)
    {
        return $container->services['prestashop.core.localization.cache.adapter'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.cache.adapter' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getPrestashop_Core_Localization_Cldr_Cache_AdapterService($container)
    {
        return $container->services['prestashop.core.localization.cldr.cache.adapter'] = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('CLDR', 0, '/home/fletcher/public_html/fletchermall.com/var/cache/prod//localization');
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.datalayer.locale_cache' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\DataLayer\LocaleCache
     */
    protected static function getPrestashop_Core_Localization_Cldr_Datalayer_LocaleCacheService($container)
    {
        $container->services['prestashop.core.localization.cldr.datalayer.locale_cache'] = $instance = new \PrestaShop\PrestaShop\Core\Localization\CLDR\DataLayer\LocaleCache(($container->services['prestashop.core.localization.cldr.cache.adapter'] ??= new \Symfony\Component\Cache\Adapter\FilesystemAdapter('CLDR', 0, '/home/fletcher/public_html/fletchermall.com/var/cache/prod//localization')));

        $instance->setLowerLayer(($container->services['prestashop.core.localization.cldr.datalayer.locale_reference'] ?? self::getPrestashop_Core_Localization_Cldr_Datalayer_LocaleReferenceService($container)));

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.datalayer.locale_reference' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\DataLayer\LocaleReference
     */
    protected static function getPrestashop_Core_Localization_Cldr_Datalayer_LocaleReferenceService($container)
    {
        return $container->services['prestashop.core.localization.cldr.datalayer.locale_reference'] = new \PrestaShop\PrestaShop\Core\Localization\CLDR\DataLayer\LocaleReference(($container->services['prestashop.core.localization.cldr.reader'] ??= new \PrestaShop\PrestaShop\Core\Localization\CLDR\Reader()));
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.locale_data_source' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleDataSource
     */
    protected static function getPrestashop_Core_Localization_Cldr_LocaleDataSourceService($container)
    {
        return $container->services['prestashop.core.localization.cldr.locale_data_source'] = new \PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleDataSource(($container->services['prestashop.core.localization.cldr.datalayer.locale_cache'] ?? self::getPrestashop_Core_Localization_Cldr_Datalayer_LocaleCacheService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.reader' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\CLDR\Reader
     */
    protected static function getPrestashop_Core_Localization_Cldr_ReaderService($container)
    {
        return $container->services['prestashop.core.localization.cldr.reader'] = new \PrestaShop\PrestaShop\Core\Localization\CLDR\Reader();
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.datasource' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\CurrencyDataSource
     */
    protected static function getPrestashop_Core_Localization_Currency_DatasourceService($container)
    {
        return $container->services['prestashop.core.localization.currency.datasource'] = new \PrestaShop\PrestaShop\Core\Localization\Currency\CurrencyDataSource(($container->services['prestashop.core.localization.currency.middleware.cache'] ?? self::getPrestashop_Core_Localization_Currency_Middleware_CacheService($container)), ($container->services['prestashop.core.localization.currency.middleware.installed'] ?? self::getPrestashop_Core_Localization_Currency_Middleware_InstalledService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.middleware.cache' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyCache
     */
    protected static function getPrestashop_Core_Localization_Currency_Middleware_CacheService($container)
    {
        $container->services['prestashop.core.localization.currency.middleware.cache'] = $instance = new \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyCache(($container->services['prestashop.core.localization.cache.adapter'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()));

        $instance->setLowerLayer(($container->services['prestashop.core.localization.currency.middleware.database'] ?? self::getPrestashop_Core_Localization_Currency_Middleware_DatabaseService($container)));

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.middleware.database' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyDatabase
     */
    protected static function getPrestashop_Core_Localization_Currency_Middleware_DatabaseService($container)
    {
        $container->services['prestashop.core.localization.currency.middleware.database'] = $instance = new \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyDatabase(($container->services['PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider'] ?? self::getCurrencyDataProviderService($container)));

        $instance->setLowerLayer(($container->services['prestashop.core.localization.currency.middleware.reference'] ?? self::getPrestashop_Core_Localization_Currency_Middleware_ReferenceService($container)));

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.middleware.installed' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyInstalled
     */
    protected static function getPrestashop_Core_Localization_Currency_Middleware_InstalledService($container)
    {
        return $container->services['prestashop.core.localization.currency.middleware.installed'] = new \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyInstalled(($container->services['PrestaShop\\PrestaShop\\Adapter\\Currency\\CurrencyDataProvider'] ?? self::getCurrencyDataProviderService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.middleware.reference' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyReference
     */
    protected static function getPrestashop_Core_Localization_Currency_Middleware_ReferenceService($container)
    {
        return $container->services['prestashop.core.localization.currency.middleware.reference'] = new \PrestaShop\PrestaShop\Core\Localization\Currency\DataLayer\CurrencyReference(($container->services['PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository'] ?? self::getLocaleRepositoryService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.currency.repository' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Currency\Repository
     */
    protected static function getPrestashop_Core_Localization_Currency_RepositoryService($container)
    {
        return $container->services['prestashop.core.localization.currency.repository'] = new \PrestaShop\PrestaShop\Core\Localization\Currency\Repository(($container->services['prestashop.core.localization.currency.datasource'] ?? self::getPrestashop_Core_Localization_Currency_DatasourceService($container)));
    }

    /**
     * Gets the public 'prestashop.core.localization.locale.context_locale' shared service.
     *
     * @return \PrestaShop\PrestaShop\Core\Localization\Locale
     */
    protected static function getPrestashop_Core_Localization_Locale_ContextLocaleService($container)
    {
        return $container->services['prestashop.core.localization.locale.context_locale'] = ($container->services['PrestaShop\\PrestaShop\\Core\\Localization\\Locale\\Repository'] ?? self::getRepositoryService($container))->getLocale(($container->services['PrestaShop\\PrestaShop\\Adapter\\LegacyContext'] ?? self::getLegacyContextService($container))->getContext()->language->getLocale());
    }

    /**
     * Gets the public 'prestashop.database.naming_strategy' shared service.
     *
     * @return \PrestaShopBundle\Service\Database\DoctrineNamingStrategy
     */
    protected static function getPrestashop_Database_NamingStrategyService($container)
    {
        return $container->services['prestashop.database.naming_strategy'] = new \PrestaShopBundle\Service\Database\DoctrineNamingStrategy(($container->services['annotation_reader'] ??= new \Doctrine\Common\Annotations\AnnotationReader()), 'psmm_');
    }

    /**
     * Gets the public 'prestashop.translation.translator_language_loader' shared service.
     *
     * @return \PrestaShopBundle\Translation\TranslatorLanguageLoader
     */
    protected static function getPrestashop_Translation_TranslatorLanguageLoaderService($container)
    {
        return $container->services['prestashop.translation.translator_language_loader'] = new \PrestaShopBundle\Translation\TranslatorLanguageLoader(($container->services['prestashop.adapter.module.repository.module_repository'] ??= new \PrestaShop\PrestaShop\Adapter\Module\Repository\ModuleRepository('/home/fletcher/public_html/fletchermall.com', '/home/fletcher/public_html/fletchermall.com/modules/')));
    }

    /**
     * Gets the public 'product_comment_criterion_repository' shared service.
     *
     * @return \PrestaShop\Module\ProductComment\Repository\ProductCommentCriterionRepository
     */
    protected static function getProductCommentCriterionRepositoryService($container)
    {
        return $container->services['product_comment_criterion_repository'] = new \PrestaShop\Module\ProductComment\Repository\ProductCommentCriterionRepository(($container->services['doctrine'] ?? self::getDoctrineService($container)), ($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), 'psmm_');
    }

    /**
     * Gets the public 'product_comment_repository' shared service.
     *
     * @return \PrestaShop\Module\ProductComment\Repository\ProductCommentRepository
     */
    protected static function getProductCommentRepositoryService($container)
    {
        return $container->services['product_comment_repository'] = new \PrestaShop\Module\ProductComment\Repository\ProductCommentRepository(($container->services['doctrine'] ?? self::getDoctrineService($container)), ($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), 'psmm_', ($container->services['PrestaShop\\PrestaShop\\Adapter\\Configuration'] ??= new \PrestaShop\PrestaShop\Adapter\Configuration())->get("PRODUCT_COMMENTS_ALLOW_GUESTS"), ($container->services['PrestaShop\\PrestaShop\\Adapter\\Configuration'] ??= new \PrestaShop\PrestaShop\Adapter\Configuration())->get("PRODUCT_COMMENTS_MINIMAL_TIME"));
    }

    /**
     * Gets the public 'ps_accounts.facade' shared service.
     *
     * @return \PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts
     */
    protected static function getPsAccounts_FacadeService($container)
    {
        return $container->services['ps_accounts.facade'] = new \PrestaShop\PsAccountsInstaller\Installer\Facade\PsAccounts(($container->services['ps_accounts.installer'] ??= new \PrestaShop\PsAccountsInstaller\Installer\Installer('5.0')));
    }

    /**
     * Gets the public 'ps_accounts.installer' shared service.
     *
     * @return \PrestaShop\PsAccountsInstaller\Installer\Installer
     */
    protected static function getPsAccounts_InstallerService($container)
    {
        return $container->services['ps_accounts.installer'] = new \PrestaShop\PsAccountsInstaller\Installer\Installer('5.0');
    }

    /**
     * Gets the public 'ps_checkout.db' shared service.
     *
     * @return \Db
     */
    protected static function getPsCheckout_DbService($container)
    {
        return $container->services['ps_checkout.db'] = \Db::getInstance();
    }

    /**
     * Gets the public 'ps_checkout.module' shared service.
     *
     * @return \ps_checkout
     */
    protected static function getPsCheckout_ModuleService($container)
    {
        return $container->services['ps_checkout.module'] = \Module::getInstanceByName('ps_checkout');
    }

    /**
     * Gets the public 'ps_facebook' shared service.
     *
     * @return \Ps_facebook
     */
    protected static function getPsFacebookService($container)
    {
        return $container->services['ps_facebook'] = \Module::getInstanceByName('ps_facebook');
    }

    /**
     * Gets the public 'ps_facebook.billing_env' shared service.
     *
     * @return \PrestaShop\Module\PrestashopFacebook\Factory\ParametersFactory
     */
    protected static function getPsFacebook_BillingEnvService($container)
    {
        return $container->services['ps_facebook.billing_env'] = \PrestaShop\Module\PrestashopFacebook\Factory\ParametersFactory::getBillingEnv();
    }

    /**
     * Gets the public 'ps_facebook.cache' shared service.
     *
     * @return \string
     */
    protected static function getPsFacebook_CacheService($container)
    {
        return $container->services['ps_facebook.cache'] = \PrestaShop\Module\PrestashopFacebook\Factory\CacheFactory::getCachePath();
    }

    /**
     * Gets the public 'ps_facebook.context' shared service.
     *
     * @return \Context
     */
    protected static function getPsFacebook_ContextService($container)
    {
        return $container->services['ps_facebook.context'] = \PrestaShop\Module\PrestashopFacebook\Factory\ContextFactory::getContext();
    }

    /**
     * Gets the public 'ps_facebook.controller' shared service.
     *
     * @return \Controller
     */
    protected static function getPsFacebook_ControllerService($container)
    {
        return $container->services['ps_facebook.controller'] = \PrestaShop\Module\PrestashopFacebook\Factory\ContextFactory::getController();
    }

    /**
     * Gets the public 'ps_facebook.cookie' shared service.
     *
     * @return \Cookie
     */
    protected static function getPsFacebook_CookieService($container)
    {
        return $container->services['ps_facebook.cookie'] = \PrestaShop\Module\PrestashopFacebook\Factory\ContextFactory::getCookie();
    }

    /**
     * Gets the public 'ps_facebook.currency' shared service.
     *
     * @return \Currency
     */
    protected static function getPsFacebook_CurrencyService($container)
    {
        return $container->services['ps_facebook.currency'] = \PrestaShop\Module\PrestashopFacebook\Factory\ContextFactory::getCurrency();
    }

    /**
     * Gets the public 'ps_facebook.language' shared service.
     *
     * @return \Language
     */
    protected static function getPsFacebook_LanguageService($container)
    {
        return $container->services['ps_facebook.language'] = \PrestaShop\Module\PrestashopFacebook\Factory\ContextFactory::getLanguage();
    }

    /**
     * Gets the public 'ps_facebook.link' shared service.
     *
     * @return \Shop
     */
    protected static function getPsFacebook_LinkService($container)
    {
        return $container->services['ps_facebook.link'] = \PrestaShop\Module\PrestashopFacebook\Factory\ContextFactory::getLink();
    }

    /**
     * Gets the public 'ps_facebook.shop' shared service.
     *
     * @return \Shop
     */
    protected static function getPsFacebook_ShopService($container)
    {
        return $container->services['ps_facebook.shop'] = \PrestaShop\Module\PrestashopFacebook\Factory\ContextFactory::getShop();
    }

    /**
     * Gets the public 'ps_facebook.smarty' shared service.
     *
     * @return \Smarty
     */
    protected static function getPsFacebook_SmartyService($container)
    {
        return $container->services['ps_facebook.smarty'] = \PrestaShop\Module\PrestashopFacebook\Factory\ContextFactory::getSmarty();
    }

    /**
     * Gets the public 'psshipping' shared service.
     *
     * @return \Psshipping
     */
    protected static function getPsshippingService($container)
    {
        return $container->services['psshipping'] = \Module::getInstanceByName('psshipping');
    }

    /**
     * Gets the public 'psshipping.context' shared service.
     *
     * @return \Context
     */
    protected static function getPsshipping_ContextService($container)
    {
        return $container->services['psshipping.context'] = \Context::getContext();
    }

    /**
     * Gets the public 'psshipping.helper.config' shared service.
     *
     * @return \PrestaShop\Module\Psshipping\Helper\ConfigHelper
     */
    protected static function getPsshipping_Helper_ConfigService($container)
    {
        return $container->services['psshipping.helper.config'] = new \PrestaShop\Module\Psshipping\Helper\ConfigHelper('https://shipping-api.prestashop.com', 'https://www.mbe.it/en/tracking?c=@', '3XsHeI2dfKoKE2wReGp7IO2bLa5hbeVB', 'https://78c41abf489931010a3a83cacc14926b@o298402.ingest.sentry.io/4505906299600896', 'production');
    }

    /**
     * Gets the public 'psshipping.ps_billings_context_wrapper' shared service.
     *
     * @return \PrestaShopCorp\Billing\Wrappers\BillingContextWrapper
     */
    protected static function getPsshipping_PsBillingsContextWrapperService($container)
    {
        return $container->services['psshipping.ps_billings_context_wrapper'] = new \PrestaShopCorp\Billing\Wrappers\BillingContextWrapper(($container->services['ps_accounts.facade'] ?? self::getPsAccounts_FacadeService($container)), ($container->services['psshipping.context'] ?? self::getPsshipping_ContextService($container)), 0);
    }

    /**
     * Gets the public 'psshipping.ps_billings_facade' shared service.
     *
     * @return \PrestaShopCorp\Billing\Presenter\BillingPresenter
     */
    protected static function getPsshipping_PsBillingsFacadeService($container)
    {
        return $container->services['psshipping.ps_billings_facade'] = new \PrestaShopCorp\Billing\Presenter\BillingPresenter(($container->services['psshipping.ps_billings_context_wrapper'] ?? self::getPsshipping_PsBillingsContextWrapperService($container)), ($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'psshipping.ps_billings_service' shared service.
     *
     * @return \PrestaShopCorp\Billing\Services\BillingService
     */
    protected static function getPsshipping_PsBillingsServiceService($container)
    {
        return $container->services['psshipping.ps_billings_service'] = new \PrestaShopCorp\Billing\Services\BillingService(($container->services['psshipping.ps_billings_context_wrapper'] ?? self::getPsshipping_PsBillingsContextWrapperService($container)), ($container->services['psshipping'] ?? self::getPsshippingService($container)));
    }

    /**
     * Gets the public 'psxmarketingwithgoogle' shared service.
     *
     * @return \PsxMarketingWithGoogle
     */
    protected static function getPsxmarketingwithgoogleService($container)
    {
        return $container->services['psxmarketingwithgoogle'] = \Module::getInstanceByName('psxmarketingwithgoogle');
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.billing_env' shared service.
     *
     * @return \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ParametersFactory
     */
    protected static function getPsxmarketingwithgoogle_BillingEnvService($container)
    {
        return $container->services['psxmarketingwithgoogle.billing_env'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ParametersFactory::getBillingEnv();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.cart' shared service.
     *
     * @return \Currency
     */
    protected static function getPsxmarketingwithgoogle_CartService($container)
    {
        return $container->services['psxmarketingwithgoogle.cart'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCart();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.context' shared service.
     *
     * @return \Context
     */
    protected static function getPsxmarketingwithgoogle_ContextService($container)
    {
        return $container->services['psxmarketingwithgoogle.context'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getContext();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.controller' shared service.
     *
     * @return \Controller
     */
    protected static function getPsxmarketingwithgoogle_ControllerService($container)
    {
        return $container->services['psxmarketingwithgoogle.controller'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getController();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.cookie' shared service.
     *
     * @return \Cookie
     */
    protected static function getPsxmarketingwithgoogle_CookieService($container)
    {
        return $container->services['psxmarketingwithgoogle.cookie'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCookie();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.country' shared service.
     *
     * @return \Country
     */
    protected static function getPsxmarketingwithgoogle_CountryService($container)
    {
        return $container->services['psxmarketingwithgoogle.country'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCountry();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.currency' shared service.
     *
     * @return \Currency
     */
    protected static function getPsxmarketingwithgoogle_CurrencyService($container)
    {
        return $container->services['psxmarketingwithgoogle.currency'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCurrency();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.customer' shared service.
     *
     * @return \Currency
     */
    protected static function getPsxmarketingwithgoogle_CustomerService($container)
    {
        return $container->services['psxmarketingwithgoogle.customer'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getCustomer();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.db' shared service.
     *
     * @return \Db
     */
    protected static function getPsxmarketingwithgoogle_DbService($container)
    {
        return $container->services['psxmarketingwithgoogle.db'] = \Db::getInstance();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.language' shared service.
     *
     * @return \Language
     */
    protected static function getPsxmarketingwithgoogle_LanguageService($container)
    {
        return $container->services['psxmarketingwithgoogle.language'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getLanguage();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.link' shared service.
     *
     * @return \Shop
     */
    protected static function getPsxmarketingwithgoogle_LinkService($container)
    {
        return $container->services['psxmarketingwithgoogle.link'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getLink();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.shop' shared service.
     *
     * @return \Shop
     */
    protected static function getPsxmarketingwithgoogle_ShopService($container)
    {
        return $container->services['psxmarketingwithgoogle.shop'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getShop();
    }

    /**
     * Gets the public 'psxmarketingwithgoogle.smarty' shared service.
     *
     * @return \Smarty
     */
    protected static function getPsxmarketingwithgoogle_SmartyService($container)
    {
        return $container->services['psxmarketingwithgoogle.smarty'] = \PrestaShop\Module\PsxMarketingWithGoogle\Factory\ContextFactory::getSmarty();
    }

    /**
     * Gets the private '.service_locator.lWqUA3s' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function get_ServiceLocator_LWqUA3sService($container)
    {
        return $container->privates['.service_locator.lWqUA3s'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'env' => ['privates', 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer', 'getEnvLayerService', false],
            'db' => ['privates', 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer', 'getDbLayerService', false],
            'dotenv' => ['privates', 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer', 'getDotEnvLayerService', false],
            'query' => ['privates', 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer', 'getQueryLayerService', false],
        ], [
            'env' => 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer',
            'db' => 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer',
            'dotenv' => 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer',
            'query' => 'PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer',
        ]);
    }

    /**
     * Gets the private 'PrestaShopBundle\DependencyInjection\RuntimeConstEnvVarProcessor' shared service.
     *
     * @return \PrestaShopBundle\DependencyInjection\RuntimeConstEnvVarProcessor
     */
    protected static function getRuntimeConstEnvVarProcessorService($container)
    {
        return $container->privates['PrestaShopBundle\\DependencyInjection\\RuntimeConstEnvVarProcessor'] = new \PrestaShopBundle\DependencyInjection\RuntimeConstEnvVarProcessor();
    }

    /**
     * Gets the private 'PrestaShopBundle\Entity\Repository\FeatureFlagRepository' shared service.
     *
     * @return \PrestaShopBundle\Entity\Repository\FeatureFlagRepository
     */
    protected static function getFeatureFlagRepositoryService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShopBundle\\Entity\\Repository\\FeatureFlagRepository'] = $container->createProxy('FeatureFlagRepositoryProxy1ddab28', static fn () => \FeatureFlagRepositoryProxy1ddab28::createLazyProxy(static fn () => self::getFeatureFlagRepositoryService($container, false)));
        }

        return ($container->services['doctrine.orm.default_entity_manager'] ?? self::getDoctrine_Orm_DefaultEntityManagerService($container))->getRepository('PrestaShopBundle\\Entity\\FeatureFlag');
    }

    /**
     * Gets the private 'PrestaShopCorp\Billing\Wrappers\BillingContextWrapper' shared service.
     *
     * @return \PrestaShopCorp\Billing\Wrappers\BillingContextWrapper
     */
    protected static function getBillingContextWrapperService($container)
    {
        return $container->privates['PrestaShopCorp\\Billing\\Wrappers\\BillingContextWrapper'] = new \PrestaShopCorp\Billing\Wrappers\BillingContextWrapper(($container->services['PrestaShop\\PsAccountsInstaller\\Installer\\Facade\\PsAccounts'] ?? self::getPsAccountsService($container)), ($container->services['ps_facebook.context'] ?? self::getPsFacebook_ContextService($container)), ($container->services['ps_facebook.billing_env'] ?? self::getPsFacebook_BillingEnvService($container)));
    }

    /**
     * Gets the private 'PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DbLayer' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DbLayer
     */
    protected static function getDbLayerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DbLayer'] = $container->createProxy('DbLayerGhostB471b8b', static fn () => \DbLayerGhostB471b8b::createLazyGhost(static fn ($proxy) => self::getDbLayerService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->privates['PrestaShopBundle\\Entity\\Repository\\FeatureFlagRepository'] ?? self::getFeatureFlagRepositoryService($container))) && false ?: $lazyLoad);
    }

    /**
     * Gets the private 'PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DotEnvLayer' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DotEnvLayer
     */
    protected static function getDotEnvLayerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\DotEnvLayer'] = $container->createProxy('DotEnvLayerGhost71d5ebb', static fn () => \DotEnvLayerGhost71d5ebb::createLazyGhost(static fn ($proxy) => self::getDotEnvLayerService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->services['prestashop.adapter.environment'] ??= new \PrestaShop\PrestaShop\Adapter\Environment(false, 'prod', 'front')), '/home/fletcher/public_html/fletchermall.com') && false ?: $lazyLoad);
    }

    /**
     * Gets the private 'PrestaShop\PrestaShop\Core\FeatureFlag\Layer\EnvLayer' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\EnvLayer
     */
    protected static function getEnvLayerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\EnvLayer'] = $container->createProxy('EnvLayerGhostEdbcd0e', static fn () => \EnvLayerGhostEdbcd0e::createLazyGhost(static fn ($proxy) => self::getEnvLayerService($container, $proxy)));
        }

        return $lazyLoad;
    }

    /**
     * Gets the private 'PrestaShop\PrestaShop\Core\FeatureFlag\Layer\QueryLayer' shared autowired service.
     *
     * @return \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\QueryLayer
     */
    protected static function getQueryLayerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['PrestaShop\\PrestaShop\\Core\\FeatureFlag\\Layer\\QueryLayer'] = $container->createProxy('QueryLayerGhostEa7d94d', static fn () => \QueryLayerGhostEa7d94d::createLazyGhost(static fn ($proxy) => self::getQueryLayerService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->services['prestashop.adapter.environment'] ??= new \PrestaShop\PrestaShop\Adapter\Environment(false, 'prod', 'front')), ($container->services['Symfony\\Component\\HttpFoundation\\RequestStack'] ?? self::getRequestStackService($container))) && false ?: $lazyLoad);
    }

    /**
     * Gets the private 'doctrine.orm.default_configuration' shared service.
     *
     * @return \Doctrine\ORM\Configuration
     */
    protected static function getDoctrine_Orm_DefaultConfigurationService($container)
    {
        $container->privates['doctrine.orm.default_configuration'] = $instance = new \Doctrine\ORM\Configuration();

        $a = ($container->services['array'] ?? self::getArrayService($container));
        $b = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();

        $c = ($container->services['annotation_reader'] ??= new \Doctrine\Common\Annotations\AnnotationReader());
        $d = new \Doctrine\ORM\Mapping\Driver\AnnotationDriver($c, ['/home/fletcher/public_html/fletchermall.com/modules/productcomments/src/Entity']);
        $d->addExcludePaths(['/home/fletcher/public_html/fletchermall.com/modules/productcomments/src/Entity/index.php']);
        $e = new \Doctrine\ORM\Mapping\Driver\AnnotationDriver($c, ['/home/fletcher/public_html/fletchermall.com/modules/psshipping/src/Entity']);
        $e->addExcludePaths(['/home/fletcher/public_html/fletchermall.com/modules/psshipping/src/Entity/index.php']);
        $f = new \Doctrine\ORM\Mapping\Driver\AnnotationDriver($c, ['/home/fletcher/public_html/fletchermall.com/modules/ps_accounts/src/Entity']);
        $f->addExcludePaths(['/home/fletcher/public_html/fletchermall.com/modules/ps_accounts/src/Entity/index.php']);

        $b->addDriver(new \Doctrine\ORM\Mapping\Driver\AnnotationDriver($c, ['/home/fletcher/public_html/fletchermall.com/src/PrestaShopBundle/Entity']), 'PrestaShop');
        $b->addDriver($d, 'PrestaShop\\Module\\ProductComment\\Entity');
        $b->addDriver($e, 'PrestaShop\\Module\\Psshipping\\Entity');
        $b->addDriver($f, 'PrestaShop\\Module\\PsAccounts\\Entity');

        $instance->setEntityNamespaces(['PrestaShopBundle\\Entity' => 'PrestaShop']);
        $instance->setMetadataCache($a);
        $instance->setQueryCache($a);
        $instance->setResultCache($a);
        $instance->setMetadataDriverImpl($b);
        $instance->setProxyDir('/home/fletcher/public_html/fletchermall.com/var/cache/prod//doctrine/orm/Proxies');
        $instance->setProxyNamespace('Proxies');
        $instance->setAutoGenerateProxyClasses(false);
        $instance->setClassMetadataFactoryName('Doctrine\\ORM\\Mapping\\ClassMetadataFactory');
        $instance->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $instance->setNamingStrategy(($container->services['prestashop.database.naming_strategy'] ?? self::getPrestashop_Database_NamingStrategyService($container)));
        $instance->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $instance->setEntityListenerResolver(new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver($container));
        $instance->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(new \Symfony\Component\DependencyInjection\ServiceLocator([])));
        $instance->addCustomStringFunction('regexp', 'DoctrineExtensions\\Query\\Mysql\\Regexp');
        $instance->addCustomStringFunction('binary', 'DoctrineExtensions\\Query\\Mysql\\Binary');

        return $instance;
    }

    /**
     * Gets the public 'prestashop.core.localization.cldr.locale_repository' alias.
     *
     * @return object The "PrestaShop\PrestaShop\Core\Localization\CLDR\LocaleRepository" service.
     */
    protected static function getPrestashop_Core_Localization_Cldr_LocaleRepositoryService($container)
    {
        trigger_deprecation('PrestaShop/PrestaShop', '9', 'The "prestashop.core.localization.cldr.locale_repository" service alias is deprecated. You should stop using it, as it will be removed in the future.');

        return $container->get('PrestaShop\\PrestaShop\\Core\\Localization\\CLDR\\LocaleRepository');
    }

    /**
     * Gets the public 'prestashop.adapter.tools' alias.
     *
     * @return object The "PrestaShop\PrestaShop\Adapter\Tools" service.
     */
    protected static function getPrestashop_Adapter_ToolsService($container)
    {
        trigger_deprecation('PrestaShop\\PrestaShop', '8.1', 'The "prestashop.adapter.tools" service alias is deprecated. You should stop using it, as it will be removed in the future.');

        return $container->get('PrestaShop\\PrestaShop\\Adapter\\Tools');
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new ParameterNotFoundException($name);
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (!isset($this->parameterBag)) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        throw new ParameterNotFoundException($name);
    }

    protected function getDefaultParameters(): array
    {
        return [
            'database_host' => 'localhost',
            'database_port' => '',
            'database_name' => 'fletcher_pres111',
            'database_user' => 'fletcher_pres111',
            'database_password' => ')1!1S7T37p',
            'database_prefix' => 'psmm_',
            'database_engine' => 'InnoDB',
            'mailer_transport' => 'smtp',
            'mailer_host' => '127.0.0.1',
            'mailer_user' => NULL,
            'mailer_password' => NULL,
            'secret' => 'qidyrksyroeyjcagrdpkmosafjrcdo9nswcuugjjkp8lnoptyazq4xdgysm0z6hy',
            'ps_caching' => 'CacheMemcache',
            'ps_cache_enable' => false,
            'ps_creation_date' => '2026-02-20',
            'locale' => 'en-US',
            'cookie_key' => 'nsjztixpsjjsgmyyyyadnq4pzhkphwi7uvor9vnfeofrgpeiz2rfu6r9c1cgxjir',
            'cookie_iv' => 'exz59dzt4hmrrfee0z4io2l28v4k6qq4',
            'use_debug_toolbar' => true,
            'api_public_key' => '[[public_key]]',
            'api_private_key' => '[[private_key]]',
            'cache.driver' => 'array',
            'cache.adapter' => 'cache.adapter.array',
            'kernel.bundles' => [

            ],
            'kernel.name' => 'app',
            'kernel.debug' => false,
            'kernel.environment' => 'prod',
            'kernel.app_id' => 'front',
            'kernel.cache_dir' => '/home/fletcher/public_html/fletchermall.com/var/cache/prod/',
            'kernel.active_modules' => [
                0 => 'blockreassurance',
                1 => 'blockwishlist',
                2 => 'contactform',
                3 => 'dashactivity',
                4 => 'dashgoals',
                5 => 'dashproducts',
                6 => 'dashtrends',
                7 => 'graphnvd3',
                8 => 'gridhtml',
                9 => 'gsitemap',
                10 => 'pagesnotfound',
                11 => 'productcomments',
                12 => 'psgdpr',
                13 => 'psshipping',
                14 => 'psxmarketingwithgoogle',
                15 => 'ps_accounts',
                16 => 'ps_apiresources',
                17 => 'ps_banner',
                18 => 'ps_bestsellers',
                19 => 'ps_brandlist',
                20 => 'ps_cashondelivery',
                21 => 'ps_categoryproducts',
                22 => 'ps_categorytree',
                23 => 'ps_checkout',
                24 => 'ps_checkpayment',
                25 => 'ps_classic_edition',
                26 => 'ps_contactinfo',
                27 => 'ps_crossselling',
                28 => 'ps_currencyselector',
                29 => 'ps_customeraccountlinks',
                30 => 'ps_customersignin',
                31 => 'ps_customtext',
                32 => 'ps_dataprivacy',
                33 => 'ps_distributionapiclient',
                34 => 'ps_emailalerts',
                35 => 'ps_emailsubscription',
                36 => 'ps_eventbus',
                37 => 'ps_facebook',
                38 => 'ps_facetedsearch',
                39 => 'ps_faviconnotificationbo',
                40 => 'ps_featuredproducts',
                41 => 'ps_googleanalytics',
                42 => 'ps_imageslider',
                43 => 'ps_languageselector',
                44 => 'ps_linklist',
                45 => 'ps_mainmenu',
                46 => 'ps_mbo',
                47 => 'ps_newproducts',
                48 => 'ps_searchbar',
                49 => 'ps_sharebuttons',
                50 => 'ps_shoppingcart',
                51 => 'ps_socialfollow',
                52 => 'ps_specials',
                53 => 'ps_supplierlist',
                54 => 'ps_themecusto',
                55 => 'ps_viewedproduct',
                56 => 'ps_wirepayment',
                57 => 'statsbestcategories',
                58 => 'statsbestcustomers',
                59 => 'statsbestmanufacturers',
                60 => 'statsbestproducts',
                61 => 'statsbestsuppliers',
                62 => 'statsbestvouchers',
                63 => 'statscarrier',
                64 => 'statscatalog',
                65 => 'statscheckup',
                66 => 'statsdata',
                67 => 'statsforecast',
                68 => 'statsnewsletter',
                69 => 'statspersonalinfos',
                70 => 'statsproduct',
                71 => 'statsregistrations',
                72 => 'statssales',
                73 => 'statssearch',
                74 => 'statsstock',
            ],
            'prestashop.active_modules' => [
                0 => 'blockreassurance',
                1 => 'blockwishlist',
                2 => 'contactform',
                3 => 'dashactivity',
                4 => 'dashgoals',
                5 => 'dashproducts',
                6 => 'dashtrends',
                7 => 'graphnvd3',
                8 => 'gridhtml',
                9 => 'gsitemap',
                10 => 'pagesnotfound',
                11 => 'productcomments',
                12 => 'psgdpr',
                13 => 'psshipping',
                14 => 'psxmarketingwithgoogle',
                15 => 'ps_accounts',
                16 => 'ps_apiresources',
                17 => 'ps_banner',
                18 => 'ps_bestsellers',
                19 => 'ps_brandlist',
                20 => 'ps_cashondelivery',
                21 => 'ps_categoryproducts',
                22 => 'ps_categorytree',
                23 => 'ps_checkout',
                24 => 'ps_checkpayment',
                25 => 'ps_classic_edition',
                26 => 'ps_contactinfo',
                27 => 'ps_crossselling',
                28 => 'ps_currencyselector',
                29 => 'ps_customeraccountlinks',
                30 => 'ps_customersignin',
                31 => 'ps_customtext',
                32 => 'ps_dataprivacy',
                33 => 'ps_distributionapiclient',
                34 => 'ps_emailalerts',
                35 => 'ps_emailsubscription',
                36 => 'ps_eventbus',
                37 => 'ps_facebook',
                38 => 'ps_facetedsearch',
                39 => 'ps_faviconnotificationbo',
                40 => 'ps_featuredproducts',
                41 => 'ps_googleanalytics',
                42 => 'ps_imageslider',
                43 => 'ps_languageselector',
                44 => 'ps_linklist',
                45 => 'ps_mainmenu',
                46 => 'ps_mbo',
                47 => 'ps_newproducts',
                48 => 'ps_searchbar',
                49 => 'ps_sharebuttons',
                50 => 'ps_shoppingcart',
                51 => 'ps_socialfollow',
                52 => 'ps_specials',
                53 => 'ps_supplierlist',
                54 => 'ps_themecusto',
                55 => 'ps_viewedproduct',
                56 => 'ps_wirepayment',
                57 => 'statsbestcategories',
                58 => 'statsbestcustomers',
                59 => 'statsbestmanufacturers',
                60 => 'statsbestproducts',
                61 => 'statsbestsuppliers',
                62 => 'statsbestvouchers',
                63 => 'statscarrier',
                64 => 'statscatalog',
                65 => 'statscheckup',
                66 => 'statsdata',
                67 => 'statsforecast',
                68 => 'statsnewsletter',
                69 => 'statspersonalinfos',
                70 => 'statsproduct',
                71 => 'statsregistrations',
                72 => 'statssales',
                73 => 'statssearch',
                74 => 'statsstock',
            ],
            'prestashop.installed_modules' => [
                0 => 'blockreassurance',
                1 => 'blockwishlist',
                2 => 'contactform',
                3 => 'dashactivity',
                4 => 'dashgoals',
                5 => 'dashproducts',
                6 => 'dashtrends',
                7 => 'graphnvd3',
                8 => 'gridhtml',
                9 => 'gsitemap',
                10 => 'pagesnotfound',
                11 => 'productcomments',
                12 => 'psgdpr',
                13 => 'psshipping',
                14 => 'psxmarketingwithgoogle',
                15 => 'ps_accounts',
                16 => 'ps_apiresources',
                17 => 'ps_banner',
                18 => 'ps_bestsellers',
                19 => 'ps_brandlist',
                20 => 'ps_cashondelivery',
                21 => 'ps_categoryproducts',
                22 => 'ps_categorytree',
                23 => 'ps_checkout',
                24 => 'ps_checkpayment',
                25 => 'ps_classic_edition',
                26 => 'ps_contactinfo',
                27 => 'ps_crossselling',
                28 => 'ps_currencyselector',
                29 => 'ps_customeraccountlinks',
                30 => 'ps_customersignin',
                31 => 'ps_customtext',
                32 => 'ps_dataprivacy',
                33 => 'ps_distributionapiclient',
                34 => 'ps_emailalerts',
                35 => 'ps_emailsubscription',
                36 => 'ps_eventbus',
                37 => 'ps_facebook',
                38 => 'ps_facetedsearch',
                39 => 'ps_faviconnotificationbo',
                40 => 'ps_featuredproducts',
                41 => 'ps_googleanalytics',
                42 => 'ps_imageslider',
                43 => 'ps_languageselector',
                44 => 'ps_linklist',
                45 => 'ps_mainmenu',
                46 => 'ps_mbo',
                47 => 'ps_newproducts',
                48 => 'ps_searchbar',
                49 => 'ps_sharebuttons',
                50 => 'ps_shoppingcart',
                51 => 'ps_socialfollow',
                52 => 'ps_specials',
                53 => 'ps_supplierlist',
                54 => 'ps_themecusto',
                55 => 'ps_viewedproduct',
                56 => 'ps_wirepayment',
                57 => 'statsbestcategories',
                58 => 'statsbestcustomers',
                59 => 'statsbestmanufacturers',
                60 => 'statsbestproducts',
                61 => 'statsbestsuppliers',
                62 => 'statsbestvouchers',
                63 => 'statscarrier',
                64 => 'statscatalog',
                65 => 'statscheckup',
                66 => 'statsdata',
                67 => 'statsforecast',
                68 => 'statsnewsletter',
                69 => 'statspersonalinfos',
                70 => 'statsproduct',
                71 => 'statsregistrations',
                72 => 'statssales',
                73 => 'statssearch',
                74 => 'statsstock',
            ],
            'prestashop.module_dir' => '/home/fletcher/public_html/fletchermall.com/modules/',
            'kernel.project_dir' => '/home/fletcher/public_html/fletchermall.com',
            'ps_cache_dir' => '/home/fletcher/public_html/fletchermall.com/var/cache/prod/',
            'mail_themes_uri' => '/mails/themes',
            'doctrine.dbal.logger.chain.class' => 'Doctrine\\DBAL\\Logging\\LoggerChain',
            'doctrine.dbal.logger.profiling.class' => 'Doctrine\\DBAL\\Logging\\DebugStack',
            'doctrine.dbal.logger.class' => 'Symfony\\Bridge\\Doctrine\\Logger\\DbalLogger',
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [

            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\ORM\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\ORM\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.metadata.attribute.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AttributeDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => false,
            'doctrine.orm.proxy_dir' => '/home/fletcher/public_html/fletchermall.com/var/cache/prod//doctrine/orm/Proxies',
            'doctrine.orm.proxy_namespace' => 'Proxies',
            'psshipping.sentry_dsn' => 'https://78c41abf489931010a3a83cacc14926b@o298402.ingest.sentry.io/4505906299600896',
            'psshipping.sentry_env' => 'production',
            'psshipping.ps_billing_sandbox' => 0,
            'psshipping.api_url' => 'https://shipping-api.prestashop.com',
            'psshipping.cloudsync_cdc_url' => 'https://assets.prestashop3.com/ext/cloudsync-merchant-sync-consent/latest/cloudsync-cdc.js',
            'psshipping.mbe_tracking_url' => 'https://www.mbe.it/en/tracking?c=@',
            'psshipping.segment_key' => '3XsHeI2dfKoKE2wReGp7IO2bLa5hbeVB',
            'psshipping.gel_proximity.end_user_url' => 'https://platform.gelproximity.com/gel-enduser-client/',
        ];
    }
}

class FeatureFlagRepositoryProxy1ddab28 extends \PrestaShopBundle\Entity\Repository\FeatureFlagRepository implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyProxyTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".'*'."\0".'_class' => [parent::class, '_class', null, 8],
        "\0".'*'."\0".'_em' => [parent::class, '_em', null, 8],
        "\0".'*'."\0".'_entityName' => [parent::class, '_entityName', null, 8],
        '_class' => [parent::class, '_class', null, 8],
        '_em' => [parent::class, '_em', null, 8],
        '_entityName' => [parent::class, '_entityName', null, 8],
    ];

    public function getByName(string $featureFlagName): ?\PrestaShopBundle\Entity\FeatureFlag
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getByName(...\func_get_args());
        }

        return parent::getByName(...\func_get_args());
    }

    public function isEnabled(string $featureFlagName): bool
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->isEnabled(...\func_get_args());
        }

        return parent::isEnabled(...\func_get_args());
    }

    public function isDisabled(string $featureFlagName): bool
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->isDisabled(...\func_get_args());
        }

        return parent::isDisabled(...\func_get_args());
    }

    public function enable(string $featureFlagName): void
    {
        if (isset($this->lazyObjectState)) {
            ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->enable(...\func_get_args());
        } else {
            parent::enable(...\func_get_args());
        }
    }

    public function disable(string $featureFlagName): void
    {
        if (isset($this->lazyObjectState)) {
            ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->disable(...\func_get_args());
        } else {
            parent::disable(...\func_get_args());
        }
    }
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class LegacyAdminTokenValidatorGhost2817cf2 extends \PrestaShopBundle\Security\Admin\LegacyAdminTokenValidator implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'employeeRepository' => [parent::class, 'employeeRepository', null, 530],
        "\0".parent::class."\0".'requestStack' => [parent::class, 'requestStack', null, 530],
        'employeeRepository' => [parent::class, 'employeeRepository', null, 530],
        'requestStack' => [parent::class, 'requestStack', null, 530],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class FeatureFlagManagerGhost61268b3 extends \PrestaShop\PrestaShop\Core\FeatureFlag\FeatureFlagManager implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'featureFlagRepository' => [parent::class, 'featureFlagRepository', null, 530],
        "\0".parent::class."\0".'featureFlagStates' => [parent::class, 'featureFlagStates', null, 16],
        "\0".parent::class."\0".'locator' => [parent::class, 'locator', null, 530],
        'featureFlagRepository' => [parent::class, 'featureFlagRepository', null, 530],
        'featureFlagStates' => [parent::class, 'featureFlagStates', null, 16],
        'locator' => [parent::class, 'locator', null, 530],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class DbLayerGhostB471b8b extends \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DbLayer implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".'*'."\0".'featureFlagRepository' => [parent::class, 'featureFlagRepository', parent::class, 522],
        'featureFlagRepository' => [parent::class, 'featureFlagRepository', parent::class, 522],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class DotEnvLayerGhost71d5ebb extends \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\DotEnvLayer implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'environment' => [parent::class, 'environment', null, 16],
        "\0".parent::class."\0".'rootDir' => [parent::class, 'rootDir', null, 16],
        'environment' => [parent::class, 'environment', null, 16],
        'rootDir' => [parent::class, 'rootDir', null, 16],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class EnvLayerGhostEdbcd0e extends \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\EnvLayer implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class QueryLayerGhostEa7d94d extends \PrestaShop\PrestaShop\Core\FeatureFlag\Layer\QueryLayer implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyGhostTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'environment' => [parent::class, 'environment', null, 16],
        "\0".parent::class."\0".'requestStack' => [parent::class, 'requestStack', null, 16],
        'environment' => [parent::class, 'environment', null, 16],
        'requestStack' => [parent::class, 'requestStack', null, 16],
    ];
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class RequestStackProxyA9608a6 extends \Symfony\Component\HttpFoundation\RequestStack implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyProxyTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'requests' => [parent::class, 'requests', null, 16],
        'requests' => [parent::class, 'requests', null, 16],
    ];

    public function pop(): ?\Symfony\Component\HttpFoundation\Request
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->pop(...\func_get_args());
        }

        return parent::pop(...\func_get_args());
    }

    public function getCurrentRequest(): ?\Symfony\Component\HttpFoundation\Request
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getCurrentRequest(...\func_get_args());
        }

        return parent::getCurrentRequest(...\func_get_args());
    }

    public function getMainRequest(): ?\Symfony\Component\HttpFoundation\Request
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getMainRequest(...\func_get_args());
        }

        return parent::getMainRequest(...\func_get_args());
    }

    public function getParentRequest(): ?\Symfony\Component\HttpFoundation\Request
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getParentRequest(...\func_get_args());
        }

        return parent::getParentRequest(...\func_get_args());
    }

    public function getSession(): \Symfony\Component\HttpFoundation\Session\SessionInterface
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->getSession(...\func_get_args());
        }

        return parent::getSession(...\func_get_args());
    }

    public function resetRequestFormats(): void
    {
        if (isset($this->lazyObjectState)) {
            ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->resetRequestFormats(...\func_get_args());
        } else {
            parent::resetRequestFormats(...\func_get_args());
        }
    }
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);

class EntityManagerProxyCaac541 extends \Doctrine\ORM\EntityManager implements \Symfony\Component\VarExporter\LazyObjectInterface
{
    use \Symfony\Component\VarExporter\LazyProxyTrait;

    private const LAZY_OBJECT_PROPERTY_SCOPES = [
        "\0".parent::class."\0".'cache' => [parent::class, 'cache', null, 16],
        "\0".parent::class."\0".'closed' => [parent::class, 'closed', null, 16],
        "\0".parent::class."\0".'config' => [parent::class, 'config', null, 16],
        "\0".parent::class."\0".'conn' => [parent::class, 'conn', null, 16],
        "\0".parent::class."\0".'eventManager' => [parent::class, 'eventManager', null, 16],
        "\0".parent::class."\0".'expressionBuilder' => [parent::class, 'expressionBuilder', null, 16],
        "\0".parent::class."\0".'filterCollection' => [parent::class, 'filterCollection', null, 16],
        "\0".parent::class."\0".'metadataFactory' => [parent::class, 'metadataFactory', null, 16],
        "\0".parent::class."\0".'proxyFactory' => [parent::class, 'proxyFactory', null, 16],
        "\0".parent::class."\0".'repositoryFactory' => [parent::class, 'repositoryFactory', null, 16],
        "\0".parent::class."\0".'unitOfWork' => [parent::class, 'unitOfWork', null, 16],
        'cache' => [parent::class, 'cache', null, 16],
        'closed' => [parent::class, 'closed', null, 16],
        'config' => [parent::class, 'config', null, 16],
        'conn' => [parent::class, 'conn', null, 16],
        'eventManager' => [parent::class, 'eventManager', null, 16],
        'expressionBuilder' => [parent::class, 'expressionBuilder', null, 16],
        'filterCollection' => [parent::class, 'filterCollection', null, 16],
        'metadataFactory' => [parent::class, 'metadataFactory', null, 16],
        'proxyFactory' => [parent::class, 'proxyFactory', null, 16],
        'repositoryFactory' => [parent::class, 'repositoryFactory', null, 16],
        'unitOfWork' => [parent::class, 'unitOfWork', null, 16],
    ];

    public function isUninitializedObject($obj): bool
    {
        if (isset($this->lazyObjectState)) {
            return ($this->lazyObjectState->realInstance ??= ($this->lazyObjectState->initializer)())->isUninitializedObject(...\func_get_args());
        }

        return parent::isUninitializedObject(...\func_get_args());
    }
}

// Help opcache.preload discover always-needed symbols
class_exists(\Symfony\Component\VarExporter\Internal\Hydrator::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectRegistry::class);
class_exists(\Symfony\Component\VarExporter\Internal\LazyObjectState::class);
