<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/OSL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

namespace PrestaShop\PrestaShop\Core\Domain\Currency\Exception;

use Throwable;

/**
 * Class InvalidUnofficialCurrencyException is thrown when an invalid currency
 * is being added (matching an ISO code from CLDR database)
 */
class InvalidUnofficialCurrencyException extends CurrencyException
{
    /** @var string */
    private $isoCode;

    /**
     * @param string $message the Exception message to throw
     * @param string $isoCode Invalid currency ISO code
     * @param int $code [optional] The Exception code
     * @param Throwable $previous [optional] The previous throwable used for the exception chaining
     */
    public function __construct($message, $isoCode, $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->isoCode = $isoCode;
    }

    /**
     * @return string
     */
    public function getIsoCode(): string
    {
        return $this->isoCode;
    }
}
